/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.request;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestEntityCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class GameRequestEntity
implements SafeParcelable,
GameRequest {
    public static final Parcelable.Creator<GameRequestEntity> CREATOR = new GameRequestEntityCreator();
    private final int zzCY;
    private final GameEntity zzaud;
    private final PlayerEntity zzavf;
    private final byte[] zzauL;
    private final String zzDK;
    private final ArrayList<PlayerEntity> zzavg;
    private final int zzSq;
    private final long zzaue;
    private final long zzavh;
    private final Bundle zzavi;
    private final int zzwS;

    public GameRequestEntity(GameRequest request) {
        this.zzCY = 2;
        this.zzaud = new GameEntity(request.getGame());
        this.zzavf = new PlayerEntity(request.getSender());
        this.zzDK = request.getRequestId();
        this.zzSq = request.getType();
        this.zzaue = request.getCreationTimestamp();
        this.zzavh = request.getExpirationTimestamp();
        this.zzwS = request.getStatus();
        byte[] byArray = request.getData();
        if (byArray == null) {
            this.zzauL = null;
        } else {
            this.zzauL = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.zzauL, 0, byArray.length);
        }
        List<Player> list = request.getRecipients();
        int n = list.size();
        this.zzavg = new ArrayList(n);
        this.zzavi = new Bundle();
        for (int i = 0; i < n; ++i) {
            Player player = (Player)list.get(i).freeze();
            String string2 = player.getPlayerId();
            this.zzavg.add((PlayerEntity)player);
            this.zzavi.putInt(string2, request.getRecipientStatus(string2));
        }
    }

    GameRequestEntity(int versionCode, GameEntity game, PlayerEntity sender, byte[] data, String requestId, ArrayList<PlayerEntity> recipients, int type, long creationTimestamp, long expirationTimestamp, Bundle recipientStatuses, int status) {
        this.zzCY = versionCode;
        this.zzaud = game;
        this.zzavf = sender;
        this.zzauL = data;
        this.zzDK = requestId;
        this.zzavg = recipients;
        this.zzSq = type;
        this.zzaue = creationTimestamp;
        this.zzavh = expirationTimestamp;
        this.zzavi = recipientStatuses;
        this.zzwS = status;
    }

    public int getVersionCode() {
        return this.zzCY;
    }

    @Override
    public String getRequestId() {
        return this.zzDK;
    }

    @Override
    public Game getGame() {
        return this.zzaud;
    }

    @Override
    public Player getSender() {
        return this.zzavf;
    }

    @Override
    public List<Player> getRecipients() {
        return new ArrayList<Player>(this.zzavg);
    }

    @Override
    public boolean isConsumed(String playerId) {
        return this.getRecipientStatus(playerId) == 1;
    }

    @Override
    public byte[] getData() {
        return this.zzauL;
    }

    @Override
    public int getType() {
        return this.zzSq;
    }

    @Override
    public long getCreationTimestamp() {
        return this.zzaue;
    }

    @Override
    public long getExpirationTimestamp() {
        return this.zzavh;
    }

    @Override
    public int getRecipientStatus(String playerId) {
        return this.zzavi.getInt(playerId, 0);
    }

    @Override
    public int getStatus() {
        return this.zzwS;
    }

    public Bundle zztP() {
        return this.zzavi;
    }

    @Override
    public GameRequest freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameRequestEntity.zza(this);
    }

    static int zza(GameRequest gameRequest) {
        return zzt.hashCode(gameRequest.getGame(), gameRequest.getRecipients(), gameRequest.getRequestId(), gameRequest.getSender(), GameRequestEntity.zzb(gameRequest), gameRequest.getType(), gameRequest.getCreationTimestamp(), gameRequest.getExpirationTimestamp());
    }

    public boolean equals(Object obj) {
        return GameRequestEntity.zza(this, obj);
    }

    static boolean zza(GameRequest gameRequest, Object object) {
        if (!(object instanceof GameRequest)) {
            return false;
        }
        if (gameRequest == object) {
            return true;
        }
        GameRequest gameRequest2 = (GameRequest)object;
        return zzt.equal(gameRequest2.getGame(), gameRequest.getGame()) && zzt.equal(gameRequest2.getRecipients(), gameRequest.getRecipients()) && zzt.equal(gameRequest2.getRequestId(), gameRequest.getRequestId()) && zzt.equal(gameRequest2.getSender(), gameRequest.getSender()) && Arrays.equals(GameRequestEntity.zzb(gameRequest2), GameRequestEntity.zzb(gameRequest)) && zzt.equal(gameRequest2.getType(), gameRequest.getType()) && zzt.equal(gameRequest2.getCreationTimestamp(), gameRequest.getCreationTimestamp()) && zzt.equal(gameRequest2.getExpirationTimestamp(), gameRequest.getExpirationTimestamp());
    }

    private static int[] zzb(GameRequest gameRequest) {
        List<Player> list = gameRequest.getRecipients();
        int n = list.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = gameRequest.getRecipientStatus(list.get(i).getPlayerId());
        }
        return nArray;
    }

    public String toString() {
        return GameRequestEntity.zzc(this);
    }

    static String zzc(GameRequest gameRequest) {
        return zzt.zzt(gameRequest).zzg("Game", gameRequest.getGame()).zzg("Sender", gameRequest.getSender()).zzg("Recipients", gameRequest.getRecipients()).zzg("Data", gameRequest.getData()).zzg("RequestId", gameRequest.getRequestId()).zzg("Type", gameRequest.getType()).zzg("CreationTimestamp", gameRequest.getCreationTimestamp()).zzg("ExpirationTimestamp", gameRequest.getExpirationTimestamp()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        GameRequestEntityCreator.zza(this, dest, flags);
    }
}

