/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.AndExpression;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.BooleanExpression;
import net.sf.saxon.expr.DifferenceEnumeration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.IntersectionEnumeration;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.OrExpression;
import net.sf.saxon.expr.PairIterator;
import net.sf.saxon.expr.SingletonIntersectExpression;
import net.sf.saxon.expr.SlashExpression;
import net.sf.saxon.expr.SubExpressionInfo;
import net.sf.saxon.expr.UnionEnumeration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.expr.parser.Token;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.expr.sort.DocumentOrderIterator;
import net.sf.saxon.expr.sort.DocumentSorter;
import net.sf.saxon.expr.sort.GlobalOrderComparer;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.ExceptPattern;
import net.sf.saxon.pattern.IntersectPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.PatternSponsor;
import net.sf.saxon.pattern.UnionPattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VennExpression
extends BinaryExpression {
    public VennExpression(Expression p1, int op, Expression p2) {
        super(p1, op, p2);
    }

    @Override
    public String getExpressionName() {
        switch (this.operator) {
            case 1: {
                return "union";
            }
            case 23: {
                return "intersect";
            }
            case 24: {
                return "except";
            }
        }
        return "unknown";
    }

    @Override
    public final ItemType getItemType(TypeHierarchy th) {
        ItemType t1 = this.operand0.getItemType(th);
        if (this.operator == 1) {
            ItemType t2 = this.operand1.getItemType(th);
            return Type.getCommonSuperType(t1, t2, th);
        }
        return t1;
    }

    @Override
    public final int computeCardinality() {
        int c1 = this.operand0.getCardinality();
        int c2 = this.operand1.getCardinality();
        switch (this.operator) {
            case 1: {
                if (Literal.isEmptySequence(this.operand0)) {
                    return c2;
                }
                if (Literal.isEmptySequence(this.operand1)) {
                    return c1;
                }
                return c1 | c2 | 0x4000 | 0x8000;
            }
            case 23: {
                if (Literal.isEmptySequence(this.operand0)) {
                    return 8192;
                }
                if (Literal.isEmptySequence(this.operand1)) {
                    return 8192;
                }
                return c1 & c2 | 0x2000 | 0x4000;
            }
            case 24: {
                if (Literal.isEmptySequence(this.operand0)) {
                    return 8192;
                }
                if (Literal.isEmptySequence(this.operand1)) {
                    return c1;
                }
                return c1 | 0x2000 | 0x4000;
            }
        }
        return 57344;
    }

    @Override
    public int computeSpecialProperties() {
        int prop0 = this.operand0.getSpecialProperties();
        int prop1 = this.operand1.getSpecialProperties();
        int props = 131072;
        if (this.testContextDocumentNodeSet(prop0, prop1)) {
            props |= 0x10000;
        }
        if (this.testSubTree(prop0, prop1)) {
            props |= 0x100000;
        }
        if (!this.testCreative(prop0, prop1)) {
            props |= 0x400000;
        }
        return props;
    }

    private boolean testContextDocumentNodeSet(int prop0, int prop1) {
        switch (this.operator) {
            case 1: {
                return (prop0 & prop1 & 0x10000) != 0;
            }
            case 23: {
                return ((prop0 | prop1) & 0x10000) != 0;
            }
            case 24: {
                return (prop0 & 0x10000) != 0;
            }
        }
        return false;
    }

    public void gatherComponents(int operator, Set set) {
        if (this.operand0 instanceof VennExpression && ((VennExpression)this.operand0).operator == operator) {
            ((VennExpression)this.operand0).gatherComponents(operator, set);
        } else {
            set.add(this.operand0);
        }
        if (this.operand1 instanceof VennExpression && ((VennExpression)this.operand1).operator == operator) {
            ((VennExpression)this.operand1).gatherComponents(operator, set);
        } else {
            set.add(this.operand1);
        }
    }

    private boolean testSubTree(int prop0, int prop1) {
        switch (this.operator) {
            case 1: {
                return (prop0 & prop1 & 0x100000) != 0;
            }
            case 23: {
                return ((prop0 | prop1) & 0x100000) != 0;
            }
            case 24: {
                return (prop0 & 0x100000) != 0;
            }
        }
        return false;
    }

    private boolean testCreative(int prop0, int prop1) {
        return (prop0 & 0x400000) == 0 || (prop1 & 0x400000) == 0;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.operand0 = visitor.simplify(this.operand0);
        this.operand1 = visitor.simplify(this.operand1);
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        ItemType t1;
        ItemType t0;
        TypeHierarchy th;
        this.operand0 = visitor.typeCheck(this.operand0, contextItemType);
        this.operand1 = visitor.typeCheck(this.operand1, contextItemType);
        if (!(this.operand0 instanceof PatternSponsor)) {
            RoleLocator role0 = new RoleLocator(1, Token.tokens[this.operator], 0);
            this.operand0 = TypeChecker.staticTypeCheck(this.operand0, SequenceType.NODE_SEQUENCE, false, role0, visitor);
        }
        if (!(this.operand1 instanceof PatternSponsor)) {
            RoleLocator role1 = new RoleLocator(1, Token.tokens[this.operator], 1);
            this.operand1 = TypeChecker.staticTypeCheck(this.operand1, SequenceType.NODE_SEQUENCE, false, role1, visitor);
        }
        if (this.operator != 1 && (th = visitor.getConfiguration().getTypeHierarchy()).relationship(t0 = this.operand0.getItemType(th), t1 = this.operand1.getItemType(th)) == 4) {
            if (this.operator == 23) {
                return Literal.makeEmptySequence();
            }
            if ((this.operand0.getSpecialProperties() & 0x20000) != 0) {
                return this.operand0;
            }
            return new DocumentSorter(this.operand0);
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        Expression e = super.optimize(visitor, contextItemType);
        if (e != this) {
            return e;
        }
        Configuration config = visitor.getConfiguration();
        TypeHierarchy th = config.getTypeHierarchy();
        switch (this.operator) {
            case 1: {
                if (Literal.isEmptySequence(this.operand0) && (this.operand1.getSpecialProperties() & 0x20000) != 0) {
                    return this.operand1;
                }
                if (!Literal.isEmptySequence(this.operand1) || (this.operand0.getSpecialProperties() & 0x20000) == 0) break;
                return this.operand0;
            }
            case 23: {
                if (Literal.isEmptySequence(this.operand0)) {
                    return this.operand0;
                }
                if (!Literal.isEmptySequence(this.operand1)) break;
                return this.operand1;
            }
            case 24: {
                if (Literal.isEmptySequence(this.operand0)) {
                    return this.operand0;
                }
                if (!Literal.isEmptySequence(this.operand1) || (this.operand0.getSpecialProperties() & 0x20000) == 0) break;
                return this.operand0;
            }
        }
        if (this.operand0 instanceof AxisExpression && this.operand1 instanceof AxisExpression) {
            AxisExpression a1 = (AxisExpression)this.operand0;
            AxisExpression a2 = (AxisExpression)this.operand1;
            if (a1.getAxis() == a2.getAxis()) {
                AxisExpression ax = new AxisExpression(a1.getAxis(), new CombinedNodeTest(a1.getNodeTest(), this.operator, a2.getNodeTest()));
                ExpressionTool.copyLocationInfo(this, ax);
                return ax;
            }
        }
        if (this.operand0 instanceof SlashExpression && this.operand1 instanceof SlashExpression && this.operator == 1) {
            SlashExpression path1 = (SlashExpression)this.operand0;
            SlashExpression path2 = (SlashExpression)this.operand1;
            if (path1.getFirstStep().equals(path2.getFirstStep())) {
                VennExpression venn = new VennExpression(path1.getRemainingSteps(), this.operator, path2.getRemainingSteps());
                ExpressionTool.copyLocationInfo(this, venn);
                Expression path = ExpressionTool.makePathExpression(path1.getFirstStep(), venn, false);
                ExpressionTool.copyLocationInfo(this, path);
                return visitor.optimize(path, contextItemType);
            }
        }
        if (this.operand0 instanceof FilterExpression && this.operand1 instanceof FilterExpression) {
            FilterExpression exp0 = (FilterExpression)this.operand0;
            FilterExpression exp1 = (FilterExpression)this.operand1;
            if (!exp0.isPositional(th) && !exp1.isPositional(th) && exp0.getControllingExpression().equals(exp1.getControllingExpression())) {
                BooleanExpression filter;
                switch (this.operator) {
                    case 1: {
                        filter = new OrExpression(exp0.getFilter(), exp1.getFilter());
                        break;
                    }
                    case 23: {
                        filter = new AndExpression(exp0.getFilter(), exp1.getFilter());
                        break;
                    }
                    case 24: {
                        FunctionCall negate2 = SystemFunctionCall.makeSystemFunction("not", new Expression[]{exp1.getFilter()});
                        filter = new AndExpression(exp0.getFilter(), negate2);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unknown operator " + this.operator));
                    }
                }
                ExpressionTool.copyLocationInfo(this, filter);
                FilterExpression f = new FilterExpression(exp0.getControllingExpression(), filter);
                ExpressionTool.copyLocationInfo(this, f);
                return f.simplify(visitor).typeCheck(visitor, contextItemType).optimize(visitor, contextItemType);
            }
        }
        if (!visitor.isOptimizeForStreaming() && this.operator == 1 && this.operand0 instanceof AxisExpression && this.operand1 instanceof AxisExpression) {
            AxisExpression a0 = (AxisExpression)this.operand0;
            AxisExpression a1 = (AxisExpression)this.operand1;
            if (a0.getAxis() == 2 && a1.getAxis() == 3) {
                Block b = new Block();
                b.setChildren(new Expression[]{this.operand0, this.operand1});
                return b;
            }
            if (a1.getAxis() == 2 && a0.getAxis() == 3) {
                Block b = new Block();
                b.setChildren(new Expression[]{this.operand1, this.operand0});
                return b;
            }
        }
        if (this.operator == 23 && !Cardinality.allowsMany(this.operand0.getCardinality())) {
            return new SingletonIntersectExpression(this.operand0, this.operator, ExpressionTool.unsorted(config.obtainOptimizer(), this.operand1, false));
        }
        if (this.operator == 23 && !Cardinality.allowsMany(this.operand1.getCardinality())) {
            return new SingletonIntersectExpression(this.operand1, this.operator, ExpressionTool.unsorted(config.obtainOptimizer(), this.operand0, false));
        }
        if (this.operandsAreDisjoint(th)) {
            if (this.operator == 23) {
                return Literal.makeEmptySequence();
            }
            if (this.operator == 24) {
                if ((this.operand0.getSpecialProperties() & 0x20000) != 0) {
                    return this.operand0;
                }
                return new DocumentSorter(this.operand0);
            }
        }
        return this;
    }

    private boolean operandsAreDisjoint(TypeHierarchy th) {
        return th.relationship(this.operand0.getItemType(th), this.operand1.getItemType(th)) == 4;
    }

    @Override
    public Expression promote(PromotionOffer offer, Expression parent) throws XPathException {
        if (offer.action == 13) {
            if (this.operator == 1 && this.operandsAreDisjoint(offer.getOptimizer().getConfiguration().getTypeHierarchy())) {
                Block block = new Block();
                block.setChildren(new Expression[]{this.operand0, this.operand1});
                ExpressionTool.copyLocationInfo(this, block);
                return block;
            }
            Expression exp = offer.accept(parent, this);
            if (exp != null) {
                return exp;
            }
            if (offer.action == 13) {
                this.operand0 = this.doPromotion(this.operand0, offer);
                this.operand1 = this.doPromotion(this.operand1, offer);
            }
            return this;
        }
        return super.promote(offer, parent);
    }

    @Override
    public Expression copy() {
        return new VennExpression(this.operand0.copy(), this.operator, this.operand1.copy());
    }

    @Override
    public Iterator<SubExpressionInfo> iterateSubExpressionInfo() {
        SubExpressionInfo i0 = new SubExpressionInfo(this.operand0, true, false, 2);
        SubExpressionInfo i1 = new SubExpressionInfo(this.operand1, true, false, 2);
        return new PairIterator<SubExpressionInfo>(i0, i1);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof VennExpression) {
            VennExpression b = (VennExpression)other;
            if (this.operator != b.operator) {
                return false;
            }
            if (this.operand0.equals(b.operand0) && this.operand1.equals(b.operand1)) {
                return true;
            }
            if (this.operator == 1 || this.operator == 23) {
                HashSet s0 = new HashSet(10);
                this.gatherComponents(this.operator, s0);
                HashSet s1 = new HashSet(10);
                ((VennExpression)other).gatherComponents(this.operator, s1);
                return s0.equals(s1);
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.operand0.hashCode() ^ this.operand1.hashCode();
    }

    @Override
    public Pattern toPattern(Configuration config, boolean is30) throws XPathException {
        if (this.operator == 1) {
            return new UnionPattern(this.operand0.toPattern(config, is30), this.operand1.toPattern(config, is30));
        }
        if (is30) {
            if (this.operator == 24) {
                return new ExceptPattern(this.operand0.toPattern(config, is30), this.operand1.toPattern(config, is30));
            }
            return new IntersectPattern(this.operand0.toPattern(config, is30), this.operand1.toPattern(config, is30));
        }
        throw new XPathException("Cannot use intersect or except in an XSLT 2.0 pattern");
    }

    public SequenceIterator iterate(XPathContext c) throws XPathException {
        DocumentOrderIterator i1 = this.operand0.iterate(c);
        if ((this.operand0.getSpecialProperties() & 0x20000) == 0) {
            i1 = new DocumentOrderIterator(i1, GlobalOrderComparer.getInstance());
        }
        DocumentOrderIterator i2 = this.operand1.iterate(c);
        if ((this.operand1.getSpecialProperties() & 0x20000) == 0) {
            i2 = new DocumentOrderIterator(i2, GlobalOrderComparer.getInstance());
        }
        switch (this.operator) {
            case 1: {
                return new UnionEnumeration(i1, i2, GlobalOrderComparer.getInstance());
            }
            case 23: {
                return new IntersectionEnumeration(i1, i2, GlobalOrderComparer.getInstance());
            }
            case 24: {
                return new DifferenceEnumeration(i1, i2, GlobalOrderComparer.getInstance());
            }
        }
        throw new UnsupportedOperationException("Unknown operator in Venn Expression");
    }

    @Override
    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        if (this.operator == 1) {
            return this.operand0.effectiveBooleanValue(context) || this.operand1.effectiveBooleanValue(context);
        }
        return super.effectiveBooleanValue(context);
    }
}

