// Copyright 2023-2024 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        (unknown)
// source: buf/registry/owner/v1/user_service.proto

package ownerv1

import (
	_ "buf.build/gen/go/bufbuild/protovalidate/protocolbuffers/go/buf/validate"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The list order.
type ListUsersRequest_Order int32

const (
	ListUsersRequest_ORDER_UNSPECIFIED ListUsersRequest_Order = 0
	// Order by create_time newest to oldest.
	ListUsersRequest_ORDER_CREATE_TIME_DESC ListUsersRequest_Order = 1
	// Order by create_time oldest to newest.
	ListUsersRequest_ORDER_CREATE_TIME_ASC ListUsersRequest_Order = 2
)

// Enum value maps for ListUsersRequest_Order.
var (
	ListUsersRequest_Order_name = map[int32]string{
		0: "ORDER_UNSPECIFIED",
		1: "ORDER_CREATE_TIME_DESC",
		2: "ORDER_CREATE_TIME_ASC",
	}
	ListUsersRequest_Order_value = map[string]int32{
		"ORDER_UNSPECIFIED":      0,
		"ORDER_CREATE_TIME_DESC": 1,
		"ORDER_CREATE_TIME_ASC":  2,
	}
)

func (x ListUsersRequest_Order) Enum() *ListUsersRequest_Order {
	p := new(ListUsersRequest_Order)
	*p = x
	return p
}

func (x ListUsersRequest_Order) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ListUsersRequest_Order) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_registry_owner_v1_user_service_proto_enumTypes[0].Descriptor()
}

func (ListUsersRequest_Order) Type() protoreflect.EnumType {
	return &file_buf_registry_owner_v1_user_service_proto_enumTypes[0]
}

func (x ListUsersRequest_Order) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ListUsersRequest_Order.Descriptor instead.
func (ListUsersRequest_Order) EnumDescriptor() ([]byte, []int) {
	return file_buf_registry_owner_v1_user_service_proto_rawDescGZIP(), []int{2, 0}
}

type GetUsersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Users to request.
	UserRefs []*UserRef `protobuf:"bytes,1,rep,name=user_refs,json=userRefs,proto3" json:"user_refs,omitempty"`
}

func (x *GetUsersRequest) Reset() {
	*x = GetUsersRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_owner_v1_user_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetUsersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetUsersRequest) ProtoMessage() {}

func (x *GetUsersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_owner_v1_user_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetUsersRequest.ProtoReflect.Descriptor instead.
func (*GetUsersRequest) Descriptor() ([]byte, []int) {
	return file_buf_registry_owner_v1_user_service_proto_rawDescGZIP(), []int{0}
}

func (x *GetUsersRequest) GetUserRefs() []*UserRef {
	if x != nil {
		return x.UserRefs
	}
	return nil
}

type GetUsersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The retrieved Users in the same order as requested.
	Users []*User `protobuf:"bytes,1,rep,name=users,proto3" json:"users,omitempty"`
}

func (x *GetUsersResponse) Reset() {
	*x = GetUsersResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_owner_v1_user_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetUsersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetUsersResponse) ProtoMessage() {}

func (x *GetUsersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_owner_v1_user_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetUsersResponse.ProtoReflect.Descriptor instead.
func (*GetUsersResponse) Descriptor() ([]byte, []int) {
	return file_buf_registry_owner_v1_user_service_proto_rawDescGZIP(), []int{1}
}

func (x *GetUsersResponse) GetUsers() []*User {
	if x != nil {
		return x.Users
	}
	return nil
}

type ListUsersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The maximum number of items to return.
	//
	// The default value is 10.
	PageSize uint32 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The page to start from.
	//
	// If empty, the first page is returned.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The specific Organizations to list Users for.
	//
	// If this is empty, all Users for all Organizations are listed, but this functionality
	// is limited to Users with the necessary permissions.
	OrganizationRefs []*OrganizationRef `protobuf:"bytes,3,rep,name=organization_refs,json=organizationRefs,proto3" json:"organization_refs,omitempty"`
	// The order to return the Users.
	//
	// If not specified, defaults to ORDER_CREATE_TIME_DESC.
	Order ListUsersRequest_Order `protobuf:"varint,4,opt,name=order,proto3,enum=buf.registry.owner.v1.ListUsersRequest_Order" json:"order,omitempty"`
	// Only return Users of these types.
	HasTypes []UserType `protobuf:"varint,5,rep,packed,name=has_types,json=hasTypes,proto3,enum=buf.registry.owner.v1.UserType" json:"has_types,omitempty"`
	// Only return Users of these states.
	HasStates []UserState `protobuf:"varint,6,rep,packed,name=has_states,json=hasStates,proto3,enum=buf.registry.owner.v1.UserState" json:"has_states,omitempty"`
}

func (x *ListUsersRequest) Reset() {
	*x = ListUsersRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_owner_v1_user_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListUsersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListUsersRequest) ProtoMessage() {}

func (x *ListUsersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_owner_v1_user_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListUsersRequest.ProtoReflect.Descriptor instead.
func (*ListUsersRequest) Descriptor() ([]byte, []int) {
	return file_buf_registry_owner_v1_user_service_proto_rawDescGZIP(), []int{2}
}

func (x *ListUsersRequest) GetPageSize() uint32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListUsersRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListUsersRequest) GetOrganizationRefs() []*OrganizationRef {
	if x != nil {
		return x.OrganizationRefs
	}
	return nil
}

func (x *ListUsersRequest) GetOrder() ListUsersRequest_Order {
	if x != nil {
		return x.Order
	}
	return ListUsersRequest_ORDER_UNSPECIFIED
}

func (x *ListUsersRequest) GetHasTypes() []UserType {
	if x != nil {
		return x.HasTypes
	}
	return nil
}

func (x *ListUsersRequest) GetHasStates() []UserState {
	if x != nil {
		return x.HasStates
	}
	return nil
}

type ListUsersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The next page token.
	//
	// If empty, there are no more pages.
	NextPageToken string `protobuf:"bytes,1,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The list of Users.
	Users []*User `protobuf:"bytes,2,rep,name=users,proto3" json:"users,omitempty"`
}

func (x *ListUsersResponse) Reset() {
	*x = ListUsersResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_owner_v1_user_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListUsersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListUsersResponse) ProtoMessage() {}

func (x *ListUsersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_owner_v1_user_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListUsersResponse.ProtoReflect.Descriptor instead.
func (*ListUsersResponse) Descriptor() ([]byte, []int) {
	return file_buf_registry_owner_v1_user_service_proto_rawDescGZIP(), []int{3}
}

func (x *ListUsersResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListUsersResponse) GetUsers() []*User {
	if x != nil {
		return x.Users
	}
	return nil
}

type CreateUsersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Users to create.
	Values []*CreateUsersRequest_Value `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *CreateUsersRequest) Reset() {
	*x = CreateUsersRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_owner_v1_user_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateUsersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateUsersRequest) ProtoMessage() {}

func (x *CreateUsersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_owner_v1_user_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateUsersRequest.ProtoReflect.Descriptor instead.
func (*CreateUsersRequest) Descriptor() ([]byte, []int) {
	return file_buf_registry_owner_v1_user_service_proto_rawDescGZIP(), []int{4}
}

func (x *CreateUsersRequest) GetValues() []*CreateUsersRequest_Value {
	if x != nil {
		return x.Values
	}
	return nil
}

type CreateUsersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The created Users in the same order as given on the request.
	Users []*User `protobuf:"bytes,1,rep,name=users,proto3" json:"users,omitempty"`
}

func (x *CreateUsersResponse) Reset() {
	*x = CreateUsersResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_owner_v1_user_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateUsersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateUsersResponse) ProtoMessage() {}

func (x *CreateUsersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_owner_v1_user_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateUsersResponse.ProtoReflect.Descriptor instead.
func (*CreateUsersResponse) Descriptor() ([]byte, []int) {
	return file_buf_registry_owner_v1_user_service_proto_rawDescGZIP(), []int{5}
}

func (x *CreateUsersResponse) GetUsers() []*User {
	if x != nil {
		return x.Users
	}
	return nil
}

type UpdateUsersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Users to update.
	Values []*UpdateUsersRequest_Value `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *UpdateUsersRequest) Reset() {
	*x = UpdateUsersRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_owner_v1_user_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateUsersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateUsersRequest) ProtoMessage() {}

func (x *UpdateUsersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_owner_v1_user_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateUsersRequest.ProtoReflect.Descriptor instead.
func (*UpdateUsersRequest) Descriptor() ([]byte, []int) {
	return file_buf_registry_owner_v1_user_service_proto_rawDescGZIP(), []int{6}
}

func (x *UpdateUsersRequest) GetValues() []*UpdateUsersRequest_Value {
	if x != nil {
		return x.Values
	}
	return nil
}

type UpdateUsersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The updated Users in the same order as given on the request.
	Users []*User `protobuf:"bytes,1,rep,name=users,proto3" json:"users,omitempty"`
}

func (x *UpdateUsersResponse) Reset() {
	*x = UpdateUsersResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_owner_v1_user_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateUsersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateUsersResponse) ProtoMessage() {}

func (x *UpdateUsersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_owner_v1_user_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateUsersResponse.ProtoReflect.Descriptor instead.
func (*UpdateUsersResponse) Descriptor() ([]byte, []int) {
	return file_buf_registry_owner_v1_user_service_proto_rawDescGZIP(), []int{7}
}

func (x *UpdateUsersResponse) GetUsers() []*User {
	if x != nil {
		return x.Users
	}
	return nil
}

type DeleteUsersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Users to delete.
	UserRefs []*UserRef `protobuf:"bytes,1,rep,name=user_refs,json=userRefs,proto3" json:"user_refs,omitempty"`
}

func (x *DeleteUsersRequest) Reset() {
	*x = DeleteUsersRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_owner_v1_user_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteUsersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteUsersRequest) ProtoMessage() {}

func (x *DeleteUsersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_owner_v1_user_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteUsersRequest.ProtoReflect.Descriptor instead.
func (*DeleteUsersRequest) Descriptor() ([]byte, []int) {
	return file_buf_registry_owner_v1_user_service_proto_rawDescGZIP(), []int{8}
}

func (x *DeleteUsersRequest) GetUserRefs() []*UserRef {
	if x != nil {
		return x.UserRefs
	}
	return nil
}

type DeleteUsersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DeleteUsersResponse) Reset() {
	*x = DeleteUsersResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_owner_v1_user_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteUsersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteUsersResponse) ProtoMessage() {}

func (x *DeleteUsersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_owner_v1_user_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteUsersResponse.ProtoReflect.Descriptor instead.
func (*DeleteUsersResponse) Descriptor() ([]byte, []int) {
	return file_buf_registry_owner_v1_user_service_proto_rawDescGZIP(), []int{9}
}

// An individual request to create a User.
type CreateUsersRequest_Value struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the User.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The type of the User.
	//
	// If not set, the default USER_TYPE_STANDARD is used.
	Type UserType `protobuf:"varint,2,opt,name=type,proto3,enum=buf.registry.owner.v1.UserType" json:"type,omitempty"`
	// The configurable description of the User.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// The configurable URL that represents the homepage for a User.
	Url string `protobuf:"bytes,4,opt,name=url,proto3" json:"url,omitempty"`
	// The verification status of the User.
	//
	// If not set, the User will default to VERIFICATION_STATUS_UNVERIFIED.
	VerificationStatus UserVerificationStatus `protobuf:"varint,5,opt,name=verification_status,json=verificationStatus,proto3,enum=buf.registry.owner.v1.UserVerificationStatus" json:"verification_status,omitempty"`
}

func (x *CreateUsersRequest_Value) Reset() {
	*x = CreateUsersRequest_Value{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_owner_v1_user_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateUsersRequest_Value) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateUsersRequest_Value) ProtoMessage() {}

func (x *CreateUsersRequest_Value) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_owner_v1_user_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateUsersRequest_Value.ProtoReflect.Descriptor instead.
func (*CreateUsersRequest_Value) Descriptor() ([]byte, []int) {
	return file_buf_registry_owner_v1_user_service_proto_rawDescGZIP(), []int{4, 0}
}

func (x *CreateUsersRequest_Value) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CreateUsersRequest_Value) GetType() UserType {
	if x != nil {
		return x.Type
	}
	return UserType_USER_TYPE_UNSPECIFIED
}

func (x *CreateUsersRequest_Value) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *CreateUsersRequest_Value) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *CreateUsersRequest_Value) GetVerificationStatus() UserVerificationStatus {
	if x != nil {
		return x.VerificationStatus
	}
	return UserVerificationStatus_USER_VERIFICATION_STATUS_UNSPECIFIED
}

// An individual request to update a User.
type UpdateUsersRequest_Value struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The User to update.
	UserRef *UserRef `protobuf:"bytes,1,opt,name=user_ref,json=userRef,proto3" json:"user_ref,omitempty"`
	// The state of the User.
	State *UserState `protobuf:"varint,2,opt,name=state,proto3,enum=buf.registry.owner.v1.UserState,oneof" json:"state,omitempty"`
	// The configurable description of the User.
	Description *string `protobuf:"bytes,3,opt,name=description,proto3,oneof" json:"description,omitempty"`
	// The configurable URL that represents the homepage for a User.
	Url *string `protobuf:"bytes,4,opt,name=url,proto3,oneof" json:"url,omitempty"`
	// The verification status of the User.
	VerificationStatus *UserVerificationStatus `protobuf:"varint,5,opt,name=verification_status,json=verificationStatus,proto3,enum=buf.registry.owner.v1.UserVerificationStatus,oneof" json:"verification_status,omitempty"`
}

func (x *UpdateUsersRequest_Value) Reset() {
	*x = UpdateUsersRequest_Value{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_owner_v1_user_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateUsersRequest_Value) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateUsersRequest_Value) ProtoMessage() {}

func (x *UpdateUsersRequest_Value) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_owner_v1_user_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateUsersRequest_Value.ProtoReflect.Descriptor instead.
func (*UpdateUsersRequest_Value) Descriptor() ([]byte, []int) {
	return file_buf_registry_owner_v1_user_service_proto_rawDescGZIP(), []int{6, 0}
}

func (x *UpdateUsersRequest_Value) GetUserRef() *UserRef {
	if x != nil {
		return x.UserRef
	}
	return nil
}

func (x *UpdateUsersRequest_Value) GetState() UserState {
	if x != nil && x.State != nil {
		return *x.State
	}
	return UserState_USER_STATE_UNSPECIFIED
}

func (x *UpdateUsersRequest_Value) GetDescription() string {
	if x != nil && x.Description != nil {
		return *x.Description
	}
	return ""
}

func (x *UpdateUsersRequest_Value) GetUrl() string {
	if x != nil && x.Url != nil {
		return *x.Url
	}
	return ""
}

func (x *UpdateUsersRequest_Value) GetVerificationStatus() UserVerificationStatus {
	if x != nil && x.VerificationStatus != nil {
		return *x.VerificationStatus
	}
	return UserVerificationStatus_USER_VERIFICATION_STATUS_UNSPECIFIED
}

var File_buf_registry_owner_v1_user_service_proto protoreflect.FileDescriptor

var file_buf_registry_owner_v1_user_service_proto_rawDesc = []byte{
	0x0a, 0x28, 0x62, 0x75, 0x66, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x6f,
	0x77, 0x6e, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x15, 0x62, 0x75, 0x66, 0x2e,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x1a, 0x28, 0x62, 0x75, 0x66, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f,
	0x6f, 0x77, 0x6e, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x62, 0x75, 0x66,
	0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x2f,
	0x76, 0x31, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x62,
	0x75, 0x66, 0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2f, 0x76, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x5b, 0x0a, 0x0f, 0x47, 0x65,
	0x74, 0x55, 0x73, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a,
	0x09, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x66, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x1e, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x6f, 0x77, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x52, 0x65, 0x66,
	0x42, 0x0b, 0xba, 0x48, 0x08, 0x92, 0x01, 0x05, 0x08, 0x01, 0x10, 0xfa, 0x01, 0x52, 0x08, 0x75,
	0x73, 0x65, 0x72, 0x52, 0x65, 0x66, 0x73, 0x22, 0x4f, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x55, 0x73,
	0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3b, 0x0a, 0x05, 0x75,
	0x73, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x42, 0x08, 0xba, 0x48, 0x05, 0x92, 0x01, 0x02, 0x08,
	0x01, 0x52, 0x05, 0x75, 0x73, 0x65, 0x72, 0x73, 0x22, 0x84, 0x04, 0x0a, 0x10, 0x4c, 0x69, 0x73,
	0x74, 0x55, 0x73, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x25, 0x0a,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d,
	0x42, 0x08, 0xba, 0x48, 0x05, 0x2a, 0x03, 0x18, 0xfa, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x27, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x08, 0xba, 0x48, 0x05, 0x72, 0x03, 0x18,
	0x80, 0x20, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x53, 0x0a,
	0x11, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65,
	0x66, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x66,
	0x52, 0x10, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x66, 0x73, 0x12, 0x4d, 0x0a, 0x05, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x2d, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2e, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x55, 0x73,
	0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4f, 0x72, 0x64, 0x65, 0x72,
	0x42, 0x08, 0xba, 0x48, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x05, 0x6f, 0x72, 0x64, 0x65,
	0x72, 0x12, 0x50, 0x0a, 0x09, 0x68, 0x61, 0x73, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x05,
	0x20, 0x03, 0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2e, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x73, 0x65,
	0x72, 0x54, 0x79, 0x70, 0x65, 0x42, 0x12, 0xba, 0x48, 0x0f, 0x92, 0x01, 0x0c, 0x18, 0x01, 0x22,
	0x08, 0x82, 0x01, 0x05, 0x10, 0x01, 0x22, 0x01, 0x00, 0x52, 0x08, 0x68, 0x61, 0x73, 0x54, 0x79,
	0x70, 0x65, 0x73, 0x12, 0x53, 0x0a, 0x0a, 0x68, 0x61, 0x73, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x20, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x55, 0x73, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x12, 0xba, 0x48, 0x0f, 0x92, 0x01,
	0x0c, 0x18, 0x01, 0x22, 0x08, 0x82, 0x01, 0x05, 0x10, 0x01, 0x22, 0x01, 0x00, 0x52, 0x09, 0x68,
	0x61, 0x73, 0x53, 0x74, 0x61, 0x74, 0x65, 0x73, 0x22, 0x55, 0x0a, 0x05, 0x4f, 0x72, 0x64, 0x65,
	0x72, 0x12, 0x15, 0x0a, 0x11, 0x4f, 0x52, 0x44, 0x45, 0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1a, 0x0a, 0x16, 0x4f, 0x52, 0x44, 0x45,
	0x52, 0x5f, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x5f, 0x44, 0x45,
	0x53, 0x43, 0x10, 0x01, 0x12, 0x19, 0x0a, 0x15, 0x4f, 0x52, 0x44, 0x45, 0x52, 0x5f, 0x43, 0x52,
	0x45, 0x41, 0x54, 0x45, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x5f, 0x41, 0x53, 0x43, 0x10, 0x02, 0x22,
	0x78, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x55, 0x73, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x30, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x08, 0xba,
	0x48, 0x05, 0x72, 0x03, 0x18, 0x80, 0x20, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x31, 0x0a, 0x05, 0x75, 0x73, 0x65, 0x72, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x73,
	0x65, 0x72, 0x52, 0x05, 0x75, 0x73, 0x65, 0x72, 0x73, 0x22, 0xa8, 0x03, 0x0a, 0x12, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x54, 0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2f, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x6f, 0x77, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x55,
	0x73, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x42, 0x0b, 0xba, 0x48, 0x08, 0x92, 0x01, 0x05, 0x08, 0x01, 0x10, 0xfa, 0x01, 0x52, 0x06,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x1a, 0xbb, 0x02, 0x0a, 0x05, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x12, 0x3b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27,
	0xba, 0x48, 0x24, 0xc8, 0x01, 0x01, 0x72, 0x1f, 0x10, 0x02, 0x18, 0x20, 0x32, 0x19, 0x5e, 0x5b,
	0x61, 0x2d, 0x7a, 0x5d, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x2d, 0x5d, 0x2a, 0x5b, 0x61,
	0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x24, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3d, 0x0a,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6f, 0x77, 0x6e, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x42, 0x08, 0xba, 0x48,
	0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x2a, 0x0a, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x08, 0xba, 0x48, 0x05, 0x72, 0x03, 0x18, 0xde, 0x02, 0x52, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x20, 0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0e, 0xba, 0x48, 0x0b, 0xd8, 0x01, 0x01, 0x72, 0x06, 0x18,
	0xff, 0x01, 0x88, 0x01, 0x01, 0x52, 0x03, 0x75, 0x72, 0x6c, 0x12, 0x68, 0x0a, 0x13, 0x76, 0x65,
	0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x55, 0x73, 0x65, 0x72, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x08, 0xba, 0x48, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01,
	0x52, 0x12, 0x76, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x22, 0x52, 0x0a, 0x13, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x55, 0x73,
	0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3b, 0x0a, 0x05, 0x75,
	0x73, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x42, 0x08, 0xba, 0x48, 0x05, 0x92, 0x01, 0x02, 0x08,
	0x01, 0x52, 0x05, 0x75, 0x73, 0x65, 0x72, 0x73, 0x22, 0xca, 0x04, 0x0a, 0x12, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x54, 0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2f, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6f,
	0x77, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x55, 0x73,
	0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x42, 0x0b, 0xba, 0x48, 0x08, 0x92, 0x01, 0x05, 0x08, 0x01, 0x10, 0xfa, 0x01, 0x52, 0x06, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x73, 0x1a, 0xdd, 0x03, 0x0a, 0x05, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12,
	0x41, 0x0a, 0x08, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x66, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1e, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2e, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x52, 0x65,
	0x66, 0x42, 0x06, 0xba, 0x48, 0x03, 0xc8, 0x01, 0x01, 0x52, 0x07, 0x75, 0x73, 0x65, 0x72, 0x52,
	0x65, 0x66, 0x12, 0x48, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x20, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2e, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x42, 0x0b, 0xba, 0x48, 0x08, 0x82, 0x01, 0x05, 0x10, 0x01, 0x22, 0x01, 0x00,
	0x48, 0x00, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x88, 0x01, 0x01, 0x12, 0x2f, 0x0a, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x08, 0xba, 0x48, 0x05, 0x72, 0x03, 0x18, 0xde, 0x02, 0x48, 0x01, 0x52, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x6d, 0x0a,
	0x03, 0x75, 0x72, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x56, 0xba, 0x48, 0x53, 0xba,
	0x01, 0x4b, 0x0a, 0x0a, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x75, 0x72, 0x69, 0x1a, 0x3d,
	0x74, 0x68, 0x69, 0x73, 0x20, 0x3d, 0x3d, 0x20, 0x27, 0x27, 0x20, 0x7c, 0x7c, 0x20, 0x74, 0x68,
	0x69, 0x73, 0x2e, 0x69, 0x73, 0x55, 0x72, 0x69, 0x28, 0x29, 0x20, 0x3f, 0x20, 0x27, 0x27, 0x20,
	0x3a, 0x20, 0x27, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65,
	0x20, 0x61, 0x20, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x20, 0x55, 0x52, 0x49, 0x27, 0x72, 0x03, 0x18,
	0xff, 0x01, 0x48, 0x02, 0x52, 0x03, 0x75, 0x72, 0x6c, 0x88, 0x01, 0x01, 0x12, 0x6d, 0x0a, 0x13,
	0x76, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x08, 0xba, 0x48, 0x05, 0x82, 0x01, 0x02,
	0x10, 0x01, 0x48, 0x03, 0x52, 0x12, 0x76, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x88, 0x01, 0x01, 0x42, 0x08, 0x0a, 0x06, 0x5f,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x06, 0x0a, 0x04, 0x5f, 0x75, 0x72, 0x6c, 0x42, 0x16, 0x0a,
	0x14, 0x5f, 0x76, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0x52, 0x0a, 0x13, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x55,
	0x73, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3b, 0x0a, 0x05,
	0x75, 0x73, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6f, 0x77, 0x6e, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x42, 0x08, 0xba, 0x48, 0x05, 0x92, 0x01, 0x02,
	0x08, 0x01, 0x52, 0x05, 0x75, 0x73, 0x65, 0x72, 0x73, 0x22, 0x5e, 0x0a, 0x12, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x48, 0x0a, 0x09, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x66, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x79, 0x2e, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x52,
	0x65, 0x66, 0x42, 0x0b, 0xba, 0x48, 0x08, 0x92, 0x01, 0x05, 0x08, 0x01, 0x10, 0xfa, 0x01, 0x52,
	0x08, 0x75, 0x73, 0x65, 0x72, 0x52, 0x65, 0x66, 0x73, 0x22, 0x15, 0x0a, 0x13, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x32, 0x95, 0x04, 0x0a, 0x0b, 0x55, 0x73, 0x65, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x12, 0x60, 0x0a, 0x08, 0x47, 0x65, 0x74, 0x55, 0x73, 0x65, 0x72, 0x73, 0x12, 0x26, 0x2e, 0x62,
	0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6f, 0x77, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x55, 0x73, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2e, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74,
	0x55, 0x73, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90,
	0x02, 0x01, 0x12, 0x63, 0x0a, 0x09, 0x4c, 0x69, 0x73, 0x74, 0x55, 0x73, 0x65, 0x72, 0x73, 0x12,
	0x27, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6f,
	0x77, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x55, 0x73, 0x65, 0x72,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x55, 0x73, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x12, 0x69, 0x0a, 0x0b, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x55, 0x73, 0x65, 0x72, 0x73, 0x12, 0x29, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x2a, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2e, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x55, 0x73, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90,
	0x02, 0x02, 0x12, 0x69, 0x0a, 0x0b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72,
	0x73, 0x12, 0x29, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2e, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x55, 0x73, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x62,
	0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6f, 0x77, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x02, 0x12, 0x69, 0x0a,
	0x0b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x73, 0x12, 0x29, 0x2e, 0x62,
	0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6f, 0x77, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x02, 0x42, 0x55, 0x5a, 0x53, 0x62, 0x75, 0x66, 0x2e,
	0x62, 0x75, 0x69, 0x6c, 0x64, 0x2f, 0x67, 0x65, 0x6e, 0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x75, 0x66,
	0x62, 0x75, 0x69, 0x6c, 0x64, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x62, 0x75, 0x66, 0x66, 0x65, 0x72, 0x73, 0x2f, 0x67,
	0x6f, 0x2f, 0x62, 0x75, 0x66, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x6f,
	0x77, 0x6e, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x3b, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x76, 0x31, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_buf_registry_owner_v1_user_service_proto_rawDescOnce sync.Once
	file_buf_registry_owner_v1_user_service_proto_rawDescData = file_buf_registry_owner_v1_user_service_proto_rawDesc
)

func file_buf_registry_owner_v1_user_service_proto_rawDescGZIP() []byte {
	file_buf_registry_owner_v1_user_service_proto_rawDescOnce.Do(func() {
		file_buf_registry_owner_v1_user_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_buf_registry_owner_v1_user_service_proto_rawDescData)
	})
	return file_buf_registry_owner_v1_user_service_proto_rawDescData
}

var file_buf_registry_owner_v1_user_service_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_buf_registry_owner_v1_user_service_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_buf_registry_owner_v1_user_service_proto_goTypes = []any{
	(ListUsersRequest_Order)(0),      // 0: buf.registry.owner.v1.ListUsersRequest.Order
	(*GetUsersRequest)(nil),          // 1: buf.registry.owner.v1.GetUsersRequest
	(*GetUsersResponse)(nil),         // 2: buf.registry.owner.v1.GetUsersResponse
	(*ListUsersRequest)(nil),         // 3: buf.registry.owner.v1.ListUsersRequest
	(*ListUsersResponse)(nil),        // 4: buf.registry.owner.v1.ListUsersResponse
	(*CreateUsersRequest)(nil),       // 5: buf.registry.owner.v1.CreateUsersRequest
	(*CreateUsersResponse)(nil),      // 6: buf.registry.owner.v1.CreateUsersResponse
	(*UpdateUsersRequest)(nil),       // 7: buf.registry.owner.v1.UpdateUsersRequest
	(*UpdateUsersResponse)(nil),      // 8: buf.registry.owner.v1.UpdateUsersResponse
	(*DeleteUsersRequest)(nil),       // 9: buf.registry.owner.v1.DeleteUsersRequest
	(*DeleteUsersResponse)(nil),      // 10: buf.registry.owner.v1.DeleteUsersResponse
	(*CreateUsersRequest_Value)(nil), // 11: buf.registry.owner.v1.CreateUsersRequest.Value
	(*UpdateUsersRequest_Value)(nil), // 12: buf.registry.owner.v1.UpdateUsersRequest.Value
	(*UserRef)(nil),                  // 13: buf.registry.owner.v1.UserRef
	(*User)(nil),                     // 14: buf.registry.owner.v1.User
	(*OrganizationRef)(nil),          // 15: buf.registry.owner.v1.OrganizationRef
	(UserType)(0),                    // 16: buf.registry.owner.v1.UserType
	(UserState)(0),                   // 17: buf.registry.owner.v1.UserState
	(UserVerificationStatus)(0),      // 18: buf.registry.owner.v1.UserVerificationStatus
}
var file_buf_registry_owner_v1_user_service_proto_depIdxs = []int32{
	13, // 0: buf.registry.owner.v1.GetUsersRequest.user_refs:type_name -> buf.registry.owner.v1.UserRef
	14, // 1: buf.registry.owner.v1.GetUsersResponse.users:type_name -> buf.registry.owner.v1.User
	15, // 2: buf.registry.owner.v1.ListUsersRequest.organization_refs:type_name -> buf.registry.owner.v1.OrganizationRef
	0,  // 3: buf.registry.owner.v1.ListUsersRequest.order:type_name -> buf.registry.owner.v1.ListUsersRequest.Order
	16, // 4: buf.registry.owner.v1.ListUsersRequest.has_types:type_name -> buf.registry.owner.v1.UserType
	17, // 5: buf.registry.owner.v1.ListUsersRequest.has_states:type_name -> buf.registry.owner.v1.UserState
	14, // 6: buf.registry.owner.v1.ListUsersResponse.users:type_name -> buf.registry.owner.v1.User
	11, // 7: buf.registry.owner.v1.CreateUsersRequest.values:type_name -> buf.registry.owner.v1.CreateUsersRequest.Value
	14, // 8: buf.registry.owner.v1.CreateUsersResponse.users:type_name -> buf.registry.owner.v1.User
	12, // 9: buf.registry.owner.v1.UpdateUsersRequest.values:type_name -> buf.registry.owner.v1.UpdateUsersRequest.Value
	14, // 10: buf.registry.owner.v1.UpdateUsersResponse.users:type_name -> buf.registry.owner.v1.User
	13, // 11: buf.registry.owner.v1.DeleteUsersRequest.user_refs:type_name -> buf.registry.owner.v1.UserRef
	16, // 12: buf.registry.owner.v1.CreateUsersRequest.Value.type:type_name -> buf.registry.owner.v1.UserType
	18, // 13: buf.registry.owner.v1.CreateUsersRequest.Value.verification_status:type_name -> buf.registry.owner.v1.UserVerificationStatus
	13, // 14: buf.registry.owner.v1.UpdateUsersRequest.Value.user_ref:type_name -> buf.registry.owner.v1.UserRef
	17, // 15: buf.registry.owner.v1.UpdateUsersRequest.Value.state:type_name -> buf.registry.owner.v1.UserState
	18, // 16: buf.registry.owner.v1.UpdateUsersRequest.Value.verification_status:type_name -> buf.registry.owner.v1.UserVerificationStatus
	1,  // 17: buf.registry.owner.v1.UserService.GetUsers:input_type -> buf.registry.owner.v1.GetUsersRequest
	3,  // 18: buf.registry.owner.v1.UserService.ListUsers:input_type -> buf.registry.owner.v1.ListUsersRequest
	5,  // 19: buf.registry.owner.v1.UserService.CreateUsers:input_type -> buf.registry.owner.v1.CreateUsersRequest
	7,  // 20: buf.registry.owner.v1.UserService.UpdateUsers:input_type -> buf.registry.owner.v1.UpdateUsersRequest
	9,  // 21: buf.registry.owner.v1.UserService.DeleteUsers:input_type -> buf.registry.owner.v1.DeleteUsersRequest
	2,  // 22: buf.registry.owner.v1.UserService.GetUsers:output_type -> buf.registry.owner.v1.GetUsersResponse
	4,  // 23: buf.registry.owner.v1.UserService.ListUsers:output_type -> buf.registry.owner.v1.ListUsersResponse
	6,  // 24: buf.registry.owner.v1.UserService.CreateUsers:output_type -> buf.registry.owner.v1.CreateUsersResponse
	8,  // 25: buf.registry.owner.v1.UserService.UpdateUsers:output_type -> buf.registry.owner.v1.UpdateUsersResponse
	10, // 26: buf.registry.owner.v1.UserService.DeleteUsers:output_type -> buf.registry.owner.v1.DeleteUsersResponse
	22, // [22:27] is the sub-list for method output_type
	17, // [17:22] is the sub-list for method input_type
	17, // [17:17] is the sub-list for extension type_name
	17, // [17:17] is the sub-list for extension extendee
	0,  // [0:17] is the sub-list for field type_name
}

func init() { file_buf_registry_owner_v1_user_service_proto_init() }
func file_buf_registry_owner_v1_user_service_proto_init() {
	if File_buf_registry_owner_v1_user_service_proto != nil {
		return
	}
	file_buf_registry_owner_v1_organization_proto_init()
	file_buf_registry_owner_v1_user_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_buf_registry_owner_v1_user_service_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*GetUsersRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_owner_v1_user_service_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*GetUsersResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_owner_v1_user_service_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*ListUsersRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_owner_v1_user_service_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*ListUsersResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_owner_v1_user_service_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*CreateUsersRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_owner_v1_user_service_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*CreateUsersResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_owner_v1_user_service_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*UpdateUsersRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_owner_v1_user_service_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*UpdateUsersResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_owner_v1_user_service_proto_msgTypes[8].Exporter = func(v any, i int) any {
			switch v := v.(*DeleteUsersRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_owner_v1_user_service_proto_msgTypes[9].Exporter = func(v any, i int) any {
			switch v := v.(*DeleteUsersResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_owner_v1_user_service_proto_msgTypes[10].Exporter = func(v any, i int) any {
			switch v := v.(*CreateUsersRequest_Value); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_owner_v1_user_service_proto_msgTypes[11].Exporter = func(v any, i int) any {
			switch v := v.(*UpdateUsersRequest_Value); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_buf_registry_owner_v1_user_service_proto_msgTypes[11].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_buf_registry_owner_v1_user_service_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_buf_registry_owner_v1_user_service_proto_goTypes,
		DependencyIndexes: file_buf_registry_owner_v1_user_service_proto_depIdxs,
		EnumInfos:         file_buf_registry_owner_v1_user_service_proto_enumTypes,
		MessageInfos:      file_buf_registry_owner_v1_user_service_proto_msgTypes,
	}.Build()
	File_buf_registry_owner_v1_user_service_proto = out.File
	file_buf_registry_owner_v1_user_service_proto_rawDesc = nil
	file_buf_registry_owner_v1_user_service_proto_goTypes = nil
	file_buf_registry_owner_v1_user_service_proto_depIdxs = nil
}
