#!/bin/sh

set -e
set -u
cd "$(dirname "$0")"

export RQ="$(pwd)/../build/rq"

if [ ! -x "$RQ" ] ; then
	printf '"%s" is not an executable binary, did you forget to run make?\n' 1>&2
	exit 1
fi

TEMP="$(mktemp -d)"
finish() {
	rm -rf "$TEMP"
}
trap finish EXIT

if [ ! -d "$TEMP" ] ; then
	echo "something went wrong -- temp folder missing" 1>&2
	exit 1
fi

echo 'running rq smoke test suite... '

st="$(date +%s)"
startcwd="$(pwd)"
errcount=0
n=0
for caseentry in ./*/test.sh ; do
	cd "$startcwd"
	case="$(basename $(dirname "$caseentry"))"
	printf '%s... ' "$case"
	# If a CLI arg is provided, only run tests that match it as a regex.
	if [ $# -gt 0 ] ; then
		if ! echo "$case" | grep -q "$1" ; then
			echo "SKIP"
			continue
		fi
	fi
	cd "$case"
	export CASETEMP="$TEMP/$case"
	mkdir -p "$CASETEMP"
	set +e
	sh ./test.sh > "$TEMP/$case.out" 2> "$TEMP/$case.err" < /dev/null
	err=$?
	set -e

	if [ "$err" -ne 0 ] ; then
		printf 'FAIL (exit code %d)\n' "$err"
		echo "--------- standard out"
		cat "$TEMP/$case.out"
		echo "--------- standard error"
		cat "$TEMP/$case.err"
		errcount=$(expr $errcount + 1)
	else
		echo "PASS"
	fi

	n=$(expr $n + 1)

done
et="$(date +%s)"

printf 'smoke test suite finished %d tests in %ds with %d errors\n' "$n" "$(expr $et - $st)" "$errcount"

exit $errcount
