package billing

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AcceptanceMode enumerates the values for acceptance mode.
type AcceptanceMode string

const (
	// ClickToAccept ...
	ClickToAccept AcceptanceMode = "ClickToAccept"
	// ESignEmbedded ...
	ESignEmbedded AcceptanceMode = "ESignEmbedded"
	// ESignOffline ...
	ESignOffline AcceptanceMode = "ESignOffline"
)

// PossibleAcceptanceModeValues returns an array of possible values for the AcceptanceMode const type.
func PossibleAcceptanceModeValues() []AcceptanceMode {
	return []AcceptanceMode{ClickToAccept, ESignEmbedded, ESignOffline}
}

// AccountStatus enumerates the values for account status.
type AccountStatus string

const (
	// Active ...
	Active AccountStatus = "Active"
	// Deleted ...
	Deleted AccountStatus = "Deleted"
	// Disabled ...
	Disabled AccountStatus = "Disabled"
	// Expired ...
	Expired AccountStatus = "Expired"
	// Extended ...
	Extended AccountStatus = "Extended"
	// Terminated ...
	Terminated AccountStatus = "Terminated"
	// Transferred ...
	Transferred AccountStatus = "Transferred"
)

// PossibleAccountStatusValues returns an array of possible values for the AccountStatus const type.
func PossibleAccountStatusValues() []AccountStatus {
	return []AccountStatus{Active, Deleted, Disabled, Expired, Extended, Terminated, Transferred}
}

// AccountType enumerates the values for account type.
type AccountType string

const (
	// Enterprise ...
	Enterprise AccountType = "Enterprise"
	// Individual ...
	Individual AccountType = "Individual"
	// Partner ...
	Partner AccountType = "Partner"
)

// PossibleAccountTypeValues returns an array of possible values for the AccountType const type.
func PossibleAccountTypeValues() []AccountType {
	return []AccountType{Enterprise, Individual, Partner}
}

// AddressValidationStatus enumerates the values for address validation status.
type AddressValidationStatus string

const (
	// Invalid ...
	Invalid AddressValidationStatus = "Invalid"
	// Valid ...
	Valid AddressValidationStatus = "Valid"
)

// PossibleAddressValidationStatusValues returns an array of possible values for the AddressValidationStatus const type.
func PossibleAddressValidationStatusValues() []AddressValidationStatus {
	return []AddressValidationStatus{Invalid, Valid}
}

// AgreementType enumerates the values for agreement type.
type AgreementType string

const (
	// EnterpriseAgreement ...
	EnterpriseAgreement AgreementType = "EnterpriseAgreement"
	// MicrosoftCustomerAgreement ...
	MicrosoftCustomerAgreement AgreementType = "MicrosoftCustomerAgreement"
	// MicrosoftOnlineServicesProgram ...
	MicrosoftOnlineServicesProgram AgreementType = "MicrosoftOnlineServicesProgram"
	// MicrosoftPartnerAgreement ...
	MicrosoftPartnerAgreement AgreementType = "MicrosoftPartnerAgreement"
)

// PossibleAgreementTypeValues returns an array of possible values for the AgreementType const type.
func PossibleAgreementTypeValues() []AgreementType {
	return []AgreementType{EnterpriseAgreement, MicrosoftCustomerAgreement, MicrosoftOnlineServicesProgram, MicrosoftPartnerAgreement}
}

// AutoRenew enumerates the values for auto renew.
type AutoRenew string

const (
	// Off ...
	Off AutoRenew = "Off"
	// On ...
	On AutoRenew = "On"
)

// PossibleAutoRenewValues returns an array of possible values for the AutoRenew const type.
func PossibleAutoRenewValues() []AutoRenew {
	return []AutoRenew{Off, On}
}

// Category enumerates the values for category.
type Category string

const (
	// CategoryAffiliatePurchaseTerms ...
	CategoryAffiliatePurchaseTerms Category = "AffiliatePurchaseTerms"
	// CategoryMicrosoftCustomerAgreement ...
	CategoryMicrosoftCustomerAgreement Category = "MicrosoftCustomerAgreement"
	// CategoryOther ...
	CategoryOther Category = "Other"
)

// PossibleCategoryValues returns an array of possible values for the Category const type.
func PossibleCategoryValues() []Category {
	return []Category{CategoryAffiliatePurchaseTerms, CategoryMicrosoftCustomerAgreement, CategoryOther}
}

// DocumentSource enumerates the values for document source.
type DocumentSource string

const (
	// DRS ...
	DRS DocumentSource = "DRS"
	// ENF ...
	ENF DocumentSource = "ENF"
)

// PossibleDocumentSourceValues returns an array of possible values for the DocumentSource const type.
func PossibleDocumentSourceValues() []DocumentSource {
	return []DocumentSource{DRS, ENF}
}

// DocumentType enumerates the values for document type.
type DocumentType string

const (
	// DocumentTypeCreditNote ...
	DocumentTypeCreditNote DocumentType = "CreditNote"
	// DocumentTypeInvoice ...
	DocumentTypeInvoice DocumentType = "Invoice"
	// DocumentTypeTaxReceipt ...
	DocumentTypeTaxReceipt DocumentType = "TaxReceipt"
	// DocumentTypeVoidNote ...
	DocumentTypeVoidNote DocumentType = "VoidNote"
)

// PossibleDocumentTypeValues returns an array of possible values for the DocumentType const type.
func PossibleDocumentTypeValues() []DocumentType {
	return []DocumentType{DocumentTypeCreditNote, DocumentTypeInvoice, DocumentTypeTaxReceipt, DocumentTypeVoidNote}
}

// Frequency enumerates the values for frequency.
type Frequency string

const (
	// Monthly ...
	Monthly Frequency = "Monthly"
	// OneTime ...
	OneTime Frequency = "OneTime"
	// UsageBased ...
	UsageBased Frequency = "UsageBased"
)

// PossibleFrequencyValues returns an array of possible values for the Frequency const type.
func PossibleFrequencyValues() []Frequency {
	return []Frequency{Monthly, OneTime, UsageBased}
}

// InvoiceDocumentType enumerates the values for invoice document type.
type InvoiceDocumentType string

const (
	// InvoiceDocumentTypeCreditNote ...
	InvoiceDocumentTypeCreditNote InvoiceDocumentType = "CreditNote"
	// InvoiceDocumentTypeInvoice ...
	InvoiceDocumentTypeInvoice InvoiceDocumentType = "Invoice"
)

// PossibleInvoiceDocumentTypeValues returns an array of possible values for the InvoiceDocumentType const type.
func PossibleInvoiceDocumentTypeValues() []InvoiceDocumentType {
	return []InvoiceDocumentType{InvoiceDocumentTypeCreditNote, InvoiceDocumentTypeInvoice}
}

// InvoiceSectionState enumerates the values for invoice section state.
type InvoiceSectionState string

const (
	// InvoiceSectionStateActive ...
	InvoiceSectionStateActive InvoiceSectionState = "Active"
	// InvoiceSectionStateRestricted ...
	InvoiceSectionStateRestricted InvoiceSectionState = "Restricted"
)

// PossibleInvoiceSectionStateValues returns an array of possible values for the InvoiceSectionState const type.
func PossibleInvoiceSectionStateValues() []InvoiceSectionState {
	return []InvoiceSectionState{InvoiceSectionStateActive, InvoiceSectionStateRestricted}
}

// InvoiceStatus enumerates the values for invoice status.
type InvoiceStatus string

const (
	// Due ...
	Due InvoiceStatus = "Due"
	// OverDue ...
	OverDue InvoiceStatus = "OverDue"
	// Paid ...
	Paid InvoiceStatus = "Paid"
	// Void ...
	Void InvoiceStatus = "Void"
)

// PossibleInvoiceStatusValues returns an array of possible values for the InvoiceStatus const type.
func PossibleInvoiceStatusValues() []InvoiceStatus {
	return []InvoiceStatus{Due, OverDue, Paid, Void}
}

// InvoiceType enumerates the values for invoice type.
type InvoiceType string

const (
	// AzureMarketplace ...
	AzureMarketplace InvoiceType = "AzureMarketplace"
	// AzureService ...
	AzureService InvoiceType = "AzureService"
	// AzureSupport ...
	AzureSupport InvoiceType = "AzureSupport"
)

// PossibleInvoiceTypeValues returns an array of possible values for the InvoiceType const type.
func PossibleInvoiceTypeValues() []InvoiceType {
	return []InvoiceType{AzureMarketplace, AzureService, AzureSupport}
}

// MarketplacePurchasesPolicy enumerates the values for marketplace purchases policy.
type MarketplacePurchasesPolicy string

const (
	// AllAllowed ...
	AllAllowed MarketplacePurchasesPolicy = "AllAllowed"
	// NotAllowed ...
	NotAllowed MarketplacePurchasesPolicy = "NotAllowed"
	// OnlyFreeAllowed ...
	OnlyFreeAllowed MarketplacePurchasesPolicy = "OnlyFreeAllowed"
)

// PossibleMarketplacePurchasesPolicyValues returns an array of possible values for the MarketplacePurchasesPolicy const type.
func PossibleMarketplacePurchasesPolicyValues() []MarketplacePurchasesPolicy {
	return []MarketplacePurchasesPolicy{AllAllowed, NotAllowed, OnlyFreeAllowed}
}

// PaymentMethodFamily enumerates the values for payment method family.
type PaymentMethodFamily string

const (
	// CheckWire ...
	CheckWire PaymentMethodFamily = "CheckWire"
	// CreditCard ...
	CreditCard PaymentMethodFamily = "CreditCard"
	// Credits ...
	Credits PaymentMethodFamily = "Credits"
	// None ...
	None PaymentMethodFamily = "None"
)

// PossiblePaymentMethodFamilyValues returns an array of possible values for the PaymentMethodFamily const type.
func PossiblePaymentMethodFamilyValues() []PaymentMethodFamily {
	return []PaymentMethodFamily{CheckWire, CreditCard, Credits, None}
}

// ProductStatusType enumerates the values for product status type.
type ProductStatusType string

const (
	// ProductStatusTypeActive ...
	ProductStatusTypeActive ProductStatusType = "Active"
	// ProductStatusTypeAutoRenew ...
	ProductStatusTypeAutoRenew ProductStatusType = "AutoRenew"
	// ProductStatusTypeCancelled ...
	ProductStatusTypeCancelled ProductStatusType = "Cancelled"
	// ProductStatusTypeDisabled ...
	ProductStatusTypeDisabled ProductStatusType = "Disabled"
	// ProductStatusTypeExpired ...
	ProductStatusTypeExpired ProductStatusType = "Expired"
	// ProductStatusTypeExpiring ...
	ProductStatusTypeExpiring ProductStatusType = "Expiring"
	// ProductStatusTypeInactive ...
	ProductStatusTypeInactive ProductStatusType = "Inactive"
	// ProductStatusTypePastDue ...
	ProductStatusTypePastDue ProductStatusType = "PastDue"
)

// PossibleProductStatusTypeValues returns an array of possible values for the ProductStatusType const type.
func PossibleProductStatusTypeValues() []ProductStatusType {
	return []ProductStatusType{ProductStatusTypeActive, ProductStatusTypeAutoRenew, ProductStatusTypeCancelled, ProductStatusTypeDisabled, ProductStatusTypeExpired, ProductStatusTypeExpiring, ProductStatusTypeInactive, ProductStatusTypePastDue}
}

// ProductTransferValidationErrorCode enumerates the values for product transfer validation error code.
type ProductTransferValidationErrorCode string

const (
	// CrossBillingAccountNotAllowed ...
	CrossBillingAccountNotAllowed ProductTransferValidationErrorCode = "CrossBillingAccountNotAllowed"
	// DestinationBillingProfilePastDue ...
	DestinationBillingProfilePastDue ProductTransferValidationErrorCode = "DestinationBillingProfilePastDue"
	// InsufficientPermissionOnDestination ...
	InsufficientPermissionOnDestination ProductTransferValidationErrorCode = "InsufficientPermissionOnDestination"
	// InsufficientPermissionOnSource ...
	InsufficientPermissionOnSource ProductTransferValidationErrorCode = "InsufficientPermissionOnSource"
	// InvalidSource ...
	InvalidSource ProductTransferValidationErrorCode = "InvalidSource"
	// NotAvailableForDestinationMarket ...
	NotAvailableForDestinationMarket ProductTransferValidationErrorCode = "NotAvailableForDestinationMarket"
	// OneTimePurchaseProductTransferNotAllowed ...
	OneTimePurchaseProductTransferNotAllowed ProductTransferValidationErrorCode = "OneTimePurchaseProductTransferNotAllowed"
	// ProductNotActive ...
	ProductNotActive ProductTransferValidationErrorCode = "ProductNotActive"
	// ProductTypeNotSupported ...
	ProductTypeNotSupported ProductTransferValidationErrorCode = "ProductTypeNotSupported"
)

// PossibleProductTransferValidationErrorCodeValues returns an array of possible values for the ProductTransferValidationErrorCode const type.
func PossibleProductTransferValidationErrorCodeValues() []ProductTransferValidationErrorCode {
	return []ProductTransferValidationErrorCode{CrossBillingAccountNotAllowed, DestinationBillingProfilePastDue, InsufficientPermissionOnDestination, InsufficientPermissionOnSource, InvalidSource, NotAvailableForDestinationMarket, OneTimePurchaseProductTransferNotAllowed, ProductNotActive, ProductTypeNotSupported}
}

// ProfileSpendingLimit enumerates the values for profile spending limit.
type ProfileSpendingLimit string

const (
	// ProfileSpendingLimitOff ...
	ProfileSpendingLimitOff ProfileSpendingLimit = "Off"
	// ProfileSpendingLimitOn ...
	ProfileSpendingLimitOn ProfileSpendingLimit = "On"
)

// PossibleProfileSpendingLimitValues returns an array of possible values for the ProfileSpendingLimit const type.
func PossibleProfileSpendingLimitValues() []ProfileSpendingLimit {
	return []ProfileSpendingLimit{ProfileSpendingLimitOff, ProfileSpendingLimitOn}
}

// ProfileStatus enumerates the values for profile status.
type ProfileStatus string

const (
	// ProfileStatusActive ...
	ProfileStatusActive ProfileStatus = "Active"
	// ProfileStatusDisabled ...
	ProfileStatusDisabled ProfileStatus = "Disabled"
	// ProfileStatusWarned ...
	ProfileStatusWarned ProfileStatus = "Warned"
)

// PossibleProfileStatusValues returns an array of possible values for the ProfileStatus const type.
func PossibleProfileStatusValues() []ProfileStatus {
	return []ProfileStatus{ProfileStatusActive, ProfileStatusDisabled, ProfileStatusWarned}
}

// ProfileStatusReasonCode enumerates the values for profile status reason code.
type ProfileStatusReasonCode string

const (
	// PastDue ...
	PastDue ProfileStatusReasonCode = "PastDue"
	// SpendingLimitExpired ...
	SpendingLimitExpired ProfileStatusReasonCode = "SpendingLimitExpired"
	// SpendingLimitReached ...
	SpendingLimitReached ProfileStatusReasonCode = "SpendingLimitReached"
)

// PossibleProfileStatusReasonCodeValues returns an array of possible values for the ProfileStatusReasonCode const type.
func PossibleProfileStatusReasonCodeValues() []ProfileStatusReasonCode {
	return []ProfileStatusReasonCode{PastDue, SpendingLimitExpired, SpendingLimitReached}
}

// RelationshipType enumerates the values for relationship type.
type RelationshipType string

const (
	// CSPPartner ...
	CSPPartner RelationshipType = "CSPPartner"
	// Direct ...
	Direct RelationshipType = "Direct"
	// IndirectCustomer ...
	IndirectCustomer RelationshipType = "IndirectCustomer"
	// IndirectPartner ...
	IndirectPartner RelationshipType = "IndirectPartner"
)

// PossibleRelationshipTypeValues returns an array of possible values for the RelationshipType const type.
func PossibleRelationshipTypeValues() []RelationshipType {
	return []RelationshipType{CSPPartner, Direct, IndirectCustomer, IndirectPartner}
}

// ReservationPurchasesPolicy enumerates the values for reservation purchases policy.
type ReservationPurchasesPolicy string

const (
	// ReservationPurchasesPolicyAllowed ...
	ReservationPurchasesPolicyAllowed ReservationPurchasesPolicy = "Allowed"
	// ReservationPurchasesPolicyNotAllowed ...
	ReservationPurchasesPolicyNotAllowed ReservationPurchasesPolicy = "NotAllowed"
)

// PossibleReservationPurchasesPolicyValues returns an array of possible values for the ReservationPurchasesPolicy const type.
func PossibleReservationPurchasesPolicyValues() []ReservationPurchasesPolicy {
	return []ReservationPurchasesPolicy{ReservationPurchasesPolicyAllowed, ReservationPurchasesPolicyNotAllowed}
}

// ReservationType enumerates the values for reservation type.
type ReservationType string

const (
	// Purchase ...
	Purchase ReservationType = "Purchase"
	// UsageCharge ...
	UsageCharge ReservationType = "Usage Charge"
)

// PossibleReservationTypeValues returns an array of possible values for the ReservationType const type.
func PossibleReservationTypeValues() []ReservationType {
	return []ReservationType{Purchase, UsageCharge}
}

// SpendingLimit enumerates the values for spending limit.
type SpendingLimit string

const (
	// SpendingLimitOff ...
	SpendingLimitOff SpendingLimit = "Off"
	// SpendingLimitOn ...
	SpendingLimitOn SpendingLimit = "On"
)

// PossibleSpendingLimitValues returns an array of possible values for the SpendingLimit const type.
func PossibleSpendingLimitValues() []SpendingLimit {
	return []SpendingLimit{SpendingLimitOff, SpendingLimitOn}
}

// SpendingLimitForBillingProfile enumerates the values for spending limit for billing profile.
type SpendingLimitForBillingProfile string

const (
	// SpendingLimitForBillingProfileOff ...
	SpendingLimitForBillingProfileOff SpendingLimitForBillingProfile = "Off"
	// SpendingLimitForBillingProfileOn ...
	SpendingLimitForBillingProfileOn SpendingLimitForBillingProfile = "On"
)

// PossibleSpendingLimitForBillingProfileValues returns an array of possible values for the SpendingLimitForBillingProfile const type.
func PossibleSpendingLimitForBillingProfileValues() []SpendingLimitForBillingProfile {
	return []SpendingLimitForBillingProfile{SpendingLimitForBillingProfileOff, SpendingLimitForBillingProfileOn}
}

// StatusReasonCode enumerates the values for status reason code.
type StatusReasonCode string

const (
	// StatusReasonCodePastDue ...
	StatusReasonCodePastDue StatusReasonCode = "PastDue"
	// StatusReasonCodeSpendingLimitExpired ...
	StatusReasonCodeSpendingLimitExpired StatusReasonCode = "SpendingLimitExpired"
	// StatusReasonCodeSpendingLimitReached ...
	StatusReasonCodeSpendingLimitReached StatusReasonCode = "SpendingLimitReached"
)

// PossibleStatusReasonCodeValues returns an array of possible values for the StatusReasonCode const type.
func PossibleStatusReasonCodeValues() []StatusReasonCode {
	return []StatusReasonCode{StatusReasonCodePastDue, StatusReasonCodeSpendingLimitExpired, StatusReasonCodeSpendingLimitReached}
}

// StatusReasonCodeForBillingProfile enumerates the values for status reason code for billing profile.
type StatusReasonCodeForBillingProfile string

const (
	// StatusReasonCodeForBillingProfilePastDue ...
	StatusReasonCodeForBillingProfilePastDue StatusReasonCodeForBillingProfile = "PastDue"
	// StatusReasonCodeForBillingProfileSpendingLimitExpired ...
	StatusReasonCodeForBillingProfileSpendingLimitExpired StatusReasonCodeForBillingProfile = "SpendingLimitExpired"
	// StatusReasonCodeForBillingProfileSpendingLimitReached ...
	StatusReasonCodeForBillingProfileSpendingLimitReached StatusReasonCodeForBillingProfile = "SpendingLimitReached"
)

// PossibleStatusReasonCodeForBillingProfileValues returns an array of possible values for the StatusReasonCodeForBillingProfile const type.
func PossibleStatusReasonCodeForBillingProfileValues() []StatusReasonCodeForBillingProfile {
	return []StatusReasonCodeForBillingProfile{StatusReasonCodeForBillingProfilePastDue, StatusReasonCodeForBillingProfileSpendingLimitExpired, StatusReasonCodeForBillingProfileSpendingLimitReached}
}

// SubscriptionStatusType enumerates the values for subscription status type.
type SubscriptionStatusType string

const (
	// SubscriptionStatusTypeAbandoned ...
	SubscriptionStatusTypeAbandoned SubscriptionStatusType = "Abandoned"
	// SubscriptionStatusTypeActive ...
	SubscriptionStatusTypeActive SubscriptionStatusType = "Active"
	// SubscriptionStatusTypeDeleted ...
	SubscriptionStatusTypeDeleted SubscriptionStatusType = "Deleted"
	// SubscriptionStatusTypeInactive ...
	SubscriptionStatusTypeInactive SubscriptionStatusType = "Inactive"
	// SubscriptionStatusTypeWarning ...
	SubscriptionStatusTypeWarning SubscriptionStatusType = "Warning"
)

// PossibleSubscriptionStatusTypeValues returns an array of possible values for the SubscriptionStatusType const type.
func PossibleSubscriptionStatusTypeValues() []SubscriptionStatusType {
	return []SubscriptionStatusType{SubscriptionStatusTypeAbandoned, SubscriptionStatusTypeActive, SubscriptionStatusTypeDeleted, SubscriptionStatusTypeInactive, SubscriptionStatusTypeWarning}
}

// SubscriptionTransferValidationErrorCode enumerates the values for subscription transfer validation error
// code.
type SubscriptionTransferValidationErrorCode string

const (
	// SubscriptionTransferValidationErrorCodeCrossBillingAccountNotAllowed ...
	SubscriptionTransferValidationErrorCodeCrossBillingAccountNotAllowed SubscriptionTransferValidationErrorCode = "CrossBillingAccountNotAllowed"
	// SubscriptionTransferValidationErrorCodeDestinationBillingProfilePastDue ...
	SubscriptionTransferValidationErrorCodeDestinationBillingProfilePastDue SubscriptionTransferValidationErrorCode = "DestinationBillingProfilePastDue"
	// SubscriptionTransferValidationErrorCodeInsufficientPermissionOnDestination ...
	SubscriptionTransferValidationErrorCodeInsufficientPermissionOnDestination SubscriptionTransferValidationErrorCode = "InsufficientPermissionOnDestination"
	// SubscriptionTransferValidationErrorCodeInsufficientPermissionOnSource ...
	SubscriptionTransferValidationErrorCodeInsufficientPermissionOnSource SubscriptionTransferValidationErrorCode = "InsufficientPermissionOnSource"
	// SubscriptionTransferValidationErrorCodeInvalidSource ...
	SubscriptionTransferValidationErrorCodeInvalidSource SubscriptionTransferValidationErrorCode = "InvalidSource"
	// SubscriptionTransferValidationErrorCodeNotAvailableForDestinationMarket ...
	SubscriptionTransferValidationErrorCodeNotAvailableForDestinationMarket SubscriptionTransferValidationErrorCode = "NotAvailableForDestinationMarket"
	// SubscriptionTransferValidationErrorCodeSubscriptionNotActive ...
	SubscriptionTransferValidationErrorCodeSubscriptionNotActive SubscriptionTransferValidationErrorCode = "SubscriptionNotActive"
	// SubscriptionTransferValidationErrorCodeSubscriptionTypeNotSupported ...
	SubscriptionTransferValidationErrorCodeSubscriptionTypeNotSupported SubscriptionTransferValidationErrorCode = "SubscriptionTypeNotSupported"
)

// PossibleSubscriptionTransferValidationErrorCodeValues returns an array of possible values for the SubscriptionTransferValidationErrorCode const type.
func PossibleSubscriptionTransferValidationErrorCodeValues() []SubscriptionTransferValidationErrorCode {
	return []SubscriptionTransferValidationErrorCode{SubscriptionTransferValidationErrorCodeCrossBillingAccountNotAllowed, SubscriptionTransferValidationErrorCodeDestinationBillingProfilePastDue, SubscriptionTransferValidationErrorCodeInsufficientPermissionOnDestination, SubscriptionTransferValidationErrorCodeInsufficientPermissionOnSource, SubscriptionTransferValidationErrorCodeInvalidSource, SubscriptionTransferValidationErrorCodeNotAvailableForDestinationMarket, SubscriptionTransferValidationErrorCodeSubscriptionNotActive, SubscriptionTransferValidationErrorCodeSubscriptionTypeNotSupported}
}

// TargetCloud enumerates the values for target cloud.
type TargetCloud string

const (
	// USGov ...
	USGov TargetCloud = "USGov"
	// USNat ...
	USNat TargetCloud = "USNat"
	// USSec ...
	USSec TargetCloud = "USSec"
)

// PossibleTargetCloudValues returns an array of possible values for the TargetCloud const type.
func PossibleTargetCloudValues() []TargetCloud {
	return []TargetCloud{USGov, USNat, USSec}
}

// TransactionTypeKind enumerates the values for transaction type kind.
type TransactionTypeKind string

const (
	// All ...
	All TransactionTypeKind = "all"
	// Reservation ...
	Reservation TransactionTypeKind = "reservation"
)

// PossibleTransactionTypeKindValues returns an array of possible values for the TransactionTypeKind const type.
func PossibleTransactionTypeKindValues() []TransactionTypeKind {
	return []TransactionTypeKind{All, Reservation}
}

// ViewCharges enumerates the values for view charges.
type ViewCharges string

const (
	// ViewChargesAllowed ...
	ViewChargesAllowed ViewCharges = "Allowed"
	// ViewChargesNotAllowed ...
	ViewChargesNotAllowed ViewCharges = "NotAllowed"
)

// PossibleViewChargesValues returns an array of possible values for the ViewCharges const type.
func PossibleViewChargesValues() []ViewCharges {
	return []ViewCharges{ViewChargesAllowed, ViewChargesNotAllowed}
}

// ViewChargesPolicy enumerates the values for view charges policy.
type ViewChargesPolicy string

const (
	// ViewChargesPolicyAllowed ...
	ViewChargesPolicyAllowed ViewChargesPolicy = "Allowed"
	// ViewChargesPolicyNotAllowed ...
	ViewChargesPolicyNotAllowed ViewChargesPolicy = "NotAllowed"
)

// PossibleViewChargesPolicyValues returns an array of possible values for the ViewChargesPolicy const type.
func PossibleViewChargesPolicyValues() []ViewChargesPolicy {
	return []ViewChargesPolicy{ViewChargesPolicyAllowed, ViewChargesPolicyNotAllowed}
}
