// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/api/v2/core/address.proto

package envoy_api_v2_core

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"strings"
	"time"
	"unicode/utf8"

	"github.com/golang/protobuf/ptypes"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = ptypes.DynamicAny{}
)

// define the regex for a UUID once up-front
var _address_uuidPattern = regexp.MustCompile("^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$")

// Validate checks the field values on Pipe with the rules defined in the proto
// definition for this message. If any rules are violated, an error is returned.
func (m *Pipe) Validate() error {
	if m == nil {
		return nil
	}

	if len(m.GetPath()) < 1 {
		return PipeValidationError{
			field:  "Path",
			reason: "value length must be at least 1 bytes",
		}
	}

	return nil
}

// PipeValidationError is the validation error returned by Pipe.Validate if the
// designated constraints aren't met.
type PipeValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PipeValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PipeValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PipeValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PipeValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PipeValidationError) ErrorName() string { return "PipeValidationError" }

// Error satisfies the builtin error interface
func (e PipeValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPipe.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PipeValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PipeValidationError{}

// Validate checks the field values on SocketAddress with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *SocketAddress) Validate() error {
	if m == nil {
		return nil
	}

	if _, ok := SocketAddress_Protocol_name[int32(m.GetProtocol())]; !ok {
		return SocketAddressValidationError{
			field:  "Protocol",
			reason: "value must be one of the defined enum values",
		}
	}

	if len(m.GetAddress()) < 1 {
		return SocketAddressValidationError{
			field:  "Address",
			reason: "value length must be at least 1 bytes",
		}
	}

	// no validation rules for ResolverName

	// no validation rules for Ipv4Compat

	switch m.PortSpecifier.(type) {

	case *SocketAddress_PortValue:

		if m.GetPortValue() > 65535 {
			return SocketAddressValidationError{
				field:  "PortValue",
				reason: "value must be less than or equal to 65535",
			}
		}

	case *SocketAddress_NamedPort:
		// no validation rules for NamedPort

	default:
		return SocketAddressValidationError{
			field:  "PortSpecifier",
			reason: "value is required",
		}

	}

	return nil
}

// SocketAddressValidationError is the validation error returned by
// SocketAddress.Validate if the designated constraints aren't met.
type SocketAddressValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e SocketAddressValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e SocketAddressValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e SocketAddressValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e SocketAddressValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e SocketAddressValidationError) ErrorName() string { return "SocketAddressValidationError" }

// Error satisfies the builtin error interface
func (e SocketAddressValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sSocketAddress.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = SocketAddressValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = SocketAddressValidationError{}

// Validate checks the field values on TcpKeepalive with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *TcpKeepalive) Validate() error {
	if m == nil {
		return nil
	}

	if v, ok := interface{}(m.GetKeepaliveProbes()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return TcpKeepaliveValidationError{
				field:  "KeepaliveProbes",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetKeepaliveTime()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return TcpKeepaliveValidationError{
				field:  "KeepaliveTime",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetKeepaliveInterval()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return TcpKeepaliveValidationError{
				field:  "KeepaliveInterval",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	return nil
}

// TcpKeepaliveValidationError is the validation error returned by
// TcpKeepalive.Validate if the designated constraints aren't met.
type TcpKeepaliveValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e TcpKeepaliveValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e TcpKeepaliveValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e TcpKeepaliveValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e TcpKeepaliveValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e TcpKeepaliveValidationError) ErrorName() string { return "TcpKeepaliveValidationError" }

// Error satisfies the builtin error interface
func (e TcpKeepaliveValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sTcpKeepalive.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = TcpKeepaliveValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = TcpKeepaliveValidationError{}

// Validate checks the field values on BindConfig with the rules defined in the
// proto definition for this message. If any rules are violated, an error is returned.
func (m *BindConfig) Validate() error {
	if m == nil {
		return nil
	}

	if m.GetSourceAddress() == nil {
		return BindConfigValidationError{
			field:  "SourceAddress",
			reason: "value is required",
		}
	}

	if v, ok := interface{}(m.GetSourceAddress()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return BindConfigValidationError{
				field:  "SourceAddress",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetFreebind()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return BindConfigValidationError{
				field:  "Freebind",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	for idx, item := range m.GetSocketOptions() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return BindConfigValidationError{
					field:  fmt.Sprintf("SocketOptions[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	return nil
}

// BindConfigValidationError is the validation error returned by
// BindConfig.Validate if the designated constraints aren't met.
type BindConfigValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e BindConfigValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e BindConfigValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e BindConfigValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e BindConfigValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e BindConfigValidationError) ErrorName() string { return "BindConfigValidationError" }

// Error satisfies the builtin error interface
func (e BindConfigValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sBindConfig.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = BindConfigValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = BindConfigValidationError{}

// Validate checks the field values on Address with the rules defined in the
// proto definition for this message. If any rules are violated, an error is returned.
func (m *Address) Validate() error {
	if m == nil {
		return nil
	}

	switch m.Address.(type) {

	case *Address_SocketAddress:

		if v, ok := interface{}(m.GetSocketAddress()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return AddressValidationError{
					field:  "SocketAddress",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *Address_Pipe:

		if v, ok := interface{}(m.GetPipe()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return AddressValidationError{
					field:  "Pipe",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		return AddressValidationError{
			field:  "Address",
			reason: "value is required",
		}

	}

	return nil
}

// AddressValidationError is the validation error returned by Address.Validate
// if the designated constraints aren't met.
type AddressValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e AddressValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e AddressValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e AddressValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e AddressValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e AddressValidationError) ErrorName() string { return "AddressValidationError" }

// Error satisfies the builtin error interface
func (e AddressValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAddress.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = AddressValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = AddressValidationError{}

// Validate checks the field values on CidrRange with the rules defined in the
// proto definition for this message. If any rules are violated, an error is returned.
func (m *CidrRange) Validate() error {
	if m == nil {
		return nil
	}

	if len(m.GetAddressPrefix()) < 1 {
		return CidrRangeValidationError{
			field:  "AddressPrefix",
			reason: "value length must be at least 1 bytes",
		}
	}

	if wrapper := m.GetPrefixLen(); wrapper != nil {

		if wrapper.GetValue() > 128 {
			return CidrRangeValidationError{
				field:  "PrefixLen",
				reason: "value must be less than or equal to 128",
			}
		}

	}

	return nil
}

// CidrRangeValidationError is the validation error returned by
// CidrRange.Validate if the designated constraints aren't met.
type CidrRangeValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e CidrRangeValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e CidrRangeValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e CidrRangeValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e CidrRangeValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e CidrRangeValidationError) ErrorName() string { return "CidrRangeValidationError" }

// Error satisfies the builtin error interface
func (e CidrRangeValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCidrRange.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = CidrRangeValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = CidrRangeValidationError{}
