// Code generated by go-swagger; DO NOT EDIT.

package teams

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewRemoveTeamMemberParams creates a new RemoveTeamMemberParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewRemoveTeamMemberParams() *RemoveTeamMemberParams {
	return &RemoveTeamMemberParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewRemoveTeamMemberParamsWithTimeout creates a new RemoveTeamMemberParams object
// with the ability to set a timeout on a request.
func NewRemoveTeamMemberParamsWithTimeout(timeout time.Duration) *RemoveTeamMemberParams {
	return &RemoveTeamMemberParams{
		timeout: timeout,
	}
}

// NewRemoveTeamMemberParamsWithContext creates a new RemoveTeamMemberParams object
// with the ability to set a context for a request.
func NewRemoveTeamMemberParamsWithContext(ctx context.Context) *RemoveTeamMemberParams {
	return &RemoveTeamMemberParams{
		Context: ctx,
	}
}

// NewRemoveTeamMemberParamsWithHTTPClient creates a new RemoveTeamMemberParams object
// with the ability to set a custom HTTPClient for a request.
func NewRemoveTeamMemberParamsWithHTTPClient(client *http.Client) *RemoveTeamMemberParams {
	return &RemoveTeamMemberParams{
		HTTPClient: client,
	}
}

/*
RemoveTeamMemberParams contains all the parameters to send to the API endpoint

	for the remove team member operation.

	Typically these are written to a http.Request.
*/
type RemoveTeamMemberParams struct {

	// TeamID.
	TeamID string

	// UserID.
	//
	// Format: int64
	UserID int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the remove team member params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *RemoveTeamMemberParams) WithDefaults() *RemoveTeamMemberParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the remove team member params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *RemoveTeamMemberParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the remove team member params
func (o *RemoveTeamMemberParams) WithTimeout(timeout time.Duration) *RemoveTeamMemberParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the remove team member params
func (o *RemoveTeamMemberParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the remove team member params
func (o *RemoveTeamMemberParams) WithContext(ctx context.Context) *RemoveTeamMemberParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the remove team member params
func (o *RemoveTeamMemberParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the remove team member params
func (o *RemoveTeamMemberParams) WithHTTPClient(client *http.Client) *RemoveTeamMemberParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the remove team member params
func (o *RemoveTeamMemberParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithTeamID adds the teamID to the remove team member params
func (o *RemoveTeamMemberParams) WithTeamID(teamID string) *RemoveTeamMemberParams {
	o.SetTeamID(teamID)
	return o
}

// SetTeamID adds the teamId to the remove team member params
func (o *RemoveTeamMemberParams) SetTeamID(teamID string) {
	o.TeamID = teamID
}

// WithUserID adds the userID to the remove team member params
func (o *RemoveTeamMemberParams) WithUserID(userID int64) *RemoveTeamMemberParams {
	o.SetUserID(userID)
	return o
}

// SetUserID adds the userId to the remove team member params
func (o *RemoveTeamMemberParams) SetUserID(userID int64) {
	o.UserID = userID
}

// WriteToRequest writes these params to a swagger request
func (o *RemoveTeamMemberParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param team_id
	if err := r.SetPathParam("team_id", o.TeamID); err != nil {
		return err
	}

	// path param user_id
	if err := r.SetPathParam("user_id", swag.FormatInt64(o.UserID)); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
