// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// RouteExport RouteExport is the provisioned file export of definitions.Route. This is needed to hide fields that aren't useable in
// provisioning file format. An alternative would be to define a custom MarshalJSON and MarshalYAML that excludes them.
//
// swagger:model RouteExport
type RouteExport struct {

	// continue
	Continue bool `json:"continue,omitempty"`

	// group by
	GroupBy []string `json:"group_by"`

	// group interval
	GroupInterval string `json:"group_interval,omitempty"`

	// group wait
	GroupWait string `json:"group_wait,omitempty"`

	// Deprecated. Remove before v1.0 release.
	Match map[string]string `json:"match,omitempty"`

	// match re
	MatchRe MatchRegexps `json:"match_re,omitempty"`

	// matchers
	Matchers Matchers `json:"matchers,omitempty"`

	// mute time intervals
	MuteTimeIntervals []string `json:"mute_time_intervals"`

	// object matchers
	ObjectMatchers ObjectMatchers `json:"object_matchers,omitempty"`

	// receiver
	Receiver string `json:"receiver,omitempty"`

	// repeat interval
	RepeatInterval string `json:"repeat_interval,omitempty"`

	// routes
	Routes []*RouteExport `json:"routes"`
}

// Validate validates this route export
func (m *RouteExport) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateMatchRe(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMatchers(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateObjectMatchers(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRoutes(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *RouteExport) validateMatchRe(formats strfmt.Registry) error {
	if swag.IsZero(m.MatchRe) { // not required
		return nil
	}

	if m.MatchRe != nil {
		if err := m.MatchRe.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("match_re")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("match_re")
			}
			return err
		}
	}

	return nil
}

func (m *RouteExport) validateMatchers(formats strfmt.Registry) error {
	if swag.IsZero(m.Matchers) { // not required
		return nil
	}

	if err := m.Matchers.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("matchers")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("matchers")
		}
		return err
	}

	return nil
}

func (m *RouteExport) validateObjectMatchers(formats strfmt.Registry) error {
	if swag.IsZero(m.ObjectMatchers) { // not required
		return nil
	}

	if err := m.ObjectMatchers.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("object_matchers")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("object_matchers")
		}
		return err
	}

	return nil
}

func (m *RouteExport) validateRoutes(formats strfmt.Registry) error {
	if swag.IsZero(m.Routes) { // not required
		return nil
	}

	for i := 0; i < len(m.Routes); i++ {
		if swag.IsZero(m.Routes[i]) { // not required
			continue
		}

		if m.Routes[i] != nil {
			if err := m.Routes[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("routes" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("routes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this route export based on the context it is used
func (m *RouteExport) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateMatchRe(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMatchers(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateObjectMatchers(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRoutes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *RouteExport) contextValidateMatchRe(ctx context.Context, formats strfmt.Registry) error {

	if swag.IsZero(m.MatchRe) { // not required
		return nil
	}

	if err := m.MatchRe.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("match_re")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("match_re")
		}
		return err
	}

	return nil
}

func (m *RouteExport) contextValidateMatchers(ctx context.Context, formats strfmt.Registry) error {

	if err := m.Matchers.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("matchers")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("matchers")
		}
		return err
	}

	return nil
}

func (m *RouteExport) contextValidateObjectMatchers(ctx context.Context, formats strfmt.Registry) error {

	if err := m.ObjectMatchers.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("object_matchers")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("object_matchers")
		}
		return err
	}

	return nil
}

func (m *RouteExport) contextValidateRoutes(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Routes); i++ {

		if m.Routes[i] != nil {

			if swag.IsZero(m.Routes[i]) { // not required
				return nil
			}

			if err := m.Routes[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("routes" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("routes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *RouteExport) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *RouteExport) UnmarshalBinary(b []byte) error {
	var res RouteExport
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
