// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.12.3
// source: google/ads/googleads/v2/resources/campaign.proto

package resources

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	common "google.golang.org/genproto/googleapis/ads/googleads/v2/common"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v2/enums"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// A campaign.
type Campaign struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. The resource name of the campaign.
	// Campaign resource names have the form:
	//
	// `customers/{customer_id}/campaigns/{campaign_id}`
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// Output only. The ID of the campaign.
	Id *wrapperspb.Int64Value `protobuf:"bytes,3,opt,name=id,proto3" json:"id,omitempty"`
	// The name of the campaign.
	//
	// This field is required and should not be empty when creating new
	// campaigns.
	//
	// It must not contain any null (code point 0x0), NL line feed
	// (code point 0xA) or carriage return (code point 0xD) characters.
	Name *wrapperspb.StringValue `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// The status of the campaign.
	//
	// When a new campaign is added, the status defaults to ENABLED.
	Status enums.CampaignStatusEnum_CampaignStatus `protobuf:"varint,5,opt,name=status,proto3,enum=google.ads.googleads.v2.enums.CampaignStatusEnum_CampaignStatus" json:"status,omitempty"`
	// Output only. The ad serving status of the campaign.
	ServingStatus enums.CampaignServingStatusEnum_CampaignServingStatus `protobuf:"varint,21,opt,name=serving_status,json=servingStatus,proto3,enum=google.ads.googleads.v2.enums.CampaignServingStatusEnum_CampaignServingStatus" json:"serving_status,omitempty"`
	// The ad serving optimization status of the campaign.
	AdServingOptimizationStatus enums.AdServingOptimizationStatusEnum_AdServingOptimizationStatus `protobuf:"varint,8,opt,name=ad_serving_optimization_status,json=adServingOptimizationStatus,proto3,enum=google.ads.googleads.v2.enums.AdServingOptimizationStatusEnum_AdServingOptimizationStatus" json:"ad_serving_optimization_status,omitempty"`
	// Immutable. The primary serving target for ads within the campaign.
	// The targeting options can be refined in `network_settings`.
	//
	// This field is required and should not be empty when creating new
	// campaigns.
	//
	// Can be set only when creating campaigns.
	// After the campaign is created, the field can not be changed.
	AdvertisingChannelType enums.AdvertisingChannelTypeEnum_AdvertisingChannelType `protobuf:"varint,9,opt,name=advertising_channel_type,json=advertisingChannelType,proto3,enum=google.ads.googleads.v2.enums.AdvertisingChannelTypeEnum_AdvertisingChannelType" json:"advertising_channel_type,omitempty"`
	// Immutable. Optional refinement to `advertising_channel_type`.
	// Must be a valid sub-type of the parent channel type.
	//
	// Can be set only when creating campaigns.
	// After campaign is created, the field can not be changed.
	AdvertisingChannelSubType enums.AdvertisingChannelSubTypeEnum_AdvertisingChannelSubType `protobuf:"varint,10,opt,name=advertising_channel_sub_type,json=advertisingChannelSubType,proto3,enum=google.ads.googleads.v2.enums.AdvertisingChannelSubTypeEnum_AdvertisingChannelSubType" json:"advertising_channel_sub_type,omitempty"`
	// The URL template for constructing a tracking URL.
	TrackingUrlTemplate *wrapperspb.StringValue `protobuf:"bytes,11,opt,name=tracking_url_template,json=trackingUrlTemplate,proto3" json:"tracking_url_template,omitempty"`
	// The list of mappings used to substitute custom parameter tags in a
	// `tracking_url_template`, `final_urls`, or `mobile_final_urls`.
	UrlCustomParameters []*common.CustomParameter `protobuf:"bytes,12,rep,name=url_custom_parameters,json=urlCustomParameters,proto3" json:"url_custom_parameters,omitempty"`
	// Settings for Real-Time Bidding, a feature only available for campaigns
	// targeting the Ad Exchange network.
	RealTimeBiddingSetting *common.RealTimeBiddingSetting `protobuf:"bytes,39,opt,name=real_time_bidding_setting,json=realTimeBiddingSetting,proto3" json:"real_time_bidding_setting,omitempty"`
	// The network settings for the campaign.
	NetworkSettings *Campaign_NetworkSettings `protobuf:"bytes,14,opt,name=network_settings,json=networkSettings,proto3" json:"network_settings,omitempty"`
	// Immutable. The hotel setting for the campaign.
	HotelSetting *Campaign_HotelSettingInfo `protobuf:"bytes,32,opt,name=hotel_setting,json=hotelSetting,proto3" json:"hotel_setting,omitempty"`
	// The setting for controlling Dynamic Search Ads (DSA).
	DynamicSearchAdsSetting *Campaign_DynamicSearchAdsSetting `protobuf:"bytes,33,opt,name=dynamic_search_ads_setting,json=dynamicSearchAdsSetting,proto3" json:"dynamic_search_ads_setting,omitempty"`
	// The setting for controlling Shopping campaigns.
	ShoppingSetting *Campaign_ShoppingSetting `protobuf:"bytes,36,opt,name=shopping_setting,json=shoppingSetting,proto3" json:"shopping_setting,omitempty"`
	// Setting for targeting related features.
	TargetingSetting *common.TargetingSetting `protobuf:"bytes,43,opt,name=targeting_setting,json=targetingSetting,proto3" json:"targeting_setting,omitempty"`
	// The setting for ads geotargeting.
	GeoTargetTypeSetting *Campaign_GeoTargetTypeSetting `protobuf:"bytes,47,opt,name=geo_target_type_setting,json=geoTargetTypeSetting,proto3" json:"geo_target_type_setting,omitempty"`
	// The setting related to App Campaign.
	AppCampaignSetting *Campaign_AppCampaignSetting `protobuf:"bytes,51,opt,name=app_campaign_setting,json=appCampaignSetting,proto3" json:"app_campaign_setting,omitempty"`
	// Output only. The resource names of labels attached to this campaign.
	Labels []*wrapperspb.StringValue `protobuf:"bytes,53,rep,name=labels,proto3" json:"labels,omitempty"`
	// Output only. The type of campaign: normal, draft, or experiment.
	ExperimentType enums.CampaignExperimentTypeEnum_CampaignExperimentType `protobuf:"varint,17,opt,name=experiment_type,json=experimentType,proto3,enum=google.ads.googleads.v2.enums.CampaignExperimentTypeEnum_CampaignExperimentType" json:"experiment_type,omitempty"`
	// Output only. The resource name of the base campaign of a draft or experiment campaign.
	// For base campaigns, this is equal to `resource_name`.
	//
	// This field is read-only.
	BaseCampaign *wrapperspb.StringValue `protobuf:"bytes,28,opt,name=base_campaign,json=baseCampaign,proto3" json:"base_campaign,omitempty"`
	// The budget of the campaign.
	CampaignBudget *wrapperspb.StringValue `protobuf:"bytes,6,opt,name=campaign_budget,json=campaignBudget,proto3" json:"campaign_budget,omitempty"`
	// Output only. The type of bidding strategy.
	//
	// A bidding strategy can be created by setting either the bidding scheme to
	// create a standard bidding strategy or the `bidding_strategy` field to
	// create a portfolio bidding strategy.
	//
	// This field is read-only.
	BiddingStrategyType enums.BiddingStrategyTypeEnum_BiddingStrategyType `protobuf:"varint,22,opt,name=bidding_strategy_type,json=biddingStrategyType,proto3,enum=google.ads.googleads.v2.enums.BiddingStrategyTypeEnum_BiddingStrategyType" json:"bidding_strategy_type,omitempty"`
	// The date when campaign started.
	// This field must not be used in WHERE clauses.
	StartDate *wrapperspb.StringValue `protobuf:"bytes,19,opt,name=start_date,json=startDate,proto3" json:"start_date,omitempty"`
	// The date when campaign ended.
	// This field must not be used in WHERE clauses.
	EndDate *wrapperspb.StringValue `protobuf:"bytes,20,opt,name=end_date,json=endDate,proto3" json:"end_date,omitempty"`
	// Suffix used to append query parameters to landing pages that are served
	// with parallel tracking.
	FinalUrlSuffix *wrapperspb.StringValue `protobuf:"bytes,38,opt,name=final_url_suffix,json=finalUrlSuffix,proto3" json:"final_url_suffix,omitempty"`
	// A list that limits how often each user will see this campaign's ads.
	FrequencyCaps []*common.FrequencyCapEntry `protobuf:"bytes,40,rep,name=frequency_caps,json=frequencyCaps,proto3" json:"frequency_caps,omitempty"`
	// Output only. 3-Tier Brand Safety setting for the campaign.
	VideoBrandSafetySuitability enums.BrandSafetySuitabilityEnum_BrandSafetySuitability `protobuf:"varint,42,opt,name=video_brand_safety_suitability,json=videoBrandSafetySuitability,proto3,enum=google.ads.googleads.v2.enums.BrandSafetySuitabilityEnum_BrandSafetySuitability" json:"video_brand_safety_suitability,omitempty"`
	// Describes how unbranded pharma ads will be displayed.
	VanityPharma *Campaign_VanityPharma `protobuf:"bytes,44,opt,name=vanity_pharma,json=vanityPharma,proto3" json:"vanity_pharma,omitempty"`
	// Selective optimization setting for this campaign, which includes a set of
	// conversion actions to optimize this campaign towards.
	SelectiveOptimization *Campaign_SelectiveOptimization `protobuf:"bytes,45,opt,name=selective_optimization,json=selectiveOptimization,proto3" json:"selective_optimization,omitempty"`
	// Output only. Campaign-level settings for tracking information.
	TrackingSetting *Campaign_TrackingSetting `protobuf:"bytes,46,opt,name=tracking_setting,json=trackingSetting,proto3" json:"tracking_setting,omitempty"`
	// Payment mode for the campaign.
	PaymentMode enums.PaymentModeEnum_PaymentMode `protobuf:"varint,52,opt,name=payment_mode,json=paymentMode,proto3,enum=google.ads.googleads.v2.enums.PaymentModeEnum_PaymentMode" json:"payment_mode,omitempty"`
	// The bidding strategy for the campaign.
	//
	// Must be either portfolio (created via BiddingStrategy service) or
	// standard, that is embedded into the campaign.
	//
	// Types that are assignable to CampaignBiddingStrategy:
	//	*Campaign_BiddingStrategy
	//	*Campaign_Commission
	//	*Campaign_ManualCpc
	//	*Campaign_ManualCpm
	//	*Campaign_ManualCpv
	//	*Campaign_MaximizeConversions
	//	*Campaign_MaximizeConversionValue
	//	*Campaign_TargetCpa
	//	*Campaign_TargetImpressionShare
	//	*Campaign_TargetRoas
	//	*Campaign_TargetSpend
	//	*Campaign_PercentCpc
	//	*Campaign_TargetCpm
	CampaignBiddingStrategy isCampaign_CampaignBiddingStrategy `protobuf_oneof:"campaign_bidding_strategy"`
}

func (x *Campaign) Reset() {
	*x = Campaign{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v2_resources_campaign_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Campaign) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Campaign) ProtoMessage() {}

func (x *Campaign) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v2_resources_campaign_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Campaign.ProtoReflect.Descriptor instead.
func (*Campaign) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v2_resources_campaign_proto_rawDescGZIP(), []int{0}
}

func (x *Campaign) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

func (x *Campaign) GetId() *wrapperspb.Int64Value {
	if x != nil {
		return x.Id
	}
	return nil
}

func (x *Campaign) GetName() *wrapperspb.StringValue {
	if x != nil {
		return x.Name
	}
	return nil
}

func (x *Campaign) GetStatus() enums.CampaignStatusEnum_CampaignStatus {
	if x != nil {
		return x.Status
	}
	return enums.CampaignStatusEnum_UNSPECIFIED
}

func (x *Campaign) GetServingStatus() enums.CampaignServingStatusEnum_CampaignServingStatus {
	if x != nil {
		return x.ServingStatus
	}
	return enums.CampaignServingStatusEnum_UNSPECIFIED
}

func (x *Campaign) GetAdServingOptimizationStatus() enums.AdServingOptimizationStatusEnum_AdServingOptimizationStatus {
	if x != nil {
		return x.AdServingOptimizationStatus
	}
	return enums.AdServingOptimizationStatusEnum_UNSPECIFIED
}

func (x *Campaign) GetAdvertisingChannelType() enums.AdvertisingChannelTypeEnum_AdvertisingChannelType {
	if x != nil {
		return x.AdvertisingChannelType
	}
	return enums.AdvertisingChannelTypeEnum_UNSPECIFIED
}

func (x *Campaign) GetAdvertisingChannelSubType() enums.AdvertisingChannelSubTypeEnum_AdvertisingChannelSubType {
	if x != nil {
		return x.AdvertisingChannelSubType
	}
	return enums.AdvertisingChannelSubTypeEnum_UNSPECIFIED
}

func (x *Campaign) GetTrackingUrlTemplate() *wrapperspb.StringValue {
	if x != nil {
		return x.TrackingUrlTemplate
	}
	return nil
}

func (x *Campaign) GetUrlCustomParameters() []*common.CustomParameter {
	if x != nil {
		return x.UrlCustomParameters
	}
	return nil
}

func (x *Campaign) GetRealTimeBiddingSetting() *common.RealTimeBiddingSetting {
	if x != nil {
		return x.RealTimeBiddingSetting
	}
	return nil
}

func (x *Campaign) GetNetworkSettings() *Campaign_NetworkSettings {
	if x != nil {
		return x.NetworkSettings
	}
	return nil
}

func (x *Campaign) GetHotelSetting() *Campaign_HotelSettingInfo {
	if x != nil {
		return x.HotelSetting
	}
	return nil
}

func (x *Campaign) GetDynamicSearchAdsSetting() *Campaign_DynamicSearchAdsSetting {
	if x != nil {
		return x.DynamicSearchAdsSetting
	}
	return nil
}

func (x *Campaign) GetShoppingSetting() *Campaign_ShoppingSetting {
	if x != nil {
		return x.ShoppingSetting
	}
	return nil
}

func (x *Campaign) GetTargetingSetting() *common.TargetingSetting {
	if x != nil {
		return x.TargetingSetting
	}
	return nil
}

func (x *Campaign) GetGeoTargetTypeSetting() *Campaign_GeoTargetTypeSetting {
	if x != nil {
		return x.GeoTargetTypeSetting
	}
	return nil
}

func (x *Campaign) GetAppCampaignSetting() *Campaign_AppCampaignSetting {
	if x != nil {
		return x.AppCampaignSetting
	}
	return nil
}

func (x *Campaign) GetLabels() []*wrapperspb.StringValue {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Campaign) GetExperimentType() enums.CampaignExperimentTypeEnum_CampaignExperimentType {
	if x != nil {
		return x.ExperimentType
	}
	return enums.CampaignExperimentTypeEnum_UNSPECIFIED
}

func (x *Campaign) GetBaseCampaign() *wrapperspb.StringValue {
	if x != nil {
		return x.BaseCampaign
	}
	return nil
}

func (x *Campaign) GetCampaignBudget() *wrapperspb.StringValue {
	if x != nil {
		return x.CampaignBudget
	}
	return nil
}

func (x *Campaign) GetBiddingStrategyType() enums.BiddingStrategyTypeEnum_BiddingStrategyType {
	if x != nil {
		return x.BiddingStrategyType
	}
	return enums.BiddingStrategyTypeEnum_UNSPECIFIED
}

func (x *Campaign) GetStartDate() *wrapperspb.StringValue {
	if x != nil {
		return x.StartDate
	}
	return nil
}

func (x *Campaign) GetEndDate() *wrapperspb.StringValue {
	if x != nil {
		return x.EndDate
	}
	return nil
}

func (x *Campaign) GetFinalUrlSuffix() *wrapperspb.StringValue {
	if x != nil {
		return x.FinalUrlSuffix
	}
	return nil
}

func (x *Campaign) GetFrequencyCaps() []*common.FrequencyCapEntry {
	if x != nil {
		return x.FrequencyCaps
	}
	return nil
}

func (x *Campaign) GetVideoBrandSafetySuitability() enums.BrandSafetySuitabilityEnum_BrandSafetySuitability {
	if x != nil {
		return x.VideoBrandSafetySuitability
	}
	return enums.BrandSafetySuitabilityEnum_UNSPECIFIED
}

func (x *Campaign) GetVanityPharma() *Campaign_VanityPharma {
	if x != nil {
		return x.VanityPharma
	}
	return nil
}

func (x *Campaign) GetSelectiveOptimization() *Campaign_SelectiveOptimization {
	if x != nil {
		return x.SelectiveOptimization
	}
	return nil
}

func (x *Campaign) GetTrackingSetting() *Campaign_TrackingSetting {
	if x != nil {
		return x.TrackingSetting
	}
	return nil
}

func (x *Campaign) GetPaymentMode() enums.PaymentModeEnum_PaymentMode {
	if x != nil {
		return x.PaymentMode
	}
	return enums.PaymentModeEnum_UNSPECIFIED
}

func (m *Campaign) GetCampaignBiddingStrategy() isCampaign_CampaignBiddingStrategy {
	if m != nil {
		return m.CampaignBiddingStrategy
	}
	return nil
}

func (x *Campaign) GetBiddingStrategy() *wrapperspb.StringValue {
	if x, ok := x.GetCampaignBiddingStrategy().(*Campaign_BiddingStrategy); ok {
		return x.BiddingStrategy
	}
	return nil
}

func (x *Campaign) GetCommission() *common.Commission {
	if x, ok := x.GetCampaignBiddingStrategy().(*Campaign_Commission); ok {
		return x.Commission
	}
	return nil
}

func (x *Campaign) GetManualCpc() *common.ManualCpc {
	if x, ok := x.GetCampaignBiddingStrategy().(*Campaign_ManualCpc); ok {
		return x.ManualCpc
	}
	return nil
}

func (x *Campaign) GetManualCpm() *common.ManualCpm {
	if x, ok := x.GetCampaignBiddingStrategy().(*Campaign_ManualCpm); ok {
		return x.ManualCpm
	}
	return nil
}

func (x *Campaign) GetManualCpv() *common.ManualCpv {
	if x, ok := x.GetCampaignBiddingStrategy().(*Campaign_ManualCpv); ok {
		return x.ManualCpv
	}
	return nil
}

func (x *Campaign) GetMaximizeConversions() *common.MaximizeConversions {
	if x, ok := x.GetCampaignBiddingStrategy().(*Campaign_MaximizeConversions); ok {
		return x.MaximizeConversions
	}
	return nil
}

func (x *Campaign) GetMaximizeConversionValue() *common.MaximizeConversionValue {
	if x, ok := x.GetCampaignBiddingStrategy().(*Campaign_MaximizeConversionValue); ok {
		return x.MaximizeConversionValue
	}
	return nil
}

func (x *Campaign) GetTargetCpa() *common.TargetCpa {
	if x, ok := x.GetCampaignBiddingStrategy().(*Campaign_TargetCpa); ok {
		return x.TargetCpa
	}
	return nil
}

func (x *Campaign) GetTargetImpressionShare() *common.TargetImpressionShare {
	if x, ok := x.GetCampaignBiddingStrategy().(*Campaign_TargetImpressionShare); ok {
		return x.TargetImpressionShare
	}
	return nil
}

func (x *Campaign) GetTargetRoas() *common.TargetRoas {
	if x, ok := x.GetCampaignBiddingStrategy().(*Campaign_TargetRoas); ok {
		return x.TargetRoas
	}
	return nil
}

func (x *Campaign) GetTargetSpend() *common.TargetSpend {
	if x, ok := x.GetCampaignBiddingStrategy().(*Campaign_TargetSpend); ok {
		return x.TargetSpend
	}
	return nil
}

func (x *Campaign) GetPercentCpc() *common.PercentCpc {
	if x, ok := x.GetCampaignBiddingStrategy().(*Campaign_PercentCpc); ok {
		return x.PercentCpc
	}
	return nil
}

func (x *Campaign) GetTargetCpm() *common.TargetCpm {
	if x, ok := x.GetCampaignBiddingStrategy().(*Campaign_TargetCpm); ok {
		return x.TargetCpm
	}
	return nil
}

type isCampaign_CampaignBiddingStrategy interface {
	isCampaign_CampaignBiddingStrategy()
}

type Campaign_BiddingStrategy struct {
	// Portfolio bidding strategy used by campaign.
	BiddingStrategy *wrapperspb.StringValue `protobuf:"bytes,23,opt,name=bidding_strategy,json=biddingStrategy,proto3,oneof"`
}

type Campaign_Commission struct {
	// Commission is an automatic bidding strategy in which the advertiser pays
	// a certain portion of the conversion value.
	Commission *common.Commission `protobuf:"bytes,49,opt,name=commission,proto3,oneof"`
}

type Campaign_ManualCpc struct {
	// Standard Manual CPC bidding strategy.
	// Manual click-based bidding where user pays per click.
	ManualCpc *common.ManualCpc `protobuf:"bytes,24,opt,name=manual_cpc,json=manualCpc,proto3,oneof"`
}

type Campaign_ManualCpm struct {
	// Standard Manual CPM bidding strategy.
	// Manual impression-based bidding where user pays per thousand
	// impressions.
	ManualCpm *common.ManualCpm `protobuf:"bytes,25,opt,name=manual_cpm,json=manualCpm,proto3,oneof"`
}

type Campaign_ManualCpv struct {
	// Output only. A bidding strategy that pays a configurable amount per video view.
	ManualCpv *common.ManualCpv `protobuf:"bytes,37,opt,name=manual_cpv,json=manualCpv,proto3,oneof"`
}

type Campaign_MaximizeConversions struct {
	// Standard Maximize Conversions bidding strategy that automatically
	// maximizes number of conversions given a daily budget.
	MaximizeConversions *common.MaximizeConversions `protobuf:"bytes,30,opt,name=maximize_conversions,json=maximizeConversions,proto3,oneof"`
}

type Campaign_MaximizeConversionValue struct {
	// Standard Maximize Conversion Value bidding strategy that automatically
	// sets bids to maximize revenue while spending your budget.
	MaximizeConversionValue *common.MaximizeConversionValue `protobuf:"bytes,31,opt,name=maximize_conversion_value,json=maximizeConversionValue,proto3,oneof"`
}

type Campaign_TargetCpa struct {
	// Standard Target CPA bidding strategy that automatically sets bids to
	// help get as many conversions as possible at the target
	// cost-per-acquisition (CPA) you set.
	TargetCpa *common.TargetCpa `protobuf:"bytes,26,opt,name=target_cpa,json=targetCpa,proto3,oneof"`
}

type Campaign_TargetImpressionShare struct {
	// Target Impression Share bidding strategy. An automated bidding strategy
	// that sets bids to achieve a desired percentage of impressions.
	TargetImpressionShare *common.TargetImpressionShare `protobuf:"bytes,48,opt,name=target_impression_share,json=targetImpressionShare,proto3,oneof"`
}

type Campaign_TargetRoas struct {
	// Standard Target ROAS bidding strategy that automatically maximizes
	// revenue while averaging a specific target return on ad spend (ROAS).
	TargetRoas *common.TargetRoas `protobuf:"bytes,29,opt,name=target_roas,json=targetRoas,proto3,oneof"`
}

type Campaign_TargetSpend struct {
	// Standard Target Spend bidding strategy that automatically sets your bids
	// to help get as many clicks as possible within your budget.
	TargetSpend *common.TargetSpend `protobuf:"bytes,27,opt,name=target_spend,json=targetSpend,proto3,oneof"`
}

type Campaign_PercentCpc struct {
	// Standard Percent Cpc bidding strategy where bids are a fraction of the
	// advertised price for some good or service.
	PercentCpc *common.PercentCpc `protobuf:"bytes,34,opt,name=percent_cpc,json=percentCpc,proto3,oneof"`
}

type Campaign_TargetCpm struct {
	// A bidding strategy that automatically optimizes cost per thousand
	// impressions.
	TargetCpm *common.TargetCpm `protobuf:"bytes,41,opt,name=target_cpm,json=targetCpm,proto3,oneof"`
}

func (*Campaign_BiddingStrategy) isCampaign_CampaignBiddingStrategy() {}

func (*Campaign_Commission) isCampaign_CampaignBiddingStrategy() {}

func (*Campaign_ManualCpc) isCampaign_CampaignBiddingStrategy() {}

func (*Campaign_ManualCpm) isCampaign_CampaignBiddingStrategy() {}

func (*Campaign_ManualCpv) isCampaign_CampaignBiddingStrategy() {}

func (*Campaign_MaximizeConversions) isCampaign_CampaignBiddingStrategy() {}

func (*Campaign_MaximizeConversionValue) isCampaign_CampaignBiddingStrategy() {}

func (*Campaign_TargetCpa) isCampaign_CampaignBiddingStrategy() {}

func (*Campaign_TargetImpressionShare) isCampaign_CampaignBiddingStrategy() {}

func (*Campaign_TargetRoas) isCampaign_CampaignBiddingStrategy() {}

func (*Campaign_TargetSpend) isCampaign_CampaignBiddingStrategy() {}

func (*Campaign_PercentCpc) isCampaign_CampaignBiddingStrategy() {}

func (*Campaign_TargetCpm) isCampaign_CampaignBiddingStrategy() {}

// The network settings for the campaign.
type Campaign_NetworkSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether ads will be served with google.com search results.
	TargetGoogleSearch *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=target_google_search,json=targetGoogleSearch,proto3" json:"target_google_search,omitempty"`
	// Whether ads will be served on partner sites in the Google Search Network
	// (requires `target_google_search` to also be `true`).
	TargetSearchNetwork *wrapperspb.BoolValue `protobuf:"bytes,2,opt,name=target_search_network,json=targetSearchNetwork,proto3" json:"target_search_network,omitempty"`
	// Whether ads will be served on specified placements in the Google Display
	// Network. Placements are specified using the Placement criterion.
	TargetContentNetwork *wrapperspb.BoolValue `protobuf:"bytes,3,opt,name=target_content_network,json=targetContentNetwork,proto3" json:"target_content_network,omitempty"`
	// Whether ads will be served on the Google Partner Network.
	// This is available only to some select Google partner accounts.
	TargetPartnerSearchNetwork *wrapperspb.BoolValue `protobuf:"bytes,4,opt,name=target_partner_search_network,json=targetPartnerSearchNetwork,proto3" json:"target_partner_search_network,omitempty"`
}

func (x *Campaign_NetworkSettings) Reset() {
	*x = Campaign_NetworkSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v2_resources_campaign_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Campaign_NetworkSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Campaign_NetworkSettings) ProtoMessage() {}

func (x *Campaign_NetworkSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v2_resources_campaign_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Campaign_NetworkSettings.ProtoReflect.Descriptor instead.
func (*Campaign_NetworkSettings) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v2_resources_campaign_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Campaign_NetworkSettings) GetTargetGoogleSearch() *wrapperspb.BoolValue {
	if x != nil {
		return x.TargetGoogleSearch
	}
	return nil
}

func (x *Campaign_NetworkSettings) GetTargetSearchNetwork() *wrapperspb.BoolValue {
	if x != nil {
		return x.TargetSearchNetwork
	}
	return nil
}

func (x *Campaign_NetworkSettings) GetTargetContentNetwork() *wrapperspb.BoolValue {
	if x != nil {
		return x.TargetContentNetwork
	}
	return nil
}

func (x *Campaign_NetworkSettings) GetTargetPartnerSearchNetwork() *wrapperspb.BoolValue {
	if x != nil {
		return x.TargetPartnerSearchNetwork
	}
	return nil
}

// Campaign-level settings for hotel ads.
type Campaign_HotelSettingInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. The linked Hotel Center account.
	HotelCenterId *wrapperspb.Int64Value `protobuf:"bytes,1,opt,name=hotel_center_id,json=hotelCenterId,proto3" json:"hotel_center_id,omitempty"`
}

func (x *Campaign_HotelSettingInfo) Reset() {
	*x = Campaign_HotelSettingInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v2_resources_campaign_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Campaign_HotelSettingInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Campaign_HotelSettingInfo) ProtoMessage() {}

func (x *Campaign_HotelSettingInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v2_resources_campaign_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Campaign_HotelSettingInfo.ProtoReflect.Descriptor instead.
func (*Campaign_HotelSettingInfo) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v2_resources_campaign_proto_rawDescGZIP(), []int{0, 1}
}

func (x *Campaign_HotelSettingInfo) GetHotelCenterId() *wrapperspb.Int64Value {
	if x != nil {
		return x.HotelCenterId
	}
	return nil
}

// The setting for controlling Dynamic Search Ads (DSA).
type Campaign_DynamicSearchAdsSetting struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Internet domain name that this setting represents, e.g., "google.com"
	// or "www.google.com".
	DomainName *wrapperspb.StringValue `protobuf:"bytes,1,opt,name=domain_name,json=domainName,proto3" json:"domain_name,omitempty"`
	// The language code specifying the language of the domain, e.g., "en".
	LanguageCode *wrapperspb.StringValue `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Whether the campaign uses advertiser supplied URLs exclusively.
	UseSuppliedUrlsOnly *wrapperspb.BoolValue `protobuf:"bytes,3,opt,name=use_supplied_urls_only,json=useSuppliedUrlsOnly,proto3" json:"use_supplied_urls_only,omitempty"`
	// Output only. The list of page feeds associated with the campaign.
	Feeds []*wrapperspb.StringValue `protobuf:"bytes,5,rep,name=feeds,proto3" json:"feeds,omitempty"`
}

func (x *Campaign_DynamicSearchAdsSetting) Reset() {
	*x = Campaign_DynamicSearchAdsSetting{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v2_resources_campaign_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Campaign_DynamicSearchAdsSetting) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Campaign_DynamicSearchAdsSetting) ProtoMessage() {}

func (x *Campaign_DynamicSearchAdsSetting) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v2_resources_campaign_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Campaign_DynamicSearchAdsSetting.ProtoReflect.Descriptor instead.
func (*Campaign_DynamicSearchAdsSetting) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v2_resources_campaign_proto_rawDescGZIP(), []int{0, 2}
}

func (x *Campaign_DynamicSearchAdsSetting) GetDomainName() *wrapperspb.StringValue {
	if x != nil {
		return x.DomainName
	}
	return nil
}

func (x *Campaign_DynamicSearchAdsSetting) GetLanguageCode() *wrapperspb.StringValue {
	if x != nil {
		return x.LanguageCode
	}
	return nil
}

func (x *Campaign_DynamicSearchAdsSetting) GetUseSuppliedUrlsOnly() *wrapperspb.BoolValue {
	if x != nil {
		return x.UseSuppliedUrlsOnly
	}
	return nil
}

func (x *Campaign_DynamicSearchAdsSetting) GetFeeds() []*wrapperspb.StringValue {
	if x != nil {
		return x.Feeds
	}
	return nil
}

// Selective optimization setting for this campaign, which includes a set of
// conversion actions to optimize this campaign towards.
type Campaign_SelectiveOptimization struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The selected set of conversion actions for optimizing this campaign.
	ConversionActions []*wrapperspb.StringValue `protobuf:"bytes,1,rep,name=conversion_actions,json=conversionActions,proto3" json:"conversion_actions,omitempty"`
}

func (x *Campaign_SelectiveOptimization) Reset() {
	*x = Campaign_SelectiveOptimization{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v2_resources_campaign_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Campaign_SelectiveOptimization) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Campaign_SelectiveOptimization) ProtoMessage() {}

func (x *Campaign_SelectiveOptimization) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v2_resources_campaign_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Campaign_SelectiveOptimization.ProtoReflect.Descriptor instead.
func (*Campaign_SelectiveOptimization) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v2_resources_campaign_proto_rawDescGZIP(), []int{0, 3}
}

func (x *Campaign_SelectiveOptimization) GetConversionActions() []*wrapperspb.StringValue {
	if x != nil {
		return x.ConversionActions
	}
	return nil
}

// The setting for Shopping campaigns. Defines the universe of products that
// can be advertised by the campaign, and how this campaign interacts with
// other Shopping campaigns.
type Campaign_ShoppingSetting struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. ID of the Merchant Center account.
	// This field is required for create operations. This field is immutable for
	// Shopping campaigns.
	MerchantId *wrapperspb.Int64Value `protobuf:"bytes,1,opt,name=merchant_id,json=merchantId,proto3" json:"merchant_id,omitempty"`
	// Immutable. Sales country of products to include in the campaign.
	// This field is required for Shopping campaigns. This field is immutable.
	// This field is optional for non-Shopping campaigns, but it must be equal
	// to 'ZZ' if set.
	SalesCountry *wrapperspb.StringValue `protobuf:"bytes,2,opt,name=sales_country,json=salesCountry,proto3" json:"sales_country,omitempty"`
	// Priority of the campaign. Campaigns with numerically higher priorities
	// take precedence over those with lower priorities.
	// This field is required for Shopping campaigns, with values between 0 and
	// 2, inclusive.
	// This field is optional for Smart Shopping campaigns, but must be equal to
	// 3 if set.
	CampaignPriority *wrapperspb.Int32Value `protobuf:"bytes,3,opt,name=campaign_priority,json=campaignPriority,proto3" json:"campaign_priority,omitempty"`
	// Whether to include local products.
	EnableLocal *wrapperspb.BoolValue `protobuf:"bytes,4,opt,name=enable_local,json=enableLocal,proto3" json:"enable_local,omitempty"`
}

func (x *Campaign_ShoppingSetting) Reset() {
	*x = Campaign_ShoppingSetting{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v2_resources_campaign_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Campaign_ShoppingSetting) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Campaign_ShoppingSetting) ProtoMessage() {}

func (x *Campaign_ShoppingSetting) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v2_resources_campaign_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Campaign_ShoppingSetting.ProtoReflect.Descriptor instead.
func (*Campaign_ShoppingSetting) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v2_resources_campaign_proto_rawDescGZIP(), []int{0, 4}
}

func (x *Campaign_ShoppingSetting) GetMerchantId() *wrapperspb.Int64Value {
	if x != nil {
		return x.MerchantId
	}
	return nil
}

func (x *Campaign_ShoppingSetting) GetSalesCountry() *wrapperspb.StringValue {
	if x != nil {
		return x.SalesCountry
	}
	return nil
}

func (x *Campaign_ShoppingSetting) GetCampaignPriority() *wrapperspb.Int32Value {
	if x != nil {
		return x.CampaignPriority
	}
	return nil
}

func (x *Campaign_ShoppingSetting) GetEnableLocal() *wrapperspb.BoolValue {
	if x != nil {
		return x.EnableLocal
	}
	return nil
}

// Campaign-level settings for tracking information.
type Campaign_TrackingSetting struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The url used for dynamic tracking.
	TrackingUrl *wrapperspb.StringValue `protobuf:"bytes,1,opt,name=tracking_url,json=trackingUrl,proto3" json:"tracking_url,omitempty"`
}

func (x *Campaign_TrackingSetting) Reset() {
	*x = Campaign_TrackingSetting{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v2_resources_campaign_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Campaign_TrackingSetting) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Campaign_TrackingSetting) ProtoMessage() {}

func (x *Campaign_TrackingSetting) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v2_resources_campaign_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Campaign_TrackingSetting.ProtoReflect.Descriptor instead.
func (*Campaign_TrackingSetting) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v2_resources_campaign_proto_rawDescGZIP(), []int{0, 5}
}

func (x *Campaign_TrackingSetting) GetTrackingUrl() *wrapperspb.StringValue {
	if x != nil {
		return x.TrackingUrl
	}
	return nil
}

// Represents a collection of settings related to ads geotargeting.
type Campaign_GeoTargetTypeSetting struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The setting used for positive geotargeting in this particular campaign.
	PositiveGeoTargetType enums.PositiveGeoTargetTypeEnum_PositiveGeoTargetType `protobuf:"varint,1,opt,name=positive_geo_target_type,json=positiveGeoTargetType,proto3,enum=google.ads.googleads.v2.enums.PositiveGeoTargetTypeEnum_PositiveGeoTargetType" json:"positive_geo_target_type,omitempty"`
	// The setting used for negative geotargeting in this particular campaign.
	NegativeGeoTargetType enums.NegativeGeoTargetTypeEnum_NegativeGeoTargetType `protobuf:"varint,2,opt,name=negative_geo_target_type,json=negativeGeoTargetType,proto3,enum=google.ads.googleads.v2.enums.NegativeGeoTargetTypeEnum_NegativeGeoTargetType" json:"negative_geo_target_type,omitempty"`
}

func (x *Campaign_GeoTargetTypeSetting) Reset() {
	*x = Campaign_GeoTargetTypeSetting{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v2_resources_campaign_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Campaign_GeoTargetTypeSetting) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Campaign_GeoTargetTypeSetting) ProtoMessage() {}

func (x *Campaign_GeoTargetTypeSetting) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v2_resources_campaign_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Campaign_GeoTargetTypeSetting.ProtoReflect.Descriptor instead.
func (*Campaign_GeoTargetTypeSetting) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v2_resources_campaign_proto_rawDescGZIP(), []int{0, 6}
}

func (x *Campaign_GeoTargetTypeSetting) GetPositiveGeoTargetType() enums.PositiveGeoTargetTypeEnum_PositiveGeoTargetType {
	if x != nil {
		return x.PositiveGeoTargetType
	}
	return enums.PositiveGeoTargetTypeEnum_UNSPECIFIED
}

func (x *Campaign_GeoTargetTypeSetting) GetNegativeGeoTargetType() enums.NegativeGeoTargetTypeEnum_NegativeGeoTargetType {
	if x != nil {
		return x.NegativeGeoTargetType
	}
	return enums.NegativeGeoTargetTypeEnum_UNSPECIFIED
}

// Campaign-level settings for App Campaigns.
type Campaign_AppCampaignSetting struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Represents the goal which the bidding strategy of this app campaign
	// should optimize towards.
	BiddingStrategyGoalType enums.AppCampaignBiddingStrategyGoalTypeEnum_AppCampaignBiddingStrategyGoalType `protobuf:"varint,1,opt,name=bidding_strategy_goal_type,json=biddingStrategyGoalType,proto3,enum=google.ads.googleads.v2.enums.AppCampaignBiddingStrategyGoalTypeEnum_AppCampaignBiddingStrategyGoalType" json:"bidding_strategy_goal_type,omitempty"`
	// Immutable. A string that uniquely identifies a mobile application.
	AppId *wrapperspb.StringValue `protobuf:"bytes,2,opt,name=app_id,json=appId,proto3" json:"app_id,omitempty"`
	// Immutable. The application store that distributes this specific app.
	AppStore enums.AppCampaignAppStoreEnum_AppCampaignAppStore `protobuf:"varint,3,opt,name=app_store,json=appStore,proto3,enum=google.ads.googleads.v2.enums.AppCampaignAppStoreEnum_AppCampaignAppStore" json:"app_store,omitempty"`
}

func (x *Campaign_AppCampaignSetting) Reset() {
	*x = Campaign_AppCampaignSetting{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v2_resources_campaign_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Campaign_AppCampaignSetting) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Campaign_AppCampaignSetting) ProtoMessage() {}

func (x *Campaign_AppCampaignSetting) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v2_resources_campaign_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Campaign_AppCampaignSetting.ProtoReflect.Descriptor instead.
func (*Campaign_AppCampaignSetting) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v2_resources_campaign_proto_rawDescGZIP(), []int{0, 7}
}

func (x *Campaign_AppCampaignSetting) GetBiddingStrategyGoalType() enums.AppCampaignBiddingStrategyGoalTypeEnum_AppCampaignBiddingStrategyGoalType {
	if x != nil {
		return x.BiddingStrategyGoalType
	}
	return enums.AppCampaignBiddingStrategyGoalTypeEnum_UNSPECIFIED
}

func (x *Campaign_AppCampaignSetting) GetAppId() *wrapperspb.StringValue {
	if x != nil {
		return x.AppId
	}
	return nil
}

func (x *Campaign_AppCampaignSetting) GetAppStore() enums.AppCampaignAppStoreEnum_AppCampaignAppStore {
	if x != nil {
		return x.AppStore
	}
	return enums.AppCampaignAppStoreEnum_UNSPECIFIED
}

// Describes how unbranded pharma ads will be displayed.
type Campaign_VanityPharma struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The display mode for vanity pharma URLs.
	VanityPharmaDisplayUrlMode enums.VanityPharmaDisplayUrlModeEnum_VanityPharmaDisplayUrlMode `protobuf:"varint,1,opt,name=vanity_pharma_display_url_mode,json=vanityPharmaDisplayUrlMode,proto3,enum=google.ads.googleads.v2.enums.VanityPharmaDisplayUrlModeEnum_VanityPharmaDisplayUrlMode" json:"vanity_pharma_display_url_mode,omitempty"`
	// The text that will be displayed in display URL of the text ad when
	// website description is the selected display mode for vanity pharma URLs.
	VanityPharmaText enums.VanityPharmaTextEnum_VanityPharmaText `protobuf:"varint,2,opt,name=vanity_pharma_text,json=vanityPharmaText,proto3,enum=google.ads.googleads.v2.enums.VanityPharmaTextEnum_VanityPharmaText" json:"vanity_pharma_text,omitempty"`
}

func (x *Campaign_VanityPharma) Reset() {
	*x = Campaign_VanityPharma{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v2_resources_campaign_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Campaign_VanityPharma) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Campaign_VanityPharma) ProtoMessage() {}

func (x *Campaign_VanityPharma) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v2_resources_campaign_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Campaign_VanityPharma.ProtoReflect.Descriptor instead.
func (*Campaign_VanityPharma) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v2_resources_campaign_proto_rawDescGZIP(), []int{0, 8}
}

func (x *Campaign_VanityPharma) GetVanityPharmaDisplayUrlMode() enums.VanityPharmaDisplayUrlModeEnum_VanityPharmaDisplayUrlMode {
	if x != nil {
		return x.VanityPharmaDisplayUrlMode
	}
	return enums.VanityPharmaDisplayUrlModeEnum_UNSPECIFIED
}

func (x *Campaign_VanityPharma) GetVanityPharmaText() enums.VanityPharmaTextEnum_VanityPharmaText {
	if x != nil {
		return x.VanityPharmaText
	}
	return enums.VanityPharmaTextEnum_UNSPECIFIED
}

var File_google_ads_googleads_v2_resources_campaign_proto protoreflect.FileDescriptor

var file_google_ads_googleads_v2_resources_campaign_proto_rawDesc = []byte{
	0x0a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x2f, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x21, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x1a, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64,
	0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x63,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2f, 0x62, 0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x32, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2f, 0x76, 0x32, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2f, 0x66, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x6e, 0x63, 0x79, 0x5f, 0x63, 0x61, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2f, 0x72,
	0x65, 0x61, 0x6c, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x62, 0x69, 0x64, 0x64, 0x69, 0x6e, 0x67,
	0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x36,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2f, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x42, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f,
	0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x61, 0x64, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67,
	0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x40, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2f, 0x76, 0x32, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x61, 0x64, 0x76, 0x65, 0x72, 0x74,
	0x69, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x73, 0x75,
	0x62, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x61, 0x64, 0x76, 0x65,
	0x72, 0x74, 0x69, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3a, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2f, 0x76, 0x32, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x61, 0x70, 0x70, 0x5f, 0x63, 0x61,
	0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x61, 0x70, 0x70, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x4b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f,
	0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x61, 0x70, 0x70, 0x5f, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69,
	0x67, 0x6e, 0x5f, 0x62, 0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x74, 0x72, 0x61, 0x74,
	0x65, 0x67, 0x79, 0x5f, 0x67, 0x6f, 0x61, 0x6c, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x39, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x65, 0x6e, 0x75,
	0x6d, 0x73, 0x2f, 0x62, 0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x74, 0x72, 0x61, 0x74,
	0x65, 0x67, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3c,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x62, 0x72,
	0x61, 0x6e, 0x64, 0x5f, 0x73, 0x61, 0x66, 0x65, 0x74, 0x79, 0x5f, 0x73, 0x75, 0x69, 0x74, 0x61,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x63, 0x61, 0x6d, 0x70,
	0x61, 0x69, 0x67, 0x6e, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3b, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2f, 0x76, 0x32, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69,
	0x67, 0x6e, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32,
	0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x6e, 0x65, 0x67, 0x61,
	0x74, 0x69, 0x76, 0x65, 0x5f, 0x67, 0x65, 0x6f, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x30, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2f, 0x76, 0x32, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e,
	0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x69, 0x76, 0x65, 0x5f, 0x67, 0x65, 0x6f, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x42, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2f, 0x76, 0x32, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x76, 0x61, 0x6e, 0x69, 0x74, 0x79,
	0x5f, 0x70, 0x68, 0x61, 0x72, 0x6d, 0x61, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f,
	0x75, 0x72, 0x6c, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x36,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x76, 0x61,
	0x6e, 0x69, 0x74, 0x79, 0x5f, 0x70, 0x68, 0x61, 0x72, 0x6d, 0x61, 0x5f, 0x74, 0x65, 0x78, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0x95, 0x36, 0x0a, 0x08, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x12, 0x4e, 0x0a,
	0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x05, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x52,
	0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x30, 0x0a,
	0x02, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36,
	0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x02, 0x69, 0x64, 0x12,
	0x30, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x58, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x65, 0x6e, 0x75, 0x6d,
	0x73, 0x2e, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x7a, 0x0a, 0x0e, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x15, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x65, 0x6e,
	0x75, 0x6d, 0x73, 0x2e, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x43, 0x61,
	0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x73, 0x65, 0x72, 0x76, 0x69, 0x6e,
	0x67, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x9f, 0x01, 0x0a, 0x1e, 0x61, 0x64, 0x5f, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x5a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73,
	0x2e, 0x41, 0x64, 0x53, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6d, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x45, 0x6e, 0x75, 0x6d,
	0x2e, 0x41, 0x64, 0x53, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6d, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x1b, 0x61, 0x64,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x8f, 0x01, 0x0a, 0x18, 0x61, 0x64,
	0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x50, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x41, 0x64, 0x76,
	0x65, 0x72, 0x74, 0x69, 0x73, 0x69, 0x6e, 0x67, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x54,
	0x79, 0x70, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73,
	0x69, 0x6e, 0x67, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x05, 0x52, 0x16, 0x61, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x69, 0x6e, 0x67,
	0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x12, 0x9c, 0x01, 0x0a, 0x1c,
	0x61, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x5f, 0x73, 0x75, 0x62, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0a, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x56, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x65, 0x6e, 0x75,
	0x6d, 0x73, 0x2e, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x69, 0x6e, 0x67, 0x43, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x53, 0x75, 0x62, 0x54, 0x79, 0x70, 0x65, 0x45, 0x6e, 0x75, 0x6d,
	0x2e, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x69, 0x6e, 0x67, 0x43, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x53, 0x75, 0x62, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52,
	0x19, 0x61, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x69, 0x6e, 0x67, 0x43, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x53, 0x75, 0x62, 0x54, 0x79, 0x70, 0x65, 0x12, 0x50, 0x0a, 0x15, 0x74, 0x72,
	0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x75, 0x72, 0x6c, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c,
	0x61, 0x74, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69,
	0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x13, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e,
	0x67, 0x55, 0x72, 0x6c, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x63, 0x0a, 0x15,
	0x75, 0x72, 0x6c, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x52, 0x13, 0x75, 0x72,
	0x6c, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x73, 0x12, 0x71, 0x0a, 0x19, 0x72, 0x65, 0x61, 0x6c, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x62,
	0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x27,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x63,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x61, 0x6c, 0x54, 0x69, 0x6d, 0x65, 0x42, 0x69,
	0x64, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x16, 0x72, 0x65,
	0x61, 0x6c, 0x54, 0x69, 0x6d, 0x65, 0x42, 0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x12, 0x66, 0x0a, 0x10, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f,
	0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x2e, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x2e, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x0f, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x66, 0x0a, 0x0d,
	0x68, 0x6f, 0x74, 0x65, 0x6c, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x20, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e,
	0x2e, 0x48, 0x6f, 0x74, 0x65, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66,
	0x6f, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x0c, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x12, 0x80, 0x01, 0x0a, 0x1a, 0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63,
	0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x61, 0x64, 0x73, 0x5f, 0x73, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x18, 0x21, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x43, 0x61,
	0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x41, 0x64, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x17,
	0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x64, 0x73,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x66, 0x0a, 0x10, 0x73, 0x68, 0x6f, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x24, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x2e, 0x53,
	0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x0f,
	0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x12,
	0x5d, 0x0a, 0x11, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x18, 0x2b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2e, 0x76, 0x32, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x54, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x10, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x77,
	0x0a, 0x17, 0x67, 0x65, 0x6f, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x2f, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x2e, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x2e, 0x47, 0x65, 0x6f,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x52, 0x14, 0x67, 0x65, 0x6f, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x70, 0x0a, 0x14, 0x61, 0x70, 0x70, 0x5f, 0x63,
	0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x18,
	0x33, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69,
	0x67, 0x6e, 0x2e, 0x41, 0x70, 0x70, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x12, 0x61, 0x70, 0x70, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69,
	0x67, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x64, 0x0a, 0x06, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x18, 0x35, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69,
	0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x2e, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x28, 0x0a,
	0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69,
	0x67, 0x6e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12,
	0x7e, 0x0a, 0x0f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e,
	0x76, 0x32, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67,
	0x6e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x45,
	0x6e, 0x75, 0x6d, 0x2e, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x45, 0x78, 0x70, 0x65,
	0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0e, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x6c, 0x0a, 0x0d, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e,
	0x18, 0x1c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x42, 0x29, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x52,
	0x0c, 0x62, 0x61, 0x73, 0x65, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x12, 0x73, 0x0a,
	0x0f, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x42, 0x2c, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x42, 0x75, 0x64, 0x67,
	0x65, 0x74, 0x52, 0x0e, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x42, 0x75, 0x64, 0x67,
	0x65, 0x74, 0x12, 0x83, 0x01, 0x0a, 0x15, 0x62, 0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x73,
	0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x16, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x65, 0x6e, 0x75,
	0x6d, 0x73, 0x2e, 0x42, 0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65,
	0x67, 0x79, 0x54, 0x79, 0x70, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x42, 0x69, 0x64, 0x64, 0x69,
	0x6e, 0x67, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x13, 0x62, 0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x72, 0x61,
	0x74, 0x65, 0x67, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x3b, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x44, 0x61, 0x74, 0x65, 0x12, 0x37, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x61, 0x74,
	0x65, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x44, 0x61, 0x74, 0x65, 0x12, 0x46,
	0x0a, 0x10, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x75, 0x72, 0x6c, 0x5f, 0x73, 0x75, 0x66, 0x66,
	0x69, 0x78, 0x18, 0x26, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e,
	0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0e, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x55, 0x72, 0x6c,
	0x53, 0x75, 0x66, 0x66, 0x69, 0x78, 0x12, 0x58, 0x0a, 0x0e, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x6e, 0x63, 0x79, 0x5f, 0x63, 0x61, 0x70, 0x73, 0x18, 0x28, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e,
	0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x43, 0x61, 0x70, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x52, 0x0d, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x43, 0x61, 0x70, 0x73,
	0x12, 0x9a, 0x01, 0x0a, 0x1e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x62, 0x72, 0x61, 0x6e, 0x64,
	0x5f, 0x73, 0x61, 0x66, 0x65, 0x74, 0x79, 0x5f, 0x73, 0x75, 0x69, 0x74, 0x61, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x79, 0x18, 0x2a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2e, 0x76, 0x32, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x42, 0x72, 0x61, 0x6e, 0x64, 0x53,
	0x61, 0x66, 0x65, 0x74, 0x79, 0x53, 0x75, 0x69, 0x74, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79,
	0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x42, 0x72, 0x61, 0x6e, 0x64, 0x53, 0x61, 0x66, 0x65, 0x74, 0x79,
	0x53, 0x75, 0x69, 0x74, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x1b, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x42, 0x72, 0x61, 0x6e, 0x64, 0x53, 0x61, 0x66, 0x65,
	0x74, 0x79, 0x53, 0x75, 0x69, 0x74, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x5d, 0x0a,
	0x0d, 0x76, 0x61, 0x6e, 0x69, 0x74, 0x79, 0x5f, 0x70, 0x68, 0x61, 0x72, 0x6d, 0x61, 0x18, 0x2c,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67,
	0x6e, 0x2e, 0x56, 0x61, 0x6e, 0x69, 0x74, 0x79, 0x50, 0x68, 0x61, 0x72, 0x6d, 0x61, 0x52, 0x0c,
	0x76, 0x61, 0x6e, 0x69, 0x74, 0x79, 0x50, 0x68, 0x61, 0x72, 0x6d, 0x61, 0x12, 0x78, 0x0a, 0x16,
	0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x2d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2e, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x2e, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74,
	0x69, 0x76, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x15, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6d, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x6b, 0x0a, 0x10, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x69,
	0x6e, 0x67, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x2e, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x2e, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x2e, 0x54, 0x72,
	0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0f, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x12, 0x5d, 0x0a, 0x0c, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6d,
	0x6f, 0x64, 0x65, 0x18, 0x34, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2e, 0x76, 0x32, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x50, 0x61, 0x79, 0x6d, 0x65, 0x6e,
	0x74, 0x4d, 0x6f, 0x64, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x50, 0x61, 0x79, 0x6d, 0x65, 0x6e,
	0x74, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x0b, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x6f,
	0x64, 0x65, 0x12, 0x78, 0x0a, 0x10, 0x62, 0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x74,
	0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x2d, 0xfa, 0x41, 0x2a, 0x0a,
	0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x69, 0x64, 0x64, 0x69, 0x6e,
	0x67, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x48, 0x00, 0x52, 0x0f, 0x62, 0x69, 0x64,
	0x64, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x12, 0x4c, 0x0a, 0x0a,
	0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x31, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0a,
	0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x4a, 0x0a, 0x0a, 0x6d, 0x61,
	0x6e, 0x75, 0x61, 0x6c, 0x5f, 0x63, 0x70, 0x63, 0x18, 0x18, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e,
	0x4d, 0x61, 0x6e, 0x75, 0x61, 0x6c, 0x43, 0x70, 0x63, 0x48, 0x00, 0x52, 0x09, 0x6d, 0x61, 0x6e,
	0x75, 0x61, 0x6c, 0x43, 0x70, 0x63, 0x12, 0x4a, 0x0a, 0x0a, 0x6d, 0x61, 0x6e, 0x75, 0x61, 0x6c,
	0x5f, 0x63, 0x70, 0x6d, 0x18, 0x19, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2e, 0x76, 0x32, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x4d, 0x61, 0x6e, 0x75,
	0x61, 0x6c, 0x43, 0x70, 0x6d, 0x48, 0x00, 0x52, 0x09, 0x6d, 0x61, 0x6e, 0x75, 0x61, 0x6c, 0x43,
	0x70, 0x6d, 0x12, 0x4f, 0x0a, 0x0a, 0x6d, 0x61, 0x6e, 0x75, 0x61, 0x6c, 0x5f, 0x63, 0x70, 0x76,
	0x18, 0x25, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x4d, 0x61, 0x6e, 0x75, 0x61, 0x6c, 0x43, 0x70,
	0x76, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x09, 0x6d, 0x61, 0x6e, 0x75, 0x61, 0x6c,
	0x43, 0x70, 0x76, 0x12, 0x68, 0x0a, 0x14, 0x6d, 0x61, 0x78, 0x69, 0x6d, 0x69, 0x7a, 0x65, 0x5f,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x1e, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x63, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x2e, 0x4d, 0x61, 0x78, 0x69, 0x6d, 0x69, 0x7a, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x48, 0x00, 0x52, 0x13, 0x6d, 0x61, 0x78, 0x69, 0x6d, 0x69,
	0x7a, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x75, 0x0a,
	0x19, 0x6d, 0x61, 0x78, 0x69, 0x6d, 0x69, 0x7a, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x1f, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x2e, 0x4d, 0x61, 0x78, 0x69, 0x6d, 0x69, 0x7a, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x48, 0x00, 0x52, 0x17, 0x6d, 0x61, 0x78,
	0x69, 0x6d, 0x69, 0x7a, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x12, 0x4a, 0x0a, 0x0a, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x63,
	0x70, 0x61, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e,
	0x76, 0x32, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x43, 0x70, 0x61, 0x48, 0x00, 0x52, 0x09, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x43, 0x70, 0x61,
	0x12, 0x6f, 0x0a, 0x17, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x18, 0x30, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x63, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x49, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x53, 0x68, 0x61, 0x72, 0x65, 0x48, 0x00, 0x52, 0x15, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x49, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x68, 0x61, 0x72,
	0x65, 0x12, 0x4d, 0x0a, 0x0b, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x72, 0x6f, 0x61, 0x73,
	0x18, 0x1d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x6f,
	0x61, 0x73, 0x48, 0x00, 0x52, 0x0a, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x6f, 0x61, 0x73,
	0x12, 0x50, 0x0a, 0x0c, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x73, 0x70, 0x65, 0x6e, 0x64,
	0x18, 0x1b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x70,
	0x65, 0x6e, 0x64, 0x48, 0x00, 0x52, 0x0b, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x70, 0x65,
	0x6e, 0x64, 0x12, 0x4d, 0x0a, 0x0b, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x70,
	0x63, 0x18, 0x22, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76,
	0x32, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74,
	0x43, 0x70, 0x63, 0x48, 0x00, 0x52, 0x0a, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x43, 0x70,
	0x63, 0x12, 0x4a, 0x0a, 0x0a, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x63, 0x70, 0x6d, 0x18,
	0x29, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x43, 0x70, 0x6d,
	0x48, 0x00, 0x52, 0x09, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x43, 0x70, 0x6d, 0x1a, 0xe0, 0x02,
	0x0a, 0x0f, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x12, 0x4c, 0x0a, 0x14, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x12, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x12,
	0x4e, 0x0a, 0x15, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x13, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12,
	0x50, 0x0a, 0x16, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x14, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x12, 0x5d, 0x0a, 0x1d, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x74,
	0x6e, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x1a, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x61, 0x72, 0x74,
	0x6e, 0x65, 0x72, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x1a, 0x5c, 0x0a, 0x10, 0x48, 0x6f, 0x74, 0x65, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x48, 0x0a, 0x0f, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x5f, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52,
	0x0d, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x49, 0x64, 0x1a, 0xc7,
	0x02, 0x0a, 0x17, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x41, 0x64, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x3d, 0x0a, 0x0b, 0x64, 0x6f,
	0x6d, 0x61, 0x69, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x64,
	0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x41, 0x0a, 0x0d, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0c,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x4f, 0x0a, 0x16,
	0x75, 0x73, 0x65, 0x5f, 0x73, 0x75, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x5f, 0x75, 0x72, 0x6c,
	0x73, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42,
	0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x13, 0x75, 0x73, 0x65, 0x53, 0x75, 0x70,
	0x70, 0x6c, 0x69, 0x65, 0x64, 0x55, 0x72, 0x6c, 0x73, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x59, 0x0a,
	0x05, 0x66, 0x65, 0x65, 0x64, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x25, 0xe0, 0x41, 0x03, 0xfa,
	0x41, 0x1f, 0x0a, 0x1d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x65, 0x65,
	0x64, 0x52, 0x05, 0x66, 0x65, 0x65, 0x64, 0x73, 0x1a, 0x94, 0x01, 0x0a, 0x15, 0x53, 0x65, 0x6c,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x7b, 0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x2e, 0xfa, 0x41,
	0x2b, 0x0a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a,
	0xa5, 0x02, 0x0a, 0x0f, 0x53, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x12, 0x41, 0x0a, 0x0b, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x0a, 0x6d, 0x65, 0x72, 0x63,
	0x68, 0x61, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x46, 0x0a, 0x0d, 0x73, 0x61, 0x6c, 0x65, 0x73, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x05,
	0x52, 0x0c, 0x73, 0x61, 0x6c, 0x65, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x48,
	0x0a, 0x11, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x70, 0x72, 0x69, 0x6f, 0x72,
	0x69, 0x74, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x33,
	0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x10, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e,
	0x50, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12, 0x3d, 0x0a, 0x0c, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0b, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x1a, 0x57, 0x0a, 0x0f, 0x54, 0x72, 0x61, 0x63, 0x6b,
	0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x44, 0x0a, 0x0c, 0x74, 0x72,
	0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0b, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x55, 0x72, 0x6c,
	0x1a, 0xaa, 0x02, 0x0a, 0x14, 0x47, 0x65, 0x6f, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x54, 0x79,
	0x70, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x87, 0x01, 0x0a, 0x18, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x67, 0x65, 0x6f, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x50, 0x6f, 0x73,
	0x69, 0x74, 0x69, 0x76, 0x65, 0x47, 0x65, 0x6f, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x54, 0x79,
	0x70, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x50, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x47,
	0x65, 0x6f, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x15, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x47, 0x65, 0x6f, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x87, 0x01, 0x0a, 0x18, 0x6e, 0x65, 0x67, 0x61, 0x74, 0x69, 0x76, 0x65,
	0x5f, 0x67, 0x65, 0x6f, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32,
	0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x4e, 0x65, 0x67, 0x61, 0x74, 0x69, 0x76, 0x65, 0x47,
	0x65, 0x6f, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x45, 0x6e, 0x75, 0x6d,
	0x2e, 0x4e, 0x65, 0x67, 0x61, 0x74, 0x69, 0x76, 0x65, 0x47, 0x65, 0x6f, 0x54, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x15, 0x6e, 0x65, 0x67, 0x61, 0x74, 0x69, 0x76, 0x65,
	0x47, 0x65, 0x6f, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x1a, 0xe4, 0x02,
	0x0a, 0x12, 0x41, 0x70, 0x70, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x12, 0xa5, 0x01, 0x0a, 0x1a, 0x62, 0x69, 0x64, 0x64, 0x69, 0x6e, 0x67,
	0x5f, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x5f, 0x67, 0x6f, 0x61, 0x6c, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2e, 0x76, 0x32, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x41, 0x70, 0x70, 0x43, 0x61, 0x6d,
	0x70, 0x61, 0x69, 0x67, 0x6e, 0x42, 0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x72, 0x61,
	0x74, 0x65, 0x67, 0x79, 0x47, 0x6f, 0x61, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x45, 0x6e, 0x75, 0x6d,
	0x2e, 0x41, 0x70, 0x70, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x42, 0x69, 0x64, 0x64,
	0x69, 0x6e, 0x67, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x47, 0x6f, 0x61, 0x6c, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x17, 0x62, 0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x72, 0x61,
	0x74, 0x65, 0x67, 0x79, 0x47, 0x6f, 0x61, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x12, 0x38, 0x0a, 0x06,
	0x61, 0x70, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52,
	0x05, 0x61, 0x70, 0x70, 0x49, 0x64, 0x12, 0x6c, 0x0a, 0x09, 0x61, 0x70, 0x70, 0x5f, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2e, 0x76, 0x32, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x41, 0x70, 0x70, 0x43, 0x61, 0x6d,
	0x70, 0x61, 0x69, 0x67, 0x6e, 0x41, 0x70, 0x70, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x45, 0x6e, 0x75,
	0x6d, 0x2e, 0x41, 0x70, 0x70, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x41, 0x70, 0x70,
	0x53, 0x74, 0x6f, 0x72, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x08, 0x61, 0x70, 0x70, 0x53,
	0x74, 0x6f, 0x72, 0x65, 0x1a, 0xa1, 0x02, 0x0a, 0x0c, 0x56, 0x61, 0x6e, 0x69, 0x74, 0x79, 0x50,
	0x68, 0x61, 0x72, 0x6d, 0x61, 0x12, 0x9c, 0x01, 0x0a, 0x1e, 0x76, 0x61, 0x6e, 0x69, 0x74, 0x79,
	0x5f, 0x70, 0x68, 0x61, 0x72, 0x6d, 0x61, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f,
	0x75, 0x72, 0x6c, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x58,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x56,
	0x61, 0x6e, 0x69, 0x74, 0x79, 0x50, 0x68, 0x61, 0x72, 0x6d, 0x61, 0x44, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x55, 0x72, 0x6c, 0x4d, 0x6f, 0x64, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x56, 0x61,
	0x6e, 0x69, 0x74, 0x79, 0x50, 0x68, 0x61, 0x72, 0x6d, 0x61, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x55, 0x72, 0x6c, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x1a, 0x76, 0x61, 0x6e, 0x69, 0x74, 0x79,
	0x50, 0x68, 0x61, 0x72, 0x6d, 0x61, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x55, 0x72, 0x6c,
	0x4d, 0x6f, 0x64, 0x65, 0x12, 0x72, 0x0a, 0x12, 0x76, 0x61, 0x6e, 0x69, 0x74, 0x79, 0x5f, 0x70,
	0x68, 0x61, 0x72, 0x6d, 0x61, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73,
	0x2e, 0x56, 0x61, 0x6e, 0x69, 0x74, 0x79, 0x50, 0x68, 0x61, 0x72, 0x6d, 0x61, 0x54, 0x65, 0x78,
	0x74, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x56, 0x61, 0x6e, 0x69, 0x74, 0x79, 0x50, 0x68, 0x61, 0x72,
	0x6d, 0x61, 0x54, 0x65, 0x78, 0x74, 0x52, 0x10, 0x76, 0x61, 0x6e, 0x69, 0x74, 0x79, 0x50, 0x68,
	0x61, 0x72, 0x6d, 0x61, 0x54, 0x65, 0x78, 0x74, 0x3a, 0x51, 0xea, 0x41, 0x4e, 0x0a, 0x21, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e,
	0x12, 0x29, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x65, 0x72, 0x7d, 0x2f, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x73,
	0x2f, 0x7b, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x7d, 0x42, 0x1b, 0x0a, 0x19, 0x63,
	0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x62, 0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x5f,
	0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x42, 0xfa, 0x01, 0x0a, 0x25, 0x63, 0x6f, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x42, 0x0d, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x50, 0x01, 0x5a, 0x4a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61,
	0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x3b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0xa2,
	0x02, 0x03, 0x47, 0x41, 0x41, 0xaa, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x41,
	0x64, 0x73, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x2e, 0x56, 0x32, 0x2e,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0xca, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x5c, 0x41, 0x64, 0x73, 0x5c, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73,
	0x5c, 0x56, 0x32, 0x5c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0xea, 0x02, 0x25,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x41, 0x64, 0x73, 0x3a, 0x3a, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x3a, 0x3a, 0x56, 0x32, 0x3a, 0x3a, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_ads_googleads_v2_resources_campaign_proto_rawDescOnce sync.Once
	file_google_ads_googleads_v2_resources_campaign_proto_rawDescData = file_google_ads_googleads_v2_resources_campaign_proto_rawDesc
)

func file_google_ads_googleads_v2_resources_campaign_proto_rawDescGZIP() []byte {
	file_google_ads_googleads_v2_resources_campaign_proto_rawDescOnce.Do(func() {
		file_google_ads_googleads_v2_resources_campaign_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_ads_googleads_v2_resources_campaign_proto_rawDescData)
	})
	return file_google_ads_googleads_v2_resources_campaign_proto_rawDescData
}

var file_google_ads_googleads_v2_resources_campaign_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_google_ads_googleads_v2_resources_campaign_proto_goTypes = []interface{}{
	(*Campaign)(nil),                                                                     // 0: google.ads.googleads.v2.resources.Campaign
	(*Campaign_NetworkSettings)(nil),                                                     // 1: google.ads.googleads.v2.resources.Campaign.NetworkSettings
	(*Campaign_HotelSettingInfo)(nil),                                                    // 2: google.ads.googleads.v2.resources.Campaign.HotelSettingInfo
	(*Campaign_DynamicSearchAdsSetting)(nil),                                             // 3: google.ads.googleads.v2.resources.Campaign.DynamicSearchAdsSetting
	(*Campaign_SelectiveOptimization)(nil),                                               // 4: google.ads.googleads.v2.resources.Campaign.SelectiveOptimization
	(*Campaign_ShoppingSetting)(nil),                                                     // 5: google.ads.googleads.v2.resources.Campaign.ShoppingSetting
	(*Campaign_TrackingSetting)(nil),                                                     // 6: google.ads.googleads.v2.resources.Campaign.TrackingSetting
	(*Campaign_GeoTargetTypeSetting)(nil),                                                // 7: google.ads.googleads.v2.resources.Campaign.GeoTargetTypeSetting
	(*Campaign_AppCampaignSetting)(nil),                                                  // 8: google.ads.googleads.v2.resources.Campaign.AppCampaignSetting
	(*Campaign_VanityPharma)(nil),                                                        // 9: google.ads.googleads.v2.resources.Campaign.VanityPharma
	(*wrapperspb.Int64Value)(nil),                                                        // 10: google.protobuf.Int64Value
	(*wrapperspb.StringValue)(nil),                                                       // 11: google.protobuf.StringValue
	(enums.CampaignStatusEnum_CampaignStatus)(0),                                         // 12: google.ads.googleads.v2.enums.CampaignStatusEnum.CampaignStatus
	(enums.CampaignServingStatusEnum_CampaignServingStatus)(0),                           // 13: google.ads.googleads.v2.enums.CampaignServingStatusEnum.CampaignServingStatus
	(enums.AdServingOptimizationStatusEnum_AdServingOptimizationStatus)(0),               // 14: google.ads.googleads.v2.enums.AdServingOptimizationStatusEnum.AdServingOptimizationStatus
	(enums.AdvertisingChannelTypeEnum_AdvertisingChannelType)(0),                         // 15: google.ads.googleads.v2.enums.AdvertisingChannelTypeEnum.AdvertisingChannelType
	(enums.AdvertisingChannelSubTypeEnum_AdvertisingChannelSubType)(0),                   // 16: google.ads.googleads.v2.enums.AdvertisingChannelSubTypeEnum.AdvertisingChannelSubType
	(*common.CustomParameter)(nil),                                                       // 17: google.ads.googleads.v2.common.CustomParameter
	(*common.RealTimeBiddingSetting)(nil),                                                // 18: google.ads.googleads.v2.common.RealTimeBiddingSetting
	(*common.TargetingSetting)(nil),                                                      // 19: google.ads.googleads.v2.common.TargetingSetting
	(enums.CampaignExperimentTypeEnum_CampaignExperimentType)(0),                         // 20: google.ads.googleads.v2.enums.CampaignExperimentTypeEnum.CampaignExperimentType
	(enums.BiddingStrategyTypeEnum_BiddingStrategyType)(0),                               // 21: google.ads.googleads.v2.enums.BiddingStrategyTypeEnum.BiddingStrategyType
	(*common.FrequencyCapEntry)(nil),                                                     // 22: google.ads.googleads.v2.common.FrequencyCapEntry
	(enums.BrandSafetySuitabilityEnum_BrandSafetySuitability)(0),                         // 23: google.ads.googleads.v2.enums.BrandSafetySuitabilityEnum.BrandSafetySuitability
	(enums.PaymentModeEnum_PaymentMode)(0),                                               // 24: google.ads.googleads.v2.enums.PaymentModeEnum.PaymentMode
	(*common.Commission)(nil),                                                            // 25: google.ads.googleads.v2.common.Commission
	(*common.ManualCpc)(nil),                                                             // 26: google.ads.googleads.v2.common.ManualCpc
	(*common.ManualCpm)(nil),                                                             // 27: google.ads.googleads.v2.common.ManualCpm
	(*common.ManualCpv)(nil),                                                             // 28: google.ads.googleads.v2.common.ManualCpv
	(*common.MaximizeConversions)(nil),                                                   // 29: google.ads.googleads.v2.common.MaximizeConversions
	(*common.MaximizeConversionValue)(nil),                                               // 30: google.ads.googleads.v2.common.MaximizeConversionValue
	(*common.TargetCpa)(nil),                                                             // 31: google.ads.googleads.v2.common.TargetCpa
	(*common.TargetImpressionShare)(nil),                                                 // 32: google.ads.googleads.v2.common.TargetImpressionShare
	(*common.TargetRoas)(nil),                                                            // 33: google.ads.googleads.v2.common.TargetRoas
	(*common.TargetSpend)(nil),                                                           // 34: google.ads.googleads.v2.common.TargetSpend
	(*common.PercentCpc)(nil),                                                            // 35: google.ads.googleads.v2.common.PercentCpc
	(*common.TargetCpm)(nil),                                                             // 36: google.ads.googleads.v2.common.TargetCpm
	(*wrapperspb.BoolValue)(nil),                                                         // 37: google.protobuf.BoolValue
	(*wrapperspb.Int32Value)(nil),                                                        // 38: google.protobuf.Int32Value
	(enums.PositiveGeoTargetTypeEnum_PositiveGeoTargetType)(0),                           // 39: google.ads.googleads.v2.enums.PositiveGeoTargetTypeEnum.PositiveGeoTargetType
	(enums.NegativeGeoTargetTypeEnum_NegativeGeoTargetType)(0),                           // 40: google.ads.googleads.v2.enums.NegativeGeoTargetTypeEnum.NegativeGeoTargetType
	(enums.AppCampaignBiddingStrategyGoalTypeEnum_AppCampaignBiddingStrategyGoalType)(0), // 41: google.ads.googleads.v2.enums.AppCampaignBiddingStrategyGoalTypeEnum.AppCampaignBiddingStrategyGoalType
	(enums.AppCampaignAppStoreEnum_AppCampaignAppStore)(0),                               // 42: google.ads.googleads.v2.enums.AppCampaignAppStoreEnum.AppCampaignAppStore
	(enums.VanityPharmaDisplayUrlModeEnum_VanityPharmaDisplayUrlMode)(0),                 // 43: google.ads.googleads.v2.enums.VanityPharmaDisplayUrlModeEnum.VanityPharmaDisplayUrlMode
	(enums.VanityPharmaTextEnum_VanityPharmaText)(0),                                     // 44: google.ads.googleads.v2.enums.VanityPharmaTextEnum.VanityPharmaText
}
var file_google_ads_googleads_v2_resources_campaign_proto_depIdxs = []int32{
	10, // 0: google.ads.googleads.v2.resources.Campaign.id:type_name -> google.protobuf.Int64Value
	11, // 1: google.ads.googleads.v2.resources.Campaign.name:type_name -> google.protobuf.StringValue
	12, // 2: google.ads.googleads.v2.resources.Campaign.status:type_name -> google.ads.googleads.v2.enums.CampaignStatusEnum.CampaignStatus
	13, // 3: google.ads.googleads.v2.resources.Campaign.serving_status:type_name -> google.ads.googleads.v2.enums.CampaignServingStatusEnum.CampaignServingStatus
	14, // 4: google.ads.googleads.v2.resources.Campaign.ad_serving_optimization_status:type_name -> google.ads.googleads.v2.enums.AdServingOptimizationStatusEnum.AdServingOptimizationStatus
	15, // 5: google.ads.googleads.v2.resources.Campaign.advertising_channel_type:type_name -> google.ads.googleads.v2.enums.AdvertisingChannelTypeEnum.AdvertisingChannelType
	16, // 6: google.ads.googleads.v2.resources.Campaign.advertising_channel_sub_type:type_name -> google.ads.googleads.v2.enums.AdvertisingChannelSubTypeEnum.AdvertisingChannelSubType
	11, // 7: google.ads.googleads.v2.resources.Campaign.tracking_url_template:type_name -> google.protobuf.StringValue
	17, // 8: google.ads.googleads.v2.resources.Campaign.url_custom_parameters:type_name -> google.ads.googleads.v2.common.CustomParameter
	18, // 9: google.ads.googleads.v2.resources.Campaign.real_time_bidding_setting:type_name -> google.ads.googleads.v2.common.RealTimeBiddingSetting
	1,  // 10: google.ads.googleads.v2.resources.Campaign.network_settings:type_name -> google.ads.googleads.v2.resources.Campaign.NetworkSettings
	2,  // 11: google.ads.googleads.v2.resources.Campaign.hotel_setting:type_name -> google.ads.googleads.v2.resources.Campaign.HotelSettingInfo
	3,  // 12: google.ads.googleads.v2.resources.Campaign.dynamic_search_ads_setting:type_name -> google.ads.googleads.v2.resources.Campaign.DynamicSearchAdsSetting
	5,  // 13: google.ads.googleads.v2.resources.Campaign.shopping_setting:type_name -> google.ads.googleads.v2.resources.Campaign.ShoppingSetting
	19, // 14: google.ads.googleads.v2.resources.Campaign.targeting_setting:type_name -> google.ads.googleads.v2.common.TargetingSetting
	7,  // 15: google.ads.googleads.v2.resources.Campaign.geo_target_type_setting:type_name -> google.ads.googleads.v2.resources.Campaign.GeoTargetTypeSetting
	8,  // 16: google.ads.googleads.v2.resources.Campaign.app_campaign_setting:type_name -> google.ads.googleads.v2.resources.Campaign.AppCampaignSetting
	11, // 17: google.ads.googleads.v2.resources.Campaign.labels:type_name -> google.protobuf.StringValue
	20, // 18: google.ads.googleads.v2.resources.Campaign.experiment_type:type_name -> google.ads.googleads.v2.enums.CampaignExperimentTypeEnum.CampaignExperimentType
	11, // 19: google.ads.googleads.v2.resources.Campaign.base_campaign:type_name -> google.protobuf.StringValue
	11, // 20: google.ads.googleads.v2.resources.Campaign.campaign_budget:type_name -> google.protobuf.StringValue
	21, // 21: google.ads.googleads.v2.resources.Campaign.bidding_strategy_type:type_name -> google.ads.googleads.v2.enums.BiddingStrategyTypeEnum.BiddingStrategyType
	11, // 22: google.ads.googleads.v2.resources.Campaign.start_date:type_name -> google.protobuf.StringValue
	11, // 23: google.ads.googleads.v2.resources.Campaign.end_date:type_name -> google.protobuf.StringValue
	11, // 24: google.ads.googleads.v2.resources.Campaign.final_url_suffix:type_name -> google.protobuf.StringValue
	22, // 25: google.ads.googleads.v2.resources.Campaign.frequency_caps:type_name -> google.ads.googleads.v2.common.FrequencyCapEntry
	23, // 26: google.ads.googleads.v2.resources.Campaign.video_brand_safety_suitability:type_name -> google.ads.googleads.v2.enums.BrandSafetySuitabilityEnum.BrandSafetySuitability
	9,  // 27: google.ads.googleads.v2.resources.Campaign.vanity_pharma:type_name -> google.ads.googleads.v2.resources.Campaign.VanityPharma
	4,  // 28: google.ads.googleads.v2.resources.Campaign.selective_optimization:type_name -> google.ads.googleads.v2.resources.Campaign.SelectiveOptimization
	6,  // 29: google.ads.googleads.v2.resources.Campaign.tracking_setting:type_name -> google.ads.googleads.v2.resources.Campaign.TrackingSetting
	24, // 30: google.ads.googleads.v2.resources.Campaign.payment_mode:type_name -> google.ads.googleads.v2.enums.PaymentModeEnum.PaymentMode
	11, // 31: google.ads.googleads.v2.resources.Campaign.bidding_strategy:type_name -> google.protobuf.StringValue
	25, // 32: google.ads.googleads.v2.resources.Campaign.commission:type_name -> google.ads.googleads.v2.common.Commission
	26, // 33: google.ads.googleads.v2.resources.Campaign.manual_cpc:type_name -> google.ads.googleads.v2.common.ManualCpc
	27, // 34: google.ads.googleads.v2.resources.Campaign.manual_cpm:type_name -> google.ads.googleads.v2.common.ManualCpm
	28, // 35: google.ads.googleads.v2.resources.Campaign.manual_cpv:type_name -> google.ads.googleads.v2.common.ManualCpv
	29, // 36: google.ads.googleads.v2.resources.Campaign.maximize_conversions:type_name -> google.ads.googleads.v2.common.MaximizeConversions
	30, // 37: google.ads.googleads.v2.resources.Campaign.maximize_conversion_value:type_name -> google.ads.googleads.v2.common.MaximizeConversionValue
	31, // 38: google.ads.googleads.v2.resources.Campaign.target_cpa:type_name -> google.ads.googleads.v2.common.TargetCpa
	32, // 39: google.ads.googleads.v2.resources.Campaign.target_impression_share:type_name -> google.ads.googleads.v2.common.TargetImpressionShare
	33, // 40: google.ads.googleads.v2.resources.Campaign.target_roas:type_name -> google.ads.googleads.v2.common.TargetRoas
	34, // 41: google.ads.googleads.v2.resources.Campaign.target_spend:type_name -> google.ads.googleads.v2.common.TargetSpend
	35, // 42: google.ads.googleads.v2.resources.Campaign.percent_cpc:type_name -> google.ads.googleads.v2.common.PercentCpc
	36, // 43: google.ads.googleads.v2.resources.Campaign.target_cpm:type_name -> google.ads.googleads.v2.common.TargetCpm
	37, // 44: google.ads.googleads.v2.resources.Campaign.NetworkSettings.target_google_search:type_name -> google.protobuf.BoolValue
	37, // 45: google.ads.googleads.v2.resources.Campaign.NetworkSettings.target_search_network:type_name -> google.protobuf.BoolValue
	37, // 46: google.ads.googleads.v2.resources.Campaign.NetworkSettings.target_content_network:type_name -> google.protobuf.BoolValue
	37, // 47: google.ads.googleads.v2.resources.Campaign.NetworkSettings.target_partner_search_network:type_name -> google.protobuf.BoolValue
	10, // 48: google.ads.googleads.v2.resources.Campaign.HotelSettingInfo.hotel_center_id:type_name -> google.protobuf.Int64Value
	11, // 49: google.ads.googleads.v2.resources.Campaign.DynamicSearchAdsSetting.domain_name:type_name -> google.protobuf.StringValue
	11, // 50: google.ads.googleads.v2.resources.Campaign.DynamicSearchAdsSetting.language_code:type_name -> google.protobuf.StringValue
	37, // 51: google.ads.googleads.v2.resources.Campaign.DynamicSearchAdsSetting.use_supplied_urls_only:type_name -> google.protobuf.BoolValue
	11, // 52: google.ads.googleads.v2.resources.Campaign.DynamicSearchAdsSetting.feeds:type_name -> google.protobuf.StringValue
	11, // 53: google.ads.googleads.v2.resources.Campaign.SelectiveOptimization.conversion_actions:type_name -> google.protobuf.StringValue
	10, // 54: google.ads.googleads.v2.resources.Campaign.ShoppingSetting.merchant_id:type_name -> google.protobuf.Int64Value
	11, // 55: google.ads.googleads.v2.resources.Campaign.ShoppingSetting.sales_country:type_name -> google.protobuf.StringValue
	38, // 56: google.ads.googleads.v2.resources.Campaign.ShoppingSetting.campaign_priority:type_name -> google.protobuf.Int32Value
	37, // 57: google.ads.googleads.v2.resources.Campaign.ShoppingSetting.enable_local:type_name -> google.protobuf.BoolValue
	11, // 58: google.ads.googleads.v2.resources.Campaign.TrackingSetting.tracking_url:type_name -> google.protobuf.StringValue
	39, // 59: google.ads.googleads.v2.resources.Campaign.GeoTargetTypeSetting.positive_geo_target_type:type_name -> google.ads.googleads.v2.enums.PositiveGeoTargetTypeEnum.PositiveGeoTargetType
	40, // 60: google.ads.googleads.v2.resources.Campaign.GeoTargetTypeSetting.negative_geo_target_type:type_name -> google.ads.googleads.v2.enums.NegativeGeoTargetTypeEnum.NegativeGeoTargetType
	41, // 61: google.ads.googleads.v2.resources.Campaign.AppCampaignSetting.bidding_strategy_goal_type:type_name -> google.ads.googleads.v2.enums.AppCampaignBiddingStrategyGoalTypeEnum.AppCampaignBiddingStrategyGoalType
	11, // 62: google.ads.googleads.v2.resources.Campaign.AppCampaignSetting.app_id:type_name -> google.protobuf.StringValue
	42, // 63: google.ads.googleads.v2.resources.Campaign.AppCampaignSetting.app_store:type_name -> google.ads.googleads.v2.enums.AppCampaignAppStoreEnum.AppCampaignAppStore
	43, // 64: google.ads.googleads.v2.resources.Campaign.VanityPharma.vanity_pharma_display_url_mode:type_name -> google.ads.googleads.v2.enums.VanityPharmaDisplayUrlModeEnum.VanityPharmaDisplayUrlMode
	44, // 65: google.ads.googleads.v2.resources.Campaign.VanityPharma.vanity_pharma_text:type_name -> google.ads.googleads.v2.enums.VanityPharmaTextEnum.VanityPharmaText
	66, // [66:66] is the sub-list for method output_type
	66, // [66:66] is the sub-list for method input_type
	66, // [66:66] is the sub-list for extension type_name
	66, // [66:66] is the sub-list for extension extendee
	0,  // [0:66] is the sub-list for field type_name
}

func init() { file_google_ads_googleads_v2_resources_campaign_proto_init() }
func file_google_ads_googleads_v2_resources_campaign_proto_init() {
	if File_google_ads_googleads_v2_resources_campaign_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_ads_googleads_v2_resources_campaign_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Campaign); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v2_resources_campaign_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Campaign_NetworkSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v2_resources_campaign_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Campaign_HotelSettingInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v2_resources_campaign_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Campaign_DynamicSearchAdsSetting); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v2_resources_campaign_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Campaign_SelectiveOptimization); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v2_resources_campaign_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Campaign_ShoppingSetting); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v2_resources_campaign_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Campaign_TrackingSetting); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v2_resources_campaign_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Campaign_GeoTargetTypeSetting); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v2_resources_campaign_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Campaign_AppCampaignSetting); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v2_resources_campaign_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Campaign_VanityPharma); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_ads_googleads_v2_resources_campaign_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*Campaign_BiddingStrategy)(nil),
		(*Campaign_Commission)(nil),
		(*Campaign_ManualCpc)(nil),
		(*Campaign_ManualCpm)(nil),
		(*Campaign_ManualCpv)(nil),
		(*Campaign_MaximizeConversions)(nil),
		(*Campaign_MaximizeConversionValue)(nil),
		(*Campaign_TargetCpa)(nil),
		(*Campaign_TargetImpressionShare)(nil),
		(*Campaign_TargetRoas)(nil),
		(*Campaign_TargetSpend)(nil),
		(*Campaign_PercentCpc)(nil),
		(*Campaign_TargetCpm)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_ads_googleads_v2_resources_campaign_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_ads_googleads_v2_resources_campaign_proto_goTypes,
		DependencyIndexes: file_google_ads_googleads_v2_resources_campaign_proto_depIdxs,
		MessageInfos:      file_google_ads_googleads_v2_resources_campaign_proto_msgTypes,
	}.Build()
	File_google_ads_googleads_v2_resources_campaign_proto = out.File
	file_google_ads_googleads_v2_resources_campaign_proto_rawDesc = nil
	file_google_ads_googleads_v2_resources_campaign_proto_goTypes = nil
	file_google_ads_googleads_v2_resources_campaign_proto_depIdxs = nil
}
