// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/healthcare/logging/annotation.proto

package logging

import (
	reflect "reflect"
	sync "sync"

	status "google.golang.org/genproto/googleapis/rpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A log entry for an Annotation import long-running operation.
type ImportAnnotationLogEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The source in Cloud Storage. For example,
	// `gs://{bucket_id}/{path/to/file}`.
	Source string `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	// The error code and message.
	Error *status.Status `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *ImportAnnotationLogEntry) Reset() {
	*x = ImportAnnotationLogEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_healthcare_logging_annotation_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportAnnotationLogEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportAnnotationLogEntry) ProtoMessage() {}

func (x *ImportAnnotationLogEntry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_healthcare_logging_annotation_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportAnnotationLogEntry.ProtoReflect.Descriptor instead.
func (*ImportAnnotationLogEntry) Descriptor() ([]byte, []int) {
	return file_google_cloud_healthcare_logging_annotation_proto_rawDescGZIP(), []int{0}
}

func (x *ImportAnnotationLogEntry) GetSource() string {
	if x != nil {
		return x.Source
	}
	return ""
}

func (x *ImportAnnotationLogEntry) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

// A log entry for an Annotation export long-running operation.
type ExportAnnotationLogEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The destination in Cloud Storage or BigQuery.
	Destination string `protobuf:"bytes,1,opt,name=destination,proto3" json:"destination,omitempty"`
	// The annotation record being exported. For example:
	// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/annotationStores/{store_id}/annotations/{annotation_id}`.
	AnnotationName string `protobuf:"bytes,2,opt,name=annotation_name,json=annotationName,proto3" json:"annotation_name,omitempty"`
	// The error code and message.
	Error *status.Status `protobuf:"bytes,3,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *ExportAnnotationLogEntry) Reset() {
	*x = ExportAnnotationLogEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_healthcare_logging_annotation_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportAnnotationLogEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportAnnotationLogEntry) ProtoMessage() {}

func (x *ExportAnnotationLogEntry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_healthcare_logging_annotation_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportAnnotationLogEntry.ProtoReflect.Descriptor instead.
func (*ExportAnnotationLogEntry) Descriptor() ([]byte, []int) {
	return file_google_cloud_healthcare_logging_annotation_proto_rawDescGZIP(), []int{1}
}

func (x *ExportAnnotationLogEntry) GetDestination() string {
	if x != nil {
		return x.Destination
	}
	return ""
}

func (x *ExportAnnotationLogEntry) GetAnnotationName() string {
	if x != nil {
		return x.AnnotationName
	}
	return ""
}

func (x *ExportAnnotationLogEntry) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

// A log entry for an Annotation evaluate long-running operation.
type EvaluateAnnotationLogEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The report destination in BigQuery.
	Destination string `protobuf:"bytes,1,opt,name=destination,proto3" json:"destination,omitempty"`
	// The eval annotation record being evaluated. For example:
	// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/annotationStores/{eval_store_id}/annotations/{eval_annotation_id}`.
	EvalAnnotationName string `protobuf:"bytes,2,opt,name=eval_annotation_name,json=evalAnnotationName,proto3" json:"eval_annotation_name,omitempty"`
	// The golden annotation record being evaluated. For example:
	// `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/annotationStores/{golden_store_id}/annotations/{golden_annotation_id}`.
	GoldenAnnotationName string `protobuf:"bytes,3,opt,name=golden_annotation_name,json=goldenAnnotationName,proto3" json:"golden_annotation_name,omitempty"`
	// The error code and message.
	Error *status.Status `protobuf:"bytes,4,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *EvaluateAnnotationLogEntry) Reset() {
	*x = EvaluateAnnotationLogEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_healthcare_logging_annotation_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EvaluateAnnotationLogEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EvaluateAnnotationLogEntry) ProtoMessage() {}

func (x *EvaluateAnnotationLogEntry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_healthcare_logging_annotation_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EvaluateAnnotationLogEntry.ProtoReflect.Descriptor instead.
func (*EvaluateAnnotationLogEntry) Descriptor() ([]byte, []int) {
	return file_google_cloud_healthcare_logging_annotation_proto_rawDescGZIP(), []int{2}
}

func (x *EvaluateAnnotationLogEntry) GetDestination() string {
	if x != nil {
		return x.Destination
	}
	return ""
}

func (x *EvaluateAnnotationLogEntry) GetEvalAnnotationName() string {
	if x != nil {
		return x.EvalAnnotationName
	}
	return ""
}

func (x *EvaluateAnnotationLogEntry) GetGoldenAnnotationName() string {
	if x != nil {
		return x.GoldenAnnotationName
	}
	return ""
}

func (x *EvaluateAnnotationLogEntry) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

var File_google_cloud_healthcare_logging_annotation_proto protoreflect.FileDescriptor

var file_google_cloud_healthcare_logging_annotation_proto_rawDesc = []byte{
	0x0a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x68,
	0x65, 0x61, 0x6c, 0x74, 0x68, 0x63, 0x61, 0x72, 0x65, 0x2f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e,
	0x67, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x63, 0x61, 0x72, 0x65, 0x2e, 0x6c, 0x6f, 0x67, 0x67,
	0x69, 0x6e, 0x67, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x5c, 0x0a, 0x18,
	0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x12, 0x28, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x22, 0x8f, 0x01, 0x0a, 0x18, 0x45,
	0x78, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c,
	0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65,
	0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x27, 0x0a, 0x0f, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0e, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x28, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x22, 0xd0, 0x01, 0x0a,
	0x1a, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x20, 0x0a, 0x0b, 0x64,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x30, 0x0a,
	0x14, 0x65, 0x76, 0x61, 0x6c, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x65, 0x76, 0x61,
	0x6c, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x34, 0x0a, 0x16, 0x67, 0x6f, 0x6c, 0x64, 0x65, 0x6e, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x14, 0x67, 0x6f, 0x6c, 0x64, 0x65, 0x6e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x28, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70,
	0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x42,
	0x6d, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x63, 0x61, 0x72, 0x65, 0x2e, 0x6c,
	0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x5a, 0x46, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67,
	0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x63, 0x61, 0x72, 0x65, 0x2f, 0x6c,
	0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x3b, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_healthcare_logging_annotation_proto_rawDescOnce sync.Once
	file_google_cloud_healthcare_logging_annotation_proto_rawDescData = file_google_cloud_healthcare_logging_annotation_proto_rawDesc
)

func file_google_cloud_healthcare_logging_annotation_proto_rawDescGZIP() []byte {
	file_google_cloud_healthcare_logging_annotation_proto_rawDescOnce.Do(func() {
		file_google_cloud_healthcare_logging_annotation_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_healthcare_logging_annotation_proto_rawDescData)
	})
	return file_google_cloud_healthcare_logging_annotation_proto_rawDescData
}

var file_google_cloud_healthcare_logging_annotation_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_google_cloud_healthcare_logging_annotation_proto_goTypes = []interface{}{
	(*ImportAnnotationLogEntry)(nil),   // 0: google.cloud.healthcare.logging.ImportAnnotationLogEntry
	(*ExportAnnotationLogEntry)(nil),   // 1: google.cloud.healthcare.logging.ExportAnnotationLogEntry
	(*EvaluateAnnotationLogEntry)(nil), // 2: google.cloud.healthcare.logging.EvaluateAnnotationLogEntry
	(*status.Status)(nil),              // 3: google.rpc.Status
}
var file_google_cloud_healthcare_logging_annotation_proto_depIdxs = []int32{
	3, // 0: google.cloud.healthcare.logging.ImportAnnotationLogEntry.error:type_name -> google.rpc.Status
	3, // 1: google.cloud.healthcare.logging.ExportAnnotationLogEntry.error:type_name -> google.rpc.Status
	3, // 2: google.cloud.healthcare.logging.EvaluateAnnotationLogEntry.error:type_name -> google.rpc.Status
	3, // [3:3] is the sub-list for method output_type
	3, // [3:3] is the sub-list for method input_type
	3, // [3:3] is the sub-list for extension type_name
	3, // [3:3] is the sub-list for extension extendee
	0, // [0:3] is the sub-list for field type_name
}

func init() { file_google_cloud_healthcare_logging_annotation_proto_init() }
func file_google_cloud_healthcare_logging_annotation_proto_init() {
	if File_google_cloud_healthcare_logging_annotation_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_healthcare_logging_annotation_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportAnnotationLogEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_healthcare_logging_annotation_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportAnnotationLogEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_healthcare_logging_annotation_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EvaluateAnnotationLogEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_healthcare_logging_annotation_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_healthcare_logging_annotation_proto_goTypes,
		DependencyIndexes: file_google_cloud_healthcare_logging_annotation_proto_depIdxs,
		MessageInfos:      file_google_cloud_healthcare_logging_annotation_proto_msgTypes,
	}.Build()
	File_google_cloud_healthcare_logging_annotation_proto = out.File
	file_google_cloud_healthcare_logging_annotation_proto_rawDesc = nil
	file_google_cloud_healthcare_logging_annotation_proto_goTypes = nil
	file_google_cloud_healthcare_logging_annotation_proto_depIdxs = nil
}
