// Copyright 2019 Google LLC.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/firestore/admin/v1beta1/firestore_admin.proto

package admin

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The various possible states for an ongoing Operation.
type OperationState int32

const (
	// Unspecified.
	OperationState_STATE_UNSPECIFIED OperationState = 0
	// Request is being prepared for processing.
	OperationState_INITIALIZING OperationState = 1
	// Request is actively being processed.
	OperationState_PROCESSING OperationState = 2
	// Request is in the process of being cancelled after user called
	// google.longrunning.Operations.CancelOperation on the operation.
	OperationState_CANCELLING OperationState = 3
	// Request has been processed and is in its finalization stage.
	OperationState_FINALIZING OperationState = 4
	// Request has completed successfully.
	OperationState_SUCCESSFUL OperationState = 5
	// Request has finished being processed, but encountered an error.
	OperationState_FAILED OperationState = 6
	// Request has finished being cancelled after user called
	// google.longrunning.Operations.CancelOperation.
	OperationState_CANCELLED OperationState = 7
)

// Enum value maps for OperationState.
var (
	OperationState_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "INITIALIZING",
		2: "PROCESSING",
		3: "CANCELLING",
		4: "FINALIZING",
		5: "SUCCESSFUL",
		6: "FAILED",
		7: "CANCELLED",
	}
	OperationState_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"INITIALIZING":      1,
		"PROCESSING":        2,
		"CANCELLING":        3,
		"FINALIZING":        4,
		"SUCCESSFUL":        5,
		"FAILED":            6,
		"CANCELLED":         7,
	}
)

func (x OperationState) Enum() *OperationState {
	p := new(OperationState)
	*p = x
	return p
}

func (x OperationState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OperationState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_firestore_admin_v1beta1_firestore_admin_proto_enumTypes[0].Descriptor()
}

func (OperationState) Type() protoreflect.EnumType {
	return &file_google_firestore_admin_v1beta1_firestore_admin_proto_enumTypes[0]
}

func (x OperationState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OperationState.Descriptor instead.
func (OperationState) EnumDescriptor() ([]byte, []int) {
	return file_google_firestore_admin_v1beta1_firestore_admin_proto_rawDescGZIP(), []int{0}
}

// The type of index operation.
type IndexOperationMetadata_OperationType int32

const (
	// Unspecified. Never set by server.
	IndexOperationMetadata_OPERATION_TYPE_UNSPECIFIED IndexOperationMetadata_OperationType = 0
	// The operation is creating the index. Initiated by a `CreateIndex` call.
	IndexOperationMetadata_CREATING_INDEX IndexOperationMetadata_OperationType = 1
)

// Enum value maps for IndexOperationMetadata_OperationType.
var (
	IndexOperationMetadata_OperationType_name = map[int32]string{
		0: "OPERATION_TYPE_UNSPECIFIED",
		1: "CREATING_INDEX",
	}
	IndexOperationMetadata_OperationType_value = map[string]int32{
		"OPERATION_TYPE_UNSPECIFIED": 0,
		"CREATING_INDEX":             1,
	}
)

func (x IndexOperationMetadata_OperationType) Enum() *IndexOperationMetadata_OperationType {
	p := new(IndexOperationMetadata_OperationType)
	*p = x
	return p
}

func (x IndexOperationMetadata_OperationType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (IndexOperationMetadata_OperationType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_firestore_admin_v1beta1_firestore_admin_proto_enumTypes[1].Descriptor()
}

func (IndexOperationMetadata_OperationType) Type() protoreflect.EnumType {
	return &file_google_firestore_admin_v1beta1_firestore_admin_proto_enumTypes[1]
}

func (x IndexOperationMetadata_OperationType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use IndexOperationMetadata_OperationType.Descriptor instead.
func (IndexOperationMetadata_OperationType) EnumDescriptor() ([]byte, []int) {
	return file_google_firestore_admin_v1beta1_firestore_admin_proto_rawDescGZIP(), []int{0, 0}
}

// Metadata for index operations. This metadata populates
// the metadata field of [google.longrunning.Operation][google.longrunning.Operation].
type IndexOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The time that work began on the operation.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The time the operation ended, either successfully or otherwise. Unset if
	// the operation is still active.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The index resource that this operation is acting on. For example:
	// `projects/{project_id}/databases/{database_id}/indexes/{index_id}`
	Index string `protobuf:"bytes,3,opt,name=index,proto3" json:"index,omitempty"`
	// The type of index operation.
	OperationType IndexOperationMetadata_OperationType `protobuf:"varint,4,opt,name=operation_type,json=operationType,proto3,enum=google.firestore.admin.v1beta1.IndexOperationMetadata_OperationType" json:"operation_type,omitempty"`
	// True if the [google.longrunning.Operation] was cancelled. If the
	// cancellation is in progress, cancelled will be true but
	// [google.longrunning.Operation.done][google.longrunning.Operation.done] will be false.
	Cancelled bool `protobuf:"varint,5,opt,name=cancelled,proto3" json:"cancelled,omitempty"`
	// Progress of the existing operation, measured in number of documents.
	DocumentProgress *Progress `protobuf:"bytes,6,opt,name=document_progress,json=documentProgress,proto3" json:"document_progress,omitempty"`
}

func (x *IndexOperationMetadata) Reset() {
	*x = IndexOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_admin_v1beta1_firestore_admin_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IndexOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IndexOperationMetadata) ProtoMessage() {}

func (x *IndexOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_admin_v1beta1_firestore_admin_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IndexOperationMetadata.ProtoReflect.Descriptor instead.
func (*IndexOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_firestore_admin_v1beta1_firestore_admin_proto_rawDescGZIP(), []int{0}
}

func (x *IndexOperationMetadata) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *IndexOperationMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *IndexOperationMetadata) GetIndex() string {
	if x != nil {
		return x.Index
	}
	return ""
}

func (x *IndexOperationMetadata) GetOperationType() IndexOperationMetadata_OperationType {
	if x != nil {
		return x.OperationType
	}
	return IndexOperationMetadata_OPERATION_TYPE_UNSPECIFIED
}

func (x *IndexOperationMetadata) GetCancelled() bool {
	if x != nil {
		return x.Cancelled
	}
	return false
}

func (x *IndexOperationMetadata) GetDocumentProgress() *Progress {
	if x != nil {
		return x.DocumentProgress
	}
	return nil
}

// Measures the progress of a particular metric.
type Progress struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An estimate of how much work has been completed. Note that this may be
	// greater than `work_estimated`.
	WorkCompleted int64 `protobuf:"varint,1,opt,name=work_completed,json=workCompleted,proto3" json:"work_completed,omitempty"`
	// An estimate of how much work needs to be performed. Zero if the
	// work estimate is unavailable. May change as work progresses.
	WorkEstimated int64 `protobuf:"varint,2,opt,name=work_estimated,json=workEstimated,proto3" json:"work_estimated,omitempty"`
}

func (x *Progress) Reset() {
	*x = Progress{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_admin_v1beta1_firestore_admin_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Progress) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Progress) ProtoMessage() {}

func (x *Progress) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_admin_v1beta1_firestore_admin_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Progress.ProtoReflect.Descriptor instead.
func (*Progress) Descriptor() ([]byte, []int) {
	return file_google_firestore_admin_v1beta1_firestore_admin_proto_rawDescGZIP(), []int{1}
}

func (x *Progress) GetWorkCompleted() int64 {
	if x != nil {
		return x.WorkCompleted
	}
	return 0
}

func (x *Progress) GetWorkEstimated() int64 {
	if x != nil {
		return x.WorkEstimated
	}
	return 0
}

// The request for [FirestoreAdmin.CreateIndex][google.firestore.admin.v1beta1.FirestoreAdmin.CreateIndex].
type CreateIndexRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the database this index will apply to. For example:
	// `projects/{project_id}/databases/{database_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The index to create. The name and state fields are output only and will be
	// ignored. Certain single field indexes cannot be created or deleted.
	Index *Index `protobuf:"bytes,2,opt,name=index,proto3" json:"index,omitempty"`
}

func (x *CreateIndexRequest) Reset() {
	*x = CreateIndexRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_admin_v1beta1_firestore_admin_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateIndexRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateIndexRequest) ProtoMessage() {}

func (x *CreateIndexRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_admin_v1beta1_firestore_admin_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateIndexRequest.ProtoReflect.Descriptor instead.
func (*CreateIndexRequest) Descriptor() ([]byte, []int) {
	return file_google_firestore_admin_v1beta1_firestore_admin_proto_rawDescGZIP(), []int{2}
}

func (x *CreateIndexRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateIndexRequest) GetIndex() *Index {
	if x != nil {
		return x.Index
	}
	return nil
}

// The request for [FirestoreAdmin.GetIndex][google.firestore.admin.v1beta1.FirestoreAdmin.GetIndex].
type GetIndexRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the index. For example:
	// `projects/{project_id}/databases/{database_id}/indexes/{index_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetIndexRequest) Reset() {
	*x = GetIndexRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_admin_v1beta1_firestore_admin_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetIndexRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetIndexRequest) ProtoMessage() {}

func (x *GetIndexRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_admin_v1beta1_firestore_admin_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetIndexRequest.ProtoReflect.Descriptor instead.
func (*GetIndexRequest) Descriptor() ([]byte, []int) {
	return file_google_firestore_admin_v1beta1_firestore_admin_proto_rawDescGZIP(), []int{3}
}

func (x *GetIndexRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request for [FirestoreAdmin.ListIndexes][google.firestore.admin.v1beta1.FirestoreAdmin.ListIndexes].
type ListIndexesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The database name. For example:
	// `projects/{project_id}/databases/{database_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// The standard List page size.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The standard List page token.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListIndexesRequest) Reset() {
	*x = ListIndexesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_admin_v1beta1_firestore_admin_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListIndexesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListIndexesRequest) ProtoMessage() {}

func (x *ListIndexesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_admin_v1beta1_firestore_admin_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListIndexesRequest.ProtoReflect.Descriptor instead.
func (*ListIndexesRequest) Descriptor() ([]byte, []int) {
	return file_google_firestore_admin_v1beta1_firestore_admin_proto_rawDescGZIP(), []int{4}
}

func (x *ListIndexesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListIndexesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListIndexesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListIndexesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The request for [FirestoreAdmin.DeleteIndex][google.firestore.admin.v1beta1.FirestoreAdmin.DeleteIndex].
type DeleteIndexRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The index name. For example:
	// `projects/{project_id}/databases/{database_id}/indexes/{index_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteIndexRequest) Reset() {
	*x = DeleteIndexRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_admin_v1beta1_firestore_admin_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteIndexRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteIndexRequest) ProtoMessage() {}

func (x *DeleteIndexRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_admin_v1beta1_firestore_admin_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteIndexRequest.ProtoReflect.Descriptor instead.
func (*DeleteIndexRequest) Descriptor() ([]byte, []int) {
	return file_google_firestore_admin_v1beta1_firestore_admin_proto_rawDescGZIP(), []int{5}
}

func (x *DeleteIndexRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The response for [FirestoreAdmin.ListIndexes][google.firestore.admin.v1beta1.FirestoreAdmin.ListIndexes].
type ListIndexesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The indexes.
	Indexes []*Index `protobuf:"bytes,1,rep,name=indexes,proto3" json:"indexes,omitempty"`
	// The standard List next-page token.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListIndexesResponse) Reset() {
	*x = ListIndexesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_admin_v1beta1_firestore_admin_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListIndexesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListIndexesResponse) ProtoMessage() {}

func (x *ListIndexesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_admin_v1beta1_firestore_admin_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListIndexesResponse.ProtoReflect.Descriptor instead.
func (*ListIndexesResponse) Descriptor() ([]byte, []int) {
	return file_google_firestore_admin_v1beta1_firestore_admin_proto_rawDescGZIP(), []int{6}
}

func (x *ListIndexesResponse) GetIndexes() []*Index {
	if x != nil {
		return x.Indexes
	}
	return nil
}

func (x *ListIndexesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request for [FirestoreAdmin.ExportDocuments][google.firestore.admin.v1beta1.FirestoreAdmin.ExportDocuments].
type ExportDocumentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Database to export. Should be of the form:
	// `projects/{project_id}/databases/{database_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Which collection ids to export. Unspecified means all collections.
	CollectionIds []string `protobuf:"bytes,3,rep,name=collection_ids,json=collectionIds,proto3" json:"collection_ids,omitempty"`
	// The output URI. Currently only supports Google Cloud Storage URIs of the
	// form: `gs://BUCKET_NAME[/NAMESPACE_PATH]`, where `BUCKET_NAME` is the name
	// of the Google Cloud Storage bucket and `NAMESPACE_PATH` is an optional
	// Google Cloud Storage namespace path. When
	// choosing a name, be sure to consider Google Cloud Storage naming
	// guidelines: https://cloud.google.com/storage/docs/naming.
	// If the URI is a bucket (without a namespace path), a prefix will be
	// generated based on the start time.
	OutputUriPrefix string `protobuf:"bytes,4,opt,name=output_uri_prefix,json=outputUriPrefix,proto3" json:"output_uri_prefix,omitempty"`
}

func (x *ExportDocumentsRequest) Reset() {
	*x = ExportDocumentsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_admin_v1beta1_firestore_admin_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportDocumentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportDocumentsRequest) ProtoMessage() {}

func (x *ExportDocumentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_admin_v1beta1_firestore_admin_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportDocumentsRequest.ProtoReflect.Descriptor instead.
func (*ExportDocumentsRequest) Descriptor() ([]byte, []int) {
	return file_google_firestore_admin_v1beta1_firestore_admin_proto_rawDescGZIP(), []int{7}
}

func (x *ExportDocumentsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ExportDocumentsRequest) GetCollectionIds() []string {
	if x != nil {
		return x.CollectionIds
	}
	return nil
}

func (x *ExportDocumentsRequest) GetOutputUriPrefix() string {
	if x != nil {
		return x.OutputUriPrefix
	}
	return ""
}

// The request for [FirestoreAdmin.ImportDocuments][google.firestore.admin.v1beta1.FirestoreAdmin.ImportDocuments].
type ImportDocumentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Database to import into. Should be of the form:
	// `projects/{project_id}/databases/{database_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Which collection ids to import. Unspecified means all collections included
	// in the import.
	CollectionIds []string `protobuf:"bytes,3,rep,name=collection_ids,json=collectionIds,proto3" json:"collection_ids,omitempty"`
	// Location of the exported files.
	// This must match the output_uri_prefix of an ExportDocumentsResponse from
	// an export that has completed successfully.
	// See:
	// [google.firestore.admin.v1beta1.ExportDocumentsResponse.output_uri_prefix][google.firestore.admin.v1beta1.ExportDocumentsResponse.output_uri_prefix].
	InputUriPrefix string `protobuf:"bytes,4,opt,name=input_uri_prefix,json=inputUriPrefix,proto3" json:"input_uri_prefix,omitempty"`
}

func (x *ImportDocumentsRequest) Reset() {
	*x = ImportDocumentsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_admin_v1beta1_firestore_admin_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportDocumentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportDocumentsRequest) ProtoMessage() {}

func (x *ImportDocumentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_admin_v1beta1_firestore_admin_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportDocumentsRequest.ProtoReflect.Descriptor instead.
func (*ImportDocumentsRequest) Descriptor() ([]byte, []int) {
	return file_google_firestore_admin_v1beta1_firestore_admin_proto_rawDescGZIP(), []int{8}
}

func (x *ImportDocumentsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ImportDocumentsRequest) GetCollectionIds() []string {
	if x != nil {
		return x.CollectionIds
	}
	return nil
}

func (x *ImportDocumentsRequest) GetInputUriPrefix() string {
	if x != nil {
		return x.InputUriPrefix
	}
	return ""
}

// Returned in the [google.longrunning.Operation][google.longrunning.Operation] response field.
type ExportDocumentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Location of the output files. This can be used to begin an import
	// into Cloud Firestore (this project or another project) after the operation
	// completes successfully.
	OutputUriPrefix string `protobuf:"bytes,1,opt,name=output_uri_prefix,json=outputUriPrefix,proto3" json:"output_uri_prefix,omitempty"`
}

func (x *ExportDocumentsResponse) Reset() {
	*x = ExportDocumentsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_admin_v1beta1_firestore_admin_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportDocumentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportDocumentsResponse) ProtoMessage() {}

func (x *ExportDocumentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_admin_v1beta1_firestore_admin_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportDocumentsResponse.ProtoReflect.Descriptor instead.
func (*ExportDocumentsResponse) Descriptor() ([]byte, []int) {
	return file_google_firestore_admin_v1beta1_firestore_admin_proto_rawDescGZIP(), []int{9}
}

func (x *ExportDocumentsResponse) GetOutputUriPrefix() string {
	if x != nil {
		return x.OutputUriPrefix
	}
	return ""
}

// Metadata for ExportDocuments operations.
type ExportDocumentsMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The time that work began on the operation.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The time the operation ended, either successfully or otherwise. Unset if
	// the operation is still active.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The state of the export operation.
	OperationState OperationState `protobuf:"varint,3,opt,name=operation_state,json=operationState,proto3,enum=google.firestore.admin.v1beta1.OperationState" json:"operation_state,omitempty"`
	// An estimate of the number of documents processed.
	ProgressDocuments *Progress `protobuf:"bytes,4,opt,name=progress_documents,json=progressDocuments,proto3" json:"progress_documents,omitempty"`
	// An estimate of the number of bytes processed.
	ProgressBytes *Progress `protobuf:"bytes,5,opt,name=progress_bytes,json=progressBytes,proto3" json:"progress_bytes,omitempty"`
	// Which collection ids are being exported.
	CollectionIds []string `protobuf:"bytes,6,rep,name=collection_ids,json=collectionIds,proto3" json:"collection_ids,omitempty"`
	// Where the entities are being exported to.
	OutputUriPrefix string `protobuf:"bytes,7,opt,name=output_uri_prefix,json=outputUriPrefix,proto3" json:"output_uri_prefix,omitempty"`
}

func (x *ExportDocumentsMetadata) Reset() {
	*x = ExportDocumentsMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_admin_v1beta1_firestore_admin_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportDocumentsMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportDocumentsMetadata) ProtoMessage() {}

func (x *ExportDocumentsMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_admin_v1beta1_firestore_admin_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportDocumentsMetadata.ProtoReflect.Descriptor instead.
func (*ExportDocumentsMetadata) Descriptor() ([]byte, []int) {
	return file_google_firestore_admin_v1beta1_firestore_admin_proto_rawDescGZIP(), []int{10}
}

func (x *ExportDocumentsMetadata) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *ExportDocumentsMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *ExportDocumentsMetadata) GetOperationState() OperationState {
	if x != nil {
		return x.OperationState
	}
	return OperationState_STATE_UNSPECIFIED
}

func (x *ExportDocumentsMetadata) GetProgressDocuments() *Progress {
	if x != nil {
		return x.ProgressDocuments
	}
	return nil
}

func (x *ExportDocumentsMetadata) GetProgressBytes() *Progress {
	if x != nil {
		return x.ProgressBytes
	}
	return nil
}

func (x *ExportDocumentsMetadata) GetCollectionIds() []string {
	if x != nil {
		return x.CollectionIds
	}
	return nil
}

func (x *ExportDocumentsMetadata) GetOutputUriPrefix() string {
	if x != nil {
		return x.OutputUriPrefix
	}
	return ""
}

// Metadata for ImportDocuments operations.
type ImportDocumentsMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The time that work began on the operation.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The time the operation ended, either successfully or otherwise. Unset if
	// the operation is still active.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The state of the import operation.
	OperationState OperationState `protobuf:"varint,3,opt,name=operation_state,json=operationState,proto3,enum=google.firestore.admin.v1beta1.OperationState" json:"operation_state,omitempty"`
	// An estimate of the number of documents processed.
	ProgressDocuments *Progress `protobuf:"bytes,4,opt,name=progress_documents,json=progressDocuments,proto3" json:"progress_documents,omitempty"`
	// An estimate of the number of bytes processed.
	ProgressBytes *Progress `protobuf:"bytes,5,opt,name=progress_bytes,json=progressBytes,proto3" json:"progress_bytes,omitempty"`
	// Which collection ids are being imported.
	CollectionIds []string `protobuf:"bytes,6,rep,name=collection_ids,json=collectionIds,proto3" json:"collection_ids,omitempty"`
	// The location of the documents being imported.
	InputUriPrefix string `protobuf:"bytes,7,opt,name=input_uri_prefix,json=inputUriPrefix,proto3" json:"input_uri_prefix,omitempty"`
}

func (x *ImportDocumentsMetadata) Reset() {
	*x = ImportDocumentsMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_firestore_admin_v1beta1_firestore_admin_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportDocumentsMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportDocumentsMetadata) ProtoMessage() {}

func (x *ImportDocumentsMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_firestore_admin_v1beta1_firestore_admin_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportDocumentsMetadata.ProtoReflect.Descriptor instead.
func (*ImportDocumentsMetadata) Descriptor() ([]byte, []int) {
	return file_google_firestore_admin_v1beta1_firestore_admin_proto_rawDescGZIP(), []int{11}
}

func (x *ImportDocumentsMetadata) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *ImportDocumentsMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *ImportDocumentsMetadata) GetOperationState() OperationState {
	if x != nil {
		return x.OperationState
	}
	return OperationState_STATE_UNSPECIFIED
}

func (x *ImportDocumentsMetadata) GetProgressDocuments() *Progress {
	if x != nil {
		return x.ProgressDocuments
	}
	return nil
}

func (x *ImportDocumentsMetadata) GetProgressBytes() *Progress {
	if x != nil {
		return x.ProgressBytes
	}
	return nil
}

func (x *ImportDocumentsMetadata) GetCollectionIds() []string {
	if x != nil {
		return x.CollectionIds
	}
	return nil
}

func (x *ImportDocumentsMetadata) GetInputUriPrefix() string {
	if x != nil {
		return x.InputUriPrefix
	}
	return ""
}

var File_google_firestore_admin_v1beta1_firestore_admin_proto protoreflect.FileDescriptor

var file_google_firestore_admin_v1beta1_firestore_admin_proto_rawDesc = []byte{
	0x0a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66,
	0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x66, 0x69, 0x72,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc7, 0x03, 0x0a,
	0x16, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x69, 0x6e, 0x64,
	0x65, 0x78, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x12,
	0x6b, 0x0a, 0x0e, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0d, 0x6f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a, 0x09,
	0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x09, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x65, 0x64, 0x12, 0x55, 0x0a, 0x11, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66,
	0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52,
	0x10, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73,
	0x73, 0x22, 0x43, 0x0a, 0x0d, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x1e, 0x0a, 0x1a, 0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x5f, 0x49,
	0x4e, 0x44, 0x45, 0x58, 0x10, 0x01, 0x22, 0x58, 0x0a, 0x08, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65,
	0x73, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x6c,
	0x65, 0x74, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d, 0x77, 0x6f, 0x72, 0x6b,
	0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x12, 0x25, 0x0a, 0x0e, 0x77, 0x6f, 0x72,
	0x6b, 0x5f, 0x65, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x0d, 0x77, 0x6f, 0x72, 0x6b, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x64,
	0x22, 0x69, 0x0a, 0x12, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x3b,
	0x0a, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49,
	0x6e, 0x64, 0x65, 0x78, 0x52, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x22, 0x25, 0x0a, 0x0f, 0x47,
	0x65, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0x80, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x28, 0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49,
	0x6e, 0x64, 0x65, 0x78, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0x7e, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x65, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3f, 0x0a, 0x07, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x07,
	0x69, 0x6e, 0x64, 0x65, 0x78, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0x7f, 0x0a, 0x16, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a,
	0x0e, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x64, 0x73, 0x12, 0x2a, 0x0a, 0x11, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x75,
	0x72, 0x69, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x55, 0x72, 0x69, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78,
	0x22, 0x7d, 0x0a, 0x16, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x25,
	0x0a, 0x0e, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x64, 0x73, 0x12, 0x28, 0x0a, 0x10, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x75,
	0x72, 0x69, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0e, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x55, 0x72, 0x69, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x22,
	0x45, 0x0a, 0x17, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2a, 0x0a, 0x11, 0x6f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x55, 0x72, 0x69,
	0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x22, 0xe1, 0x03, 0x0a, 0x17, 0x45, 0x78, 0x70, 0x6f, 0x72,
	0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a,
	0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x57, 0x0a, 0x0f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x0e, 0x6f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x57, 0x0a,
	0x12, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x67, 0x72,
	0x65, 0x73, 0x73, 0x52, 0x11, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x44, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x4f, 0x0a, 0x0e, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65,
	0x73, 0x73, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x0d, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65,
	0x73, 0x73, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x6f, 0x6c, 0x6c, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x0d, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x73, 0x12, 0x2a,
	0x0a, 0x11, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x5f, 0x70, 0x72, 0x65,
	0x66, 0x69, 0x78, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x6f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x55, 0x72, 0x69, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x22, 0xdf, 0x03, 0x0a, 0x17, 0x49,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x57, 0x0a, 0x0f, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x52, 0x0e, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x57, 0x0a, 0x12, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50,
	0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x11, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73,
	0x73, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x4f, 0x0a, 0x0e, 0x70, 0x72,
	0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x0d, 0x70, 0x72,
	0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x63,
	0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x06, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x0d, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x64, 0x73, 0x12, 0x28, 0x0a, 0x10, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x5f,
	0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x69, 0x6e,
	0x70, 0x75, 0x74, 0x55, 0x72, 0x69, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x2a, 0x94, 0x01, 0x0a,
	0x0e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x49, 0x4e, 0x49, 0x54, 0x49, 0x41,
	0x4c, 0x49, 0x5a, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x50, 0x52, 0x4f, 0x43,
	0x45, 0x53, 0x53, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0e, 0x0a, 0x0a, 0x43, 0x41, 0x4e, 0x43,
	0x45, 0x4c, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0e, 0x0a, 0x0a, 0x46, 0x49, 0x4e, 0x41,
	0x4c, 0x49, 0x5a, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x0e, 0x0a, 0x0a, 0x53, 0x55, 0x43, 0x43,
	0x45, 0x53, 0x53, 0x46, 0x55, 0x4c, 0x10, 0x05, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c,
	0x45, 0x44, 0x10, 0x06, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x45,
	0x44, 0x10, 0x07, 0x32, 0xf0, 0x08, 0x0a, 0x0e, 0x46, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x12, 0xa1, 0x01, 0x0a, 0x0b, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e,
	0x64, 0x65, 0x78, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x3f, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x39, 0x22, 0x30, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x69, 0x6e, 0x64, 0x65,
	0x78, 0x65, 0x73, 0x3a, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x12, 0xb0, 0x01, 0x0a, 0x0b, 0x4c,
	0x69, 0x73, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x65, 0x73, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x49, 0x6e, 0x64, 0x65, 0x78, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x38, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x12, 0x30, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x65, 0x73, 0x12, 0x9c, 0x01,
	0x0a, 0x08, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x49,
	0x6e, 0x64, 0x65, 0x78, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x25, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6e, 0x64,
	0x65, 0x78, 0x22, 0x38, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x12, 0x30, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x2f,
	0x2a, 0x2f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x93, 0x01, 0x0a,
	0x0b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x32, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x38, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32,
	0x2a, 0x30, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0xab, 0x01, 0x0a, 0x0f, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x41, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x22, 0x36, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x65, 0x78,
	0x70, 0x6f, 0x72, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x3a, 0x01, 0x2a,
	0x12, 0xab, 0x01, 0x0a, 0x0f, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69,
	0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x41, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x3b, 0x22, 0x36, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x69, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x3a, 0x01, 0x2a, 0x1a, 0x76,
	0xca, 0x41, 0x18, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x58, 0x68, 0x74,
	0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2c, 0x68, 0x74, 0x74,
	0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x64, 0x61, 0x74,
	0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x42, 0xae, 0x01, 0x0a, 0x22, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x13, 0x46,
	0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x50, 0x01, 0x5a, 0x43, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c,
	0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x66, 0x69, 0x72, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x3b, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0xa2, 0x02, 0x04, 0x47, 0x43, 0x46, 0x53,
	0xaa, 0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x46, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_firestore_admin_v1beta1_firestore_admin_proto_rawDescOnce sync.Once
	file_google_firestore_admin_v1beta1_firestore_admin_proto_rawDescData = file_google_firestore_admin_v1beta1_firestore_admin_proto_rawDesc
)

func file_google_firestore_admin_v1beta1_firestore_admin_proto_rawDescGZIP() []byte {
	file_google_firestore_admin_v1beta1_firestore_admin_proto_rawDescOnce.Do(func() {
		file_google_firestore_admin_v1beta1_firestore_admin_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_firestore_admin_v1beta1_firestore_admin_proto_rawDescData)
	})
	return file_google_firestore_admin_v1beta1_firestore_admin_proto_rawDescData
}

var file_google_firestore_admin_v1beta1_firestore_admin_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_firestore_admin_v1beta1_firestore_admin_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_google_firestore_admin_v1beta1_firestore_admin_proto_goTypes = []interface{}{
	(OperationState)(0),                       // 0: google.firestore.admin.v1beta1.OperationState
	(IndexOperationMetadata_OperationType)(0), // 1: google.firestore.admin.v1beta1.IndexOperationMetadata.OperationType
	(*IndexOperationMetadata)(nil),            // 2: google.firestore.admin.v1beta1.IndexOperationMetadata
	(*Progress)(nil),                          // 3: google.firestore.admin.v1beta1.Progress
	(*CreateIndexRequest)(nil),                // 4: google.firestore.admin.v1beta1.CreateIndexRequest
	(*GetIndexRequest)(nil),                   // 5: google.firestore.admin.v1beta1.GetIndexRequest
	(*ListIndexesRequest)(nil),                // 6: google.firestore.admin.v1beta1.ListIndexesRequest
	(*DeleteIndexRequest)(nil),                // 7: google.firestore.admin.v1beta1.DeleteIndexRequest
	(*ListIndexesResponse)(nil),               // 8: google.firestore.admin.v1beta1.ListIndexesResponse
	(*ExportDocumentsRequest)(nil),            // 9: google.firestore.admin.v1beta1.ExportDocumentsRequest
	(*ImportDocumentsRequest)(nil),            // 10: google.firestore.admin.v1beta1.ImportDocumentsRequest
	(*ExportDocumentsResponse)(nil),           // 11: google.firestore.admin.v1beta1.ExportDocumentsResponse
	(*ExportDocumentsMetadata)(nil),           // 12: google.firestore.admin.v1beta1.ExportDocumentsMetadata
	(*ImportDocumentsMetadata)(nil),           // 13: google.firestore.admin.v1beta1.ImportDocumentsMetadata
	(*timestamppb.Timestamp)(nil),             // 14: google.protobuf.Timestamp
	(*Index)(nil),                             // 15: google.firestore.admin.v1beta1.Index
	(*longrunning.Operation)(nil),             // 16: google.longrunning.Operation
	(*emptypb.Empty)(nil),                     // 17: google.protobuf.Empty
}
var file_google_firestore_admin_v1beta1_firestore_admin_proto_depIdxs = []int32{
	14, // 0: google.firestore.admin.v1beta1.IndexOperationMetadata.start_time:type_name -> google.protobuf.Timestamp
	14, // 1: google.firestore.admin.v1beta1.IndexOperationMetadata.end_time:type_name -> google.protobuf.Timestamp
	1,  // 2: google.firestore.admin.v1beta1.IndexOperationMetadata.operation_type:type_name -> google.firestore.admin.v1beta1.IndexOperationMetadata.OperationType
	3,  // 3: google.firestore.admin.v1beta1.IndexOperationMetadata.document_progress:type_name -> google.firestore.admin.v1beta1.Progress
	15, // 4: google.firestore.admin.v1beta1.CreateIndexRequest.index:type_name -> google.firestore.admin.v1beta1.Index
	15, // 5: google.firestore.admin.v1beta1.ListIndexesResponse.indexes:type_name -> google.firestore.admin.v1beta1.Index
	14, // 6: google.firestore.admin.v1beta1.ExportDocumentsMetadata.start_time:type_name -> google.protobuf.Timestamp
	14, // 7: google.firestore.admin.v1beta1.ExportDocumentsMetadata.end_time:type_name -> google.protobuf.Timestamp
	0,  // 8: google.firestore.admin.v1beta1.ExportDocumentsMetadata.operation_state:type_name -> google.firestore.admin.v1beta1.OperationState
	3,  // 9: google.firestore.admin.v1beta1.ExportDocumentsMetadata.progress_documents:type_name -> google.firestore.admin.v1beta1.Progress
	3,  // 10: google.firestore.admin.v1beta1.ExportDocumentsMetadata.progress_bytes:type_name -> google.firestore.admin.v1beta1.Progress
	14, // 11: google.firestore.admin.v1beta1.ImportDocumentsMetadata.start_time:type_name -> google.protobuf.Timestamp
	14, // 12: google.firestore.admin.v1beta1.ImportDocumentsMetadata.end_time:type_name -> google.protobuf.Timestamp
	0,  // 13: google.firestore.admin.v1beta1.ImportDocumentsMetadata.operation_state:type_name -> google.firestore.admin.v1beta1.OperationState
	3,  // 14: google.firestore.admin.v1beta1.ImportDocumentsMetadata.progress_documents:type_name -> google.firestore.admin.v1beta1.Progress
	3,  // 15: google.firestore.admin.v1beta1.ImportDocumentsMetadata.progress_bytes:type_name -> google.firestore.admin.v1beta1.Progress
	4,  // 16: google.firestore.admin.v1beta1.FirestoreAdmin.CreateIndex:input_type -> google.firestore.admin.v1beta1.CreateIndexRequest
	6,  // 17: google.firestore.admin.v1beta1.FirestoreAdmin.ListIndexes:input_type -> google.firestore.admin.v1beta1.ListIndexesRequest
	5,  // 18: google.firestore.admin.v1beta1.FirestoreAdmin.GetIndex:input_type -> google.firestore.admin.v1beta1.GetIndexRequest
	7,  // 19: google.firestore.admin.v1beta1.FirestoreAdmin.DeleteIndex:input_type -> google.firestore.admin.v1beta1.DeleteIndexRequest
	9,  // 20: google.firestore.admin.v1beta1.FirestoreAdmin.ExportDocuments:input_type -> google.firestore.admin.v1beta1.ExportDocumentsRequest
	10, // 21: google.firestore.admin.v1beta1.FirestoreAdmin.ImportDocuments:input_type -> google.firestore.admin.v1beta1.ImportDocumentsRequest
	16, // 22: google.firestore.admin.v1beta1.FirestoreAdmin.CreateIndex:output_type -> google.longrunning.Operation
	8,  // 23: google.firestore.admin.v1beta1.FirestoreAdmin.ListIndexes:output_type -> google.firestore.admin.v1beta1.ListIndexesResponse
	15, // 24: google.firestore.admin.v1beta1.FirestoreAdmin.GetIndex:output_type -> google.firestore.admin.v1beta1.Index
	17, // 25: google.firestore.admin.v1beta1.FirestoreAdmin.DeleteIndex:output_type -> google.protobuf.Empty
	16, // 26: google.firestore.admin.v1beta1.FirestoreAdmin.ExportDocuments:output_type -> google.longrunning.Operation
	16, // 27: google.firestore.admin.v1beta1.FirestoreAdmin.ImportDocuments:output_type -> google.longrunning.Operation
	22, // [22:28] is the sub-list for method output_type
	16, // [16:22] is the sub-list for method input_type
	16, // [16:16] is the sub-list for extension type_name
	16, // [16:16] is the sub-list for extension extendee
	0,  // [0:16] is the sub-list for field type_name
}

func init() { file_google_firestore_admin_v1beta1_firestore_admin_proto_init() }
func file_google_firestore_admin_v1beta1_firestore_admin_proto_init() {
	if File_google_firestore_admin_v1beta1_firestore_admin_proto != nil {
		return
	}
	file_google_firestore_admin_v1beta1_index_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_firestore_admin_v1beta1_firestore_admin_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IndexOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_admin_v1beta1_firestore_admin_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Progress); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_admin_v1beta1_firestore_admin_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateIndexRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_admin_v1beta1_firestore_admin_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetIndexRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_admin_v1beta1_firestore_admin_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListIndexesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_admin_v1beta1_firestore_admin_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteIndexRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_admin_v1beta1_firestore_admin_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListIndexesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_admin_v1beta1_firestore_admin_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportDocumentsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_admin_v1beta1_firestore_admin_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportDocumentsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_admin_v1beta1_firestore_admin_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportDocumentsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_admin_v1beta1_firestore_admin_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportDocumentsMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_firestore_admin_v1beta1_firestore_admin_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportDocumentsMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_firestore_admin_v1beta1_firestore_admin_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_firestore_admin_v1beta1_firestore_admin_proto_goTypes,
		DependencyIndexes: file_google_firestore_admin_v1beta1_firestore_admin_proto_depIdxs,
		EnumInfos:         file_google_firestore_admin_v1beta1_firestore_admin_proto_enumTypes,
		MessageInfos:      file_google_firestore_admin_v1beta1_firestore_admin_proto_msgTypes,
	}.Build()
	File_google_firestore_admin_v1beta1_firestore_admin_proto = out.File
	file_google_firestore_admin_v1beta1_firestore_admin_proto_rawDesc = nil
	file_google_firestore_admin_v1beta1_firestore_admin_proto_goTypes = nil
	file_google_firestore_admin_v1beta1_firestore_admin_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// FirestoreAdminClient is the client API for FirestoreAdmin service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type FirestoreAdminClient interface {
	// Creates the specified index.
	// A newly created index's initial state is `CREATING`. On completion of the
	// returned [google.longrunning.Operation][google.longrunning.Operation], the state will be `READY`.
	// If the index already exists, the call will return an `ALREADY_EXISTS`
	// status.
	//
	// During creation, the process could result in an error, in which case the
	// index will move to the `ERROR` state. The process can be recovered by
	// fixing the data that caused the error, removing the index with
	// [delete][google.firestore.admin.v1beta1.FirestoreAdmin.DeleteIndex], then re-creating the index with
	// [create][google.firestore.admin.v1beta1.FirestoreAdmin.CreateIndex].
	//
	// Indexes with a single field cannot be created.
	CreateIndex(ctx context.Context, in *CreateIndexRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Lists the indexes that match the specified filters.
	ListIndexes(ctx context.Context, in *ListIndexesRequest, opts ...grpc.CallOption) (*ListIndexesResponse, error)
	// Gets an index.
	GetIndex(ctx context.Context, in *GetIndexRequest, opts ...grpc.CallOption) (*Index, error)
	// Deletes an index.
	DeleteIndex(ctx context.Context, in *DeleteIndexRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Exports a copy of all or a subset of documents from Google Cloud Firestore
	// to another storage system, such as Google Cloud Storage. Recent updates to
	// documents may not be reflected in the export. The export occurs in the
	// background and its progress can be monitored and managed via the
	// Operation resource that is created. The output of an export may only be
	// used once the associated operation is done. If an export operation is
	// cancelled before completion it may leave partial data behind in Google
	// Cloud Storage.
	ExportDocuments(ctx context.Context, in *ExportDocumentsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Imports documents into Google Cloud Firestore. Existing documents with the
	// same name are overwritten. The import occurs in the background and its
	// progress can be monitored and managed via the Operation resource that is
	// created. If an ImportDocuments operation is cancelled, it is possible
	// that a subset of the data has already been imported to Cloud Firestore.
	ImportDocuments(ctx context.Context, in *ImportDocumentsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type firestoreAdminClient struct {
	cc grpc.ClientConnInterface
}

func NewFirestoreAdminClient(cc grpc.ClientConnInterface) FirestoreAdminClient {
	return &firestoreAdminClient{cc}
}

func (c *firestoreAdminClient) CreateIndex(ctx context.Context, in *CreateIndexRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.firestore.admin.v1beta1.FirestoreAdmin/CreateIndex", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreAdminClient) ListIndexes(ctx context.Context, in *ListIndexesRequest, opts ...grpc.CallOption) (*ListIndexesResponse, error) {
	out := new(ListIndexesResponse)
	err := c.cc.Invoke(ctx, "/google.firestore.admin.v1beta1.FirestoreAdmin/ListIndexes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreAdminClient) GetIndex(ctx context.Context, in *GetIndexRequest, opts ...grpc.CallOption) (*Index, error) {
	out := new(Index)
	err := c.cc.Invoke(ctx, "/google.firestore.admin.v1beta1.FirestoreAdmin/GetIndex", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreAdminClient) DeleteIndex(ctx context.Context, in *DeleteIndexRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.firestore.admin.v1beta1.FirestoreAdmin/DeleteIndex", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreAdminClient) ExportDocuments(ctx context.Context, in *ExportDocumentsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.firestore.admin.v1beta1.FirestoreAdmin/ExportDocuments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreAdminClient) ImportDocuments(ctx context.Context, in *ImportDocumentsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.firestore.admin.v1beta1.FirestoreAdmin/ImportDocuments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// FirestoreAdminServer is the server API for FirestoreAdmin service.
type FirestoreAdminServer interface {
	// Creates the specified index.
	// A newly created index's initial state is `CREATING`. On completion of the
	// returned [google.longrunning.Operation][google.longrunning.Operation], the state will be `READY`.
	// If the index already exists, the call will return an `ALREADY_EXISTS`
	// status.
	//
	// During creation, the process could result in an error, in which case the
	// index will move to the `ERROR` state. The process can be recovered by
	// fixing the data that caused the error, removing the index with
	// [delete][google.firestore.admin.v1beta1.FirestoreAdmin.DeleteIndex], then re-creating the index with
	// [create][google.firestore.admin.v1beta1.FirestoreAdmin.CreateIndex].
	//
	// Indexes with a single field cannot be created.
	CreateIndex(context.Context, *CreateIndexRequest) (*longrunning.Operation, error)
	// Lists the indexes that match the specified filters.
	ListIndexes(context.Context, *ListIndexesRequest) (*ListIndexesResponse, error)
	// Gets an index.
	GetIndex(context.Context, *GetIndexRequest) (*Index, error)
	// Deletes an index.
	DeleteIndex(context.Context, *DeleteIndexRequest) (*emptypb.Empty, error)
	// Exports a copy of all or a subset of documents from Google Cloud Firestore
	// to another storage system, such as Google Cloud Storage. Recent updates to
	// documents may not be reflected in the export. The export occurs in the
	// background and its progress can be monitored and managed via the
	// Operation resource that is created. The output of an export may only be
	// used once the associated operation is done. If an export operation is
	// cancelled before completion it may leave partial data behind in Google
	// Cloud Storage.
	ExportDocuments(context.Context, *ExportDocumentsRequest) (*longrunning.Operation, error)
	// Imports documents into Google Cloud Firestore. Existing documents with the
	// same name are overwritten. The import occurs in the background and its
	// progress can be monitored and managed via the Operation resource that is
	// created. If an ImportDocuments operation is cancelled, it is possible
	// that a subset of the data has already been imported to Cloud Firestore.
	ImportDocuments(context.Context, *ImportDocumentsRequest) (*longrunning.Operation, error)
}

// UnimplementedFirestoreAdminServer can be embedded to have forward compatible implementations.
type UnimplementedFirestoreAdminServer struct {
}

func (*UnimplementedFirestoreAdminServer) CreateIndex(context.Context, *CreateIndexRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateIndex not implemented")
}
func (*UnimplementedFirestoreAdminServer) ListIndexes(context.Context, *ListIndexesRequest) (*ListIndexesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListIndexes not implemented")
}
func (*UnimplementedFirestoreAdminServer) GetIndex(context.Context, *GetIndexRequest) (*Index, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIndex not implemented")
}
func (*UnimplementedFirestoreAdminServer) DeleteIndex(context.Context, *DeleteIndexRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteIndex not implemented")
}
func (*UnimplementedFirestoreAdminServer) ExportDocuments(context.Context, *ExportDocumentsRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportDocuments not implemented")
}
func (*UnimplementedFirestoreAdminServer) ImportDocuments(context.Context, *ImportDocumentsRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportDocuments not implemented")
}

func RegisterFirestoreAdminServer(s *grpc.Server, srv FirestoreAdminServer) {
	s.RegisterService(&_FirestoreAdmin_serviceDesc, srv)
}

func _FirestoreAdmin_CreateIndex_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateIndexRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreAdminServer).CreateIndex(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.firestore.admin.v1beta1.FirestoreAdmin/CreateIndex",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreAdminServer).CreateIndex(ctx, req.(*CreateIndexRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirestoreAdmin_ListIndexes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListIndexesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreAdminServer).ListIndexes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.firestore.admin.v1beta1.FirestoreAdmin/ListIndexes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreAdminServer).ListIndexes(ctx, req.(*ListIndexesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirestoreAdmin_GetIndex_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIndexRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreAdminServer).GetIndex(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.firestore.admin.v1beta1.FirestoreAdmin/GetIndex",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreAdminServer).GetIndex(ctx, req.(*GetIndexRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirestoreAdmin_DeleteIndex_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteIndexRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreAdminServer).DeleteIndex(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.firestore.admin.v1beta1.FirestoreAdmin/DeleteIndex",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreAdminServer).DeleteIndex(ctx, req.(*DeleteIndexRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirestoreAdmin_ExportDocuments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportDocumentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreAdminServer).ExportDocuments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.firestore.admin.v1beta1.FirestoreAdmin/ExportDocuments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreAdminServer).ExportDocuments(ctx, req.(*ExportDocumentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirestoreAdmin_ImportDocuments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportDocumentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreAdminServer).ImportDocuments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.firestore.admin.v1beta1.FirestoreAdmin/ImportDocuments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreAdminServer).ImportDocuments(ctx, req.(*ImportDocumentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _FirestoreAdmin_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.firestore.admin.v1beta1.FirestoreAdmin",
	HandlerType: (*FirestoreAdminServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateIndex",
			Handler:    _FirestoreAdmin_CreateIndex_Handler,
		},
		{
			MethodName: "ListIndexes",
			Handler:    _FirestoreAdmin_ListIndexes_Handler,
		},
		{
			MethodName: "GetIndex",
			Handler:    _FirestoreAdmin_GetIndex_Handler,
		},
		{
			MethodName: "DeleteIndex",
			Handler:    _FirestoreAdmin_DeleteIndex_Handler,
		},
		{
			MethodName: "ExportDocuments",
			Handler:    _FirestoreAdmin_ExportDocuments_Handler,
		},
		{
			MethodName: "ImportDocuments",
			Handler:    _FirestoreAdmin_ImportDocuments_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/firestore/admin/v1beta1/firestore_admin.proto",
}
