// automatically generated by stateify.

package kernel

import (
	"gvisor.dev/gvisor/pkg/bpf"
	"gvisor.dev/gvisor/pkg/state"
	"gvisor.dev/gvisor/pkg/tcpip"
)

func (c *Cgroup) StateTypeName() string {
	return "pkg/sentry/kernel.Cgroup"
}

func (c *Cgroup) StateFields() []string {
	return []string{
		"Dentry",
		"CgroupImpl",
	}
}

func (c *Cgroup) beforeSave() {}

// +checklocksignore
func (c *Cgroup) StateSave(stateSinkObject state.Sink) {
	c.beforeSave()
	stateSinkObject.Save(0, &c.Dentry)
	stateSinkObject.Save(1, &c.CgroupImpl)
}

func (c *Cgroup) afterLoad() {}

// +checklocksignore
func (c *Cgroup) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &c.Dentry)
	stateSourceObject.Load(1, &c.CgroupImpl)
}

func (h *hierarchy) StateTypeName() string {
	return "pkg/sentry/kernel.hierarchy"
}

func (h *hierarchy) StateFields() []string {
	return []string{
		"id",
		"name",
		"controllers",
		"fs",
	}
}

func (h *hierarchy) beforeSave() {}

// +checklocksignore
func (h *hierarchy) StateSave(stateSinkObject state.Sink) {
	h.beforeSave()
	stateSinkObject.Save(0, &h.id)
	stateSinkObject.Save(1, &h.name)
	stateSinkObject.Save(2, &h.controllers)
	stateSinkObject.Save(3, &h.fs)
}

func (h *hierarchy) afterLoad() {}

// +checklocksignore
func (h *hierarchy) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &h.id)
	stateSourceObject.Load(1, &h.name)
	stateSourceObject.Load(2, &h.controllers)
	stateSourceObject.Load(3, &h.fs)
}

func (r *CgroupRegistry) StateTypeName() string {
	return "pkg/sentry/kernel.CgroupRegistry"
}

func (r *CgroupRegistry) StateFields() []string {
	return []string{
		"lastHierarchyID",
		"lastCgroupID",
		"controllers",
		"hierarchies",
		"hierarchiesByName",
		"cgroups",
	}
}

func (r *CgroupRegistry) beforeSave() {}

// +checklocksignore
func (r *CgroupRegistry) StateSave(stateSinkObject state.Sink) {
	r.beforeSave()
	stateSinkObject.Save(0, &r.lastHierarchyID)
	stateSinkObject.Save(1, &r.lastCgroupID)
	stateSinkObject.Save(2, &r.controllers)
	stateSinkObject.Save(3, &r.hierarchies)
	stateSinkObject.Save(4, &r.hierarchiesByName)
	stateSinkObject.Save(5, &r.cgroups)
}

func (r *CgroupRegistry) afterLoad() {}

// +checklocksignore
func (r *CgroupRegistry) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &r.lastHierarchyID)
	stateSourceObject.Load(1, &r.lastCgroupID)
	stateSourceObject.Load(2, &r.controllers)
	stateSourceObject.Load(3, &r.hierarchies)
	stateSourceObject.Load(4, &r.hierarchiesByName)
	stateSourceObject.Load(5, &r.cgroups)
}

func (f *FDFlags) StateTypeName() string {
	return "pkg/sentry/kernel.FDFlags"
}

func (f *FDFlags) StateFields() []string {
	return []string{
		"CloseOnExec",
	}
}

func (f *FDFlags) beforeSave() {}

// +checklocksignore
func (f *FDFlags) StateSave(stateSinkObject state.Sink) {
	f.beforeSave()
	stateSinkObject.Save(0, &f.CloseOnExec)
}

func (f *FDFlags) afterLoad() {}

// +checklocksignore
func (f *FDFlags) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &f.CloseOnExec)
}

func (d *descriptor) StateTypeName() string {
	return "pkg/sentry/kernel.descriptor"
}

func (d *descriptor) StateFields() []string {
	return []string{
		"file",
		"flags",
	}
}

func (d *descriptor) beforeSave() {}

// +checklocksignore
func (d *descriptor) StateSave(stateSinkObject state.Sink) {
	d.beforeSave()
	stateSinkObject.Save(0, &d.file)
	stateSinkObject.Save(1, &d.flags)
}

func (d *descriptor) afterLoad() {}

// +checklocksignore
func (d *descriptor) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &d.file)
	stateSourceObject.Load(1, &d.flags)
}

func (f *FDTable) StateTypeName() string {
	return "pkg/sentry/kernel.FDTable"
}

func (f *FDTable) StateFields() []string {
	return []string{
		"FDTableRefs",
		"k",
		"descriptorTable",
	}
}

func (f *FDTable) beforeSave() {}

// +checklocksignore
func (f *FDTable) StateSave(stateSinkObject state.Sink) {
	f.beforeSave()
	var descriptorTableValue map[int32]descriptor
	descriptorTableValue = f.saveDescriptorTable()
	stateSinkObject.SaveValue(2, descriptorTableValue)
	stateSinkObject.Save(0, &f.FDTableRefs)
	stateSinkObject.Save(1, &f.k)
}

func (f *FDTable) afterLoad() {}

// +checklocksignore
func (f *FDTable) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &f.FDTableRefs)
	stateSourceObject.Load(1, &f.k)
	stateSourceObject.LoadValue(2, new(map[int32]descriptor), func(y any) { f.loadDescriptorTable(y.(map[int32]descriptor)) })
}

func (r *FDTableRefs) StateTypeName() string {
	return "pkg/sentry/kernel.FDTableRefs"
}

func (r *FDTableRefs) StateFields() []string {
	return []string{
		"refCount",
	}
}

func (r *FDTableRefs) beforeSave() {}

// +checklocksignore
func (r *FDTableRefs) StateSave(stateSinkObject state.Sink) {
	r.beforeSave()
	stateSinkObject.Save(0, &r.refCount)
}

// +checklocksignore
func (r *FDTableRefs) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &r.refCount)
	stateSourceObject.AfterLoad(r.afterLoad)
}

func (f *FSContext) StateTypeName() string {
	return "pkg/sentry/kernel.FSContext"
}

func (f *FSContext) StateFields() []string {
	return []string{
		"FSContextRefs",
		"root",
		"cwd",
		"umask",
	}
}

func (f *FSContext) beforeSave() {}

// +checklocksignore
func (f *FSContext) StateSave(stateSinkObject state.Sink) {
	f.beforeSave()
	stateSinkObject.Save(0, &f.FSContextRefs)
	stateSinkObject.Save(1, &f.root)
	stateSinkObject.Save(2, &f.cwd)
	stateSinkObject.Save(3, &f.umask)
}

func (f *FSContext) afterLoad() {}

// +checklocksignore
func (f *FSContext) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &f.FSContextRefs)
	stateSourceObject.Load(1, &f.root)
	stateSourceObject.Load(2, &f.cwd)
	stateSourceObject.Load(3, &f.umask)
}

func (r *FSContextRefs) StateTypeName() string {
	return "pkg/sentry/kernel.FSContextRefs"
}

func (r *FSContextRefs) StateFields() []string {
	return []string{
		"refCount",
	}
}

func (r *FSContextRefs) beforeSave() {}

// +checklocksignore
func (r *FSContextRefs) StateSave(stateSinkObject state.Sink) {
	r.beforeSave()
	stateSinkObject.Save(0, &r.refCount)
}

// +checklocksignore
func (r *FSContextRefs) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &r.refCount)
	stateSourceObject.AfterLoad(r.afterLoad)
}

func (i *IPCNamespace) StateTypeName() string {
	return "pkg/sentry/kernel.IPCNamespace"
}

func (i *IPCNamespace) StateFields() []string {
	return []string{
		"inode",
		"userNS",
		"queues",
		"semaphores",
		"shms",
		"posixQueues",
	}
}

func (i *IPCNamespace) beforeSave() {}

// +checklocksignore
func (i *IPCNamespace) StateSave(stateSinkObject state.Sink) {
	i.beforeSave()
	stateSinkObject.Save(0, &i.inode)
	stateSinkObject.Save(1, &i.userNS)
	stateSinkObject.Save(2, &i.queues)
	stateSinkObject.Save(3, &i.semaphores)
	stateSinkObject.Save(4, &i.shms)
	stateSinkObject.Save(5, &i.posixQueues)
}

func (i *IPCNamespace) afterLoad() {}

// +checklocksignore
func (i *IPCNamespace) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &i.inode)
	stateSourceObject.Load(1, &i.userNS)
	stateSourceObject.Load(2, &i.queues)
	stateSourceObject.Load(3, &i.semaphores)
	stateSourceObject.Load(4, &i.shms)
	stateSourceObject.Load(5, &i.posixQueues)
}

func (uc *userCounters) StateTypeName() string {
	return "pkg/sentry/kernel.userCounters"
}

func (uc *userCounters) StateFields() []string {
	return []string{
		"uid",
		"rlimitNProc",
	}
}

func (uc *userCounters) beforeSave() {}

// +checklocksignore
func (uc *userCounters) StateSave(stateSinkObject state.Sink) {
	uc.beforeSave()
	stateSinkObject.Save(0, &uc.uid)
	stateSinkObject.Save(1, &uc.rlimitNProc)
}

func (uc *userCounters) afterLoad() {}

// +checklocksignore
func (uc *userCounters) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &uc.uid)
	stateSourceObject.Load(1, &uc.rlimitNProc)
}

func (k *Kernel) StateTypeName() string {
	return "pkg/sentry/kernel.Kernel"
}

func (k *Kernel) StateFields() []string {
	return []string{
		"featureSet",
		"timekeeper",
		"tasks",
		"rootUserNamespace",
		"rootNetworkNamespace",
		"applicationCores",
		"useHostCores",
		"extraAuxv",
		"vdso",
		"rootUTSNamespace",
		"rootIPCNamespace",
		"futexes",
		"globalInit",
		"syslog",
		"runningTasks",
		"cpuClock",
		"cpuClockTickerRunning",
		"uniqueID",
		"nextInotifyCookie",
		"netlinkPorts",
		"danglingEndpoints",
		"sockets",
		"nextSocketRecord",
		"SpecialOpts",
		"vfs",
		"hostMount",
		"pipeMount",
		"nsfsMount",
		"shmMount",
		"socketMount",
		"sysVShmDevID",
		"SleepForAddressSpaceActivation",
		"ptraceExceptions",
		"YAMAPtraceScope",
		"cgroupRegistry",
		"userCountersMap",
	}
}

func (k *Kernel) beforeSave() {}

// +checklocksignore
func (k *Kernel) StateSave(stateSinkObject state.Sink) {
	k.beforeSave()
	var danglingEndpointsValue []tcpip.Endpoint
	danglingEndpointsValue = k.saveDanglingEndpoints()
	stateSinkObject.SaveValue(20, danglingEndpointsValue)
	stateSinkObject.Save(0, &k.featureSet)
	stateSinkObject.Save(1, &k.timekeeper)
	stateSinkObject.Save(2, &k.tasks)
	stateSinkObject.Save(3, &k.rootUserNamespace)
	stateSinkObject.Save(4, &k.rootNetworkNamespace)
	stateSinkObject.Save(5, &k.applicationCores)
	stateSinkObject.Save(6, &k.useHostCores)
	stateSinkObject.Save(7, &k.extraAuxv)
	stateSinkObject.Save(8, &k.vdso)
	stateSinkObject.Save(9, &k.rootUTSNamespace)
	stateSinkObject.Save(10, &k.rootIPCNamespace)
	stateSinkObject.Save(11, &k.futexes)
	stateSinkObject.Save(12, &k.globalInit)
	stateSinkObject.Save(13, &k.syslog)
	stateSinkObject.Save(14, &k.runningTasks)
	stateSinkObject.Save(15, &k.cpuClock)
	stateSinkObject.Save(16, &k.cpuClockTickerRunning)
	stateSinkObject.Save(17, &k.uniqueID)
	stateSinkObject.Save(18, &k.nextInotifyCookie)
	stateSinkObject.Save(19, &k.netlinkPorts)
	stateSinkObject.Save(21, &k.sockets)
	stateSinkObject.Save(22, &k.nextSocketRecord)
	stateSinkObject.Save(23, &k.SpecialOpts)
	stateSinkObject.Save(24, &k.vfs)
	stateSinkObject.Save(25, &k.hostMount)
	stateSinkObject.Save(26, &k.pipeMount)
	stateSinkObject.Save(27, &k.nsfsMount)
	stateSinkObject.Save(28, &k.shmMount)
	stateSinkObject.Save(29, &k.socketMount)
	stateSinkObject.Save(30, &k.sysVShmDevID)
	stateSinkObject.Save(31, &k.SleepForAddressSpaceActivation)
	stateSinkObject.Save(32, &k.ptraceExceptions)
	stateSinkObject.Save(33, &k.YAMAPtraceScope)
	stateSinkObject.Save(34, &k.cgroupRegistry)
	stateSinkObject.Save(35, &k.userCountersMap)
}

func (k *Kernel) afterLoad() {}

// +checklocksignore
func (k *Kernel) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &k.featureSet)
	stateSourceObject.Load(1, &k.timekeeper)
	stateSourceObject.Load(2, &k.tasks)
	stateSourceObject.Load(3, &k.rootUserNamespace)
	stateSourceObject.Load(4, &k.rootNetworkNamespace)
	stateSourceObject.Load(5, &k.applicationCores)
	stateSourceObject.Load(6, &k.useHostCores)
	stateSourceObject.Load(7, &k.extraAuxv)
	stateSourceObject.Load(8, &k.vdso)
	stateSourceObject.Load(9, &k.rootUTSNamespace)
	stateSourceObject.Load(10, &k.rootIPCNamespace)
	stateSourceObject.Load(11, &k.futexes)
	stateSourceObject.Load(12, &k.globalInit)
	stateSourceObject.Load(13, &k.syslog)
	stateSourceObject.Load(14, &k.runningTasks)
	stateSourceObject.Load(15, &k.cpuClock)
	stateSourceObject.Load(16, &k.cpuClockTickerRunning)
	stateSourceObject.Load(17, &k.uniqueID)
	stateSourceObject.Load(18, &k.nextInotifyCookie)
	stateSourceObject.Load(19, &k.netlinkPorts)
	stateSourceObject.Load(21, &k.sockets)
	stateSourceObject.Load(22, &k.nextSocketRecord)
	stateSourceObject.Load(23, &k.SpecialOpts)
	stateSourceObject.Load(24, &k.vfs)
	stateSourceObject.Load(25, &k.hostMount)
	stateSourceObject.Load(26, &k.pipeMount)
	stateSourceObject.Load(27, &k.nsfsMount)
	stateSourceObject.Load(28, &k.shmMount)
	stateSourceObject.Load(29, &k.socketMount)
	stateSourceObject.Load(30, &k.sysVShmDevID)
	stateSourceObject.Load(31, &k.SleepForAddressSpaceActivation)
	stateSourceObject.Load(32, &k.ptraceExceptions)
	stateSourceObject.Load(33, &k.YAMAPtraceScope)
	stateSourceObject.Load(34, &k.cgroupRegistry)
	stateSourceObject.Load(35, &k.userCountersMap)
	stateSourceObject.LoadValue(20, new([]tcpip.Endpoint), func(y any) { k.loadDanglingEndpoints(y.([]tcpip.Endpoint)) })
}

func (s *SocketRecord) StateTypeName() string {
	return "pkg/sentry/kernel.SocketRecord"
}

func (s *SocketRecord) StateFields() []string {
	return []string{
		"k",
		"Sock",
		"ID",
	}
}

func (s *SocketRecord) beforeSave() {}

// +checklocksignore
func (s *SocketRecord) StateSave(stateSinkObject state.Sink) {
	s.beforeSave()
	stateSinkObject.Save(0, &s.k)
	stateSinkObject.Save(1, &s.Sock)
	stateSinkObject.Save(2, &s.ID)
}

func (s *SocketRecord) afterLoad() {}

// +checklocksignore
func (s *SocketRecord) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &s.k)
	stateSourceObject.Load(1, &s.Sock)
	stateSourceObject.Load(2, &s.ID)
}

func (p *pendingSignals) StateTypeName() string {
	return "pkg/sentry/kernel.pendingSignals"
}

func (p *pendingSignals) StateFields() []string {
	return []string{
		"signals",
	}
}

func (p *pendingSignals) beforeSave() {}

// +checklocksignore
func (p *pendingSignals) StateSave(stateSinkObject state.Sink) {
	p.beforeSave()
	var signalsValue []savedPendingSignal
	signalsValue = p.saveSignals()
	stateSinkObject.SaveValue(0, signalsValue)
}

func (p *pendingSignals) afterLoad() {}

// +checklocksignore
func (p *pendingSignals) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.LoadValue(0, new([]savedPendingSignal), func(y any) { p.loadSignals(y.([]savedPendingSignal)) })
}

func (p *pendingSignalQueue) StateTypeName() string {
	return "pkg/sentry/kernel.pendingSignalQueue"
}

func (p *pendingSignalQueue) StateFields() []string {
	return []string{
		"pendingSignalList",
		"length",
	}
}

func (p *pendingSignalQueue) beforeSave() {}

// +checklocksignore
func (p *pendingSignalQueue) StateSave(stateSinkObject state.Sink) {
	p.beforeSave()
	stateSinkObject.Save(0, &p.pendingSignalList)
	stateSinkObject.Save(1, &p.length)
}

func (p *pendingSignalQueue) afterLoad() {}

// +checklocksignore
func (p *pendingSignalQueue) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &p.pendingSignalList)
	stateSourceObject.Load(1, &p.length)
}

func (p *pendingSignal) StateTypeName() string {
	return "pkg/sentry/kernel.pendingSignal"
}

func (p *pendingSignal) StateFields() []string {
	return []string{
		"pendingSignalEntry",
		"SignalInfo",
		"timer",
	}
}

func (p *pendingSignal) beforeSave() {}

// +checklocksignore
func (p *pendingSignal) StateSave(stateSinkObject state.Sink) {
	p.beforeSave()
	stateSinkObject.Save(0, &p.pendingSignalEntry)
	stateSinkObject.Save(1, &p.SignalInfo)
	stateSinkObject.Save(2, &p.timer)
}

func (p *pendingSignal) afterLoad() {}

// +checklocksignore
func (p *pendingSignal) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &p.pendingSignalEntry)
	stateSourceObject.Load(1, &p.SignalInfo)
	stateSourceObject.Load(2, &p.timer)
}

func (l *pendingSignalList) StateTypeName() string {
	return "pkg/sentry/kernel.pendingSignalList"
}

func (l *pendingSignalList) StateFields() []string {
	return []string{
		"head",
		"tail",
	}
}

func (l *pendingSignalList) beforeSave() {}

// +checklocksignore
func (l *pendingSignalList) StateSave(stateSinkObject state.Sink) {
	l.beforeSave()
	stateSinkObject.Save(0, &l.head)
	stateSinkObject.Save(1, &l.tail)
}

func (l *pendingSignalList) afterLoad() {}

// +checklocksignore
func (l *pendingSignalList) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &l.head)
	stateSourceObject.Load(1, &l.tail)
}

func (e *pendingSignalEntry) StateTypeName() string {
	return "pkg/sentry/kernel.pendingSignalEntry"
}

func (e *pendingSignalEntry) StateFields() []string {
	return []string{
		"next",
		"prev",
	}
}

func (e *pendingSignalEntry) beforeSave() {}

// +checklocksignore
func (e *pendingSignalEntry) StateSave(stateSinkObject state.Sink) {
	e.beforeSave()
	stateSinkObject.Save(0, &e.next)
	stateSinkObject.Save(1, &e.prev)
}

func (e *pendingSignalEntry) afterLoad() {}

// +checklocksignore
func (e *pendingSignalEntry) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &e.next)
	stateSourceObject.Load(1, &e.prev)
}

func (s *savedPendingSignal) StateTypeName() string {
	return "pkg/sentry/kernel.savedPendingSignal"
}

func (s *savedPendingSignal) StateFields() []string {
	return []string{
		"si",
		"timer",
	}
}

func (s *savedPendingSignal) beforeSave() {}

// +checklocksignore
func (s *savedPendingSignal) StateSave(stateSinkObject state.Sink) {
	s.beforeSave()
	stateSinkObject.Save(0, &s.si)
	stateSinkObject.Save(1, &s.timer)
}

func (s *savedPendingSignal) afterLoad() {}

// +checklocksignore
func (s *savedPendingSignal) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &s.si)
	stateSourceObject.Load(1, &s.timer)
}

func (it *IntervalTimer) StateTypeName() string {
	return "pkg/sentry/kernel.IntervalTimer"
}

func (it *IntervalTimer) StateFields() []string {
	return []string{
		"timer",
		"target",
		"signo",
		"id",
		"sigval",
		"group",
		"sigpending",
		"sigorphan",
		"overrunCur",
		"overrunLast",
	}
}

func (it *IntervalTimer) beforeSave() {}

// +checklocksignore
func (it *IntervalTimer) StateSave(stateSinkObject state.Sink) {
	it.beforeSave()
	stateSinkObject.Save(0, &it.timer)
	stateSinkObject.Save(1, &it.target)
	stateSinkObject.Save(2, &it.signo)
	stateSinkObject.Save(3, &it.id)
	stateSinkObject.Save(4, &it.sigval)
	stateSinkObject.Save(5, &it.group)
	stateSinkObject.Save(6, &it.sigpending)
	stateSinkObject.Save(7, &it.sigorphan)
	stateSinkObject.Save(8, &it.overrunCur)
	stateSinkObject.Save(9, &it.overrunLast)
}

func (it *IntervalTimer) afterLoad() {}

// +checklocksignore
func (it *IntervalTimer) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &it.timer)
	stateSourceObject.Load(1, &it.target)
	stateSourceObject.Load(2, &it.signo)
	stateSourceObject.Load(3, &it.id)
	stateSourceObject.Load(4, &it.sigval)
	stateSourceObject.Load(5, &it.group)
	stateSourceObject.Load(6, &it.sigpending)
	stateSourceObject.Load(7, &it.sigorphan)
	stateSourceObject.Load(8, &it.overrunCur)
	stateSourceObject.Load(9, &it.overrunLast)
}

func (l *processGroupList) StateTypeName() string {
	return "pkg/sentry/kernel.processGroupList"
}

func (l *processGroupList) StateFields() []string {
	return []string{
		"head",
		"tail",
	}
}

func (l *processGroupList) beforeSave() {}

// +checklocksignore
func (l *processGroupList) StateSave(stateSinkObject state.Sink) {
	l.beforeSave()
	stateSinkObject.Save(0, &l.head)
	stateSinkObject.Save(1, &l.tail)
}

func (l *processGroupList) afterLoad() {}

// +checklocksignore
func (l *processGroupList) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &l.head)
	stateSourceObject.Load(1, &l.tail)
}

func (e *processGroupEntry) StateTypeName() string {
	return "pkg/sentry/kernel.processGroupEntry"
}

func (e *processGroupEntry) StateFields() []string {
	return []string{
		"next",
		"prev",
	}
}

func (e *processGroupEntry) beforeSave() {}

// +checklocksignore
func (e *processGroupEntry) StateSave(stateSinkObject state.Sink) {
	e.beforeSave()
	stateSinkObject.Save(0, &e.next)
	stateSinkObject.Save(1, &e.prev)
}

func (e *processGroupEntry) afterLoad() {}

// +checklocksignore
func (e *processGroupEntry) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &e.next)
	stateSourceObject.Load(1, &e.prev)
}

func (r *ProcessGroupRefs) StateTypeName() string {
	return "pkg/sentry/kernel.ProcessGroupRefs"
}

func (r *ProcessGroupRefs) StateFields() []string {
	return []string{
		"refCount",
	}
}

func (r *ProcessGroupRefs) beforeSave() {}

// +checklocksignore
func (r *ProcessGroupRefs) StateSave(stateSinkObject state.Sink) {
	r.beforeSave()
	stateSinkObject.Save(0, &r.refCount)
}

// +checklocksignore
func (r *ProcessGroupRefs) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &r.refCount)
	stateSourceObject.AfterLoad(r.afterLoad)
}

func (p *ptraceOptions) StateTypeName() string {
	return "pkg/sentry/kernel.ptraceOptions"
}

func (p *ptraceOptions) StateFields() []string {
	return []string{
		"ExitKill",
		"SysGood",
		"TraceClone",
		"TraceExec",
		"TraceExit",
		"TraceFork",
		"TraceSeccomp",
		"TraceVfork",
		"TraceVforkDone",
	}
}

func (p *ptraceOptions) beforeSave() {}

// +checklocksignore
func (p *ptraceOptions) StateSave(stateSinkObject state.Sink) {
	p.beforeSave()
	stateSinkObject.Save(0, &p.ExitKill)
	stateSinkObject.Save(1, &p.SysGood)
	stateSinkObject.Save(2, &p.TraceClone)
	stateSinkObject.Save(3, &p.TraceExec)
	stateSinkObject.Save(4, &p.TraceExit)
	stateSinkObject.Save(5, &p.TraceFork)
	stateSinkObject.Save(6, &p.TraceSeccomp)
	stateSinkObject.Save(7, &p.TraceVfork)
	stateSinkObject.Save(8, &p.TraceVforkDone)
}

func (p *ptraceOptions) afterLoad() {}

// +checklocksignore
func (p *ptraceOptions) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &p.ExitKill)
	stateSourceObject.Load(1, &p.SysGood)
	stateSourceObject.Load(2, &p.TraceClone)
	stateSourceObject.Load(3, &p.TraceExec)
	stateSourceObject.Load(4, &p.TraceExit)
	stateSourceObject.Load(5, &p.TraceFork)
	stateSourceObject.Load(6, &p.TraceSeccomp)
	stateSourceObject.Load(7, &p.TraceVfork)
	stateSourceObject.Load(8, &p.TraceVforkDone)
}

func (s *ptraceStop) StateTypeName() string {
	return "pkg/sentry/kernel.ptraceStop"
}

func (s *ptraceStop) StateFields() []string {
	return []string{
		"frozen",
		"listen",
	}
}

func (s *ptraceStop) beforeSave() {}

// +checklocksignore
func (s *ptraceStop) StateSave(stateSinkObject state.Sink) {
	s.beforeSave()
	stateSinkObject.Save(0, &s.frozen)
	stateSinkObject.Save(1, &s.listen)
}

func (s *ptraceStop) afterLoad() {}

// +checklocksignore
func (s *ptraceStop) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &s.frozen)
	stateSourceObject.Load(1, &s.listen)
}

func (o *OldRSeqCriticalRegion) StateTypeName() string {
	return "pkg/sentry/kernel.OldRSeqCriticalRegion"
}

func (o *OldRSeqCriticalRegion) StateFields() []string {
	return []string{
		"CriticalSection",
		"Restart",
	}
}

func (o *OldRSeqCriticalRegion) beforeSave() {}

// +checklocksignore
func (o *OldRSeqCriticalRegion) StateSave(stateSinkObject state.Sink) {
	o.beforeSave()
	stateSinkObject.Save(0, &o.CriticalSection)
	stateSinkObject.Save(1, &o.Restart)
}

func (o *OldRSeqCriticalRegion) afterLoad() {}

// +checklocksignore
func (o *OldRSeqCriticalRegion) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &o.CriticalSection)
	stateSourceObject.Load(1, &o.Restart)
}

func (l *sessionList) StateTypeName() string {
	return "pkg/sentry/kernel.sessionList"
}

func (l *sessionList) StateFields() []string {
	return []string{
		"head",
		"tail",
	}
}

func (l *sessionList) beforeSave() {}

// +checklocksignore
func (l *sessionList) StateSave(stateSinkObject state.Sink) {
	l.beforeSave()
	stateSinkObject.Save(0, &l.head)
	stateSinkObject.Save(1, &l.tail)
}

func (l *sessionList) afterLoad() {}

// +checklocksignore
func (l *sessionList) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &l.head)
	stateSourceObject.Load(1, &l.tail)
}

func (e *sessionEntry) StateTypeName() string {
	return "pkg/sentry/kernel.sessionEntry"
}

func (e *sessionEntry) StateFields() []string {
	return []string{
		"next",
		"prev",
	}
}

func (e *sessionEntry) beforeSave() {}

// +checklocksignore
func (e *sessionEntry) StateSave(stateSinkObject state.Sink) {
	e.beforeSave()
	stateSinkObject.Save(0, &e.next)
	stateSinkObject.Save(1, &e.prev)
}

func (e *sessionEntry) afterLoad() {}

// +checklocksignore
func (e *sessionEntry) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &e.next)
	stateSourceObject.Load(1, &e.prev)
}

func (r *SessionRefs) StateTypeName() string {
	return "pkg/sentry/kernel.SessionRefs"
}

func (r *SessionRefs) StateFields() []string {
	return []string{
		"refCount",
	}
}

func (r *SessionRefs) beforeSave() {}

// +checklocksignore
func (r *SessionRefs) StateSave(stateSinkObject state.Sink) {
	r.beforeSave()
	stateSinkObject.Save(0, &r.refCount)
}

// +checklocksignore
func (r *SessionRefs) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &r.refCount)
	stateSourceObject.AfterLoad(r.afterLoad)
}

func (s *Session) StateTypeName() string {
	return "pkg/sentry/kernel.Session"
}

func (s *Session) StateFields() []string {
	return []string{
		"SessionRefs",
		"leader",
		"id",
		"foreground",
		"processGroups",
		"sessionEntry",
	}
}

func (s *Session) beforeSave() {}

// +checklocksignore
func (s *Session) StateSave(stateSinkObject state.Sink) {
	s.beforeSave()
	stateSinkObject.Save(0, &s.SessionRefs)
	stateSinkObject.Save(1, &s.leader)
	stateSinkObject.Save(2, &s.id)
	stateSinkObject.Save(3, &s.foreground)
	stateSinkObject.Save(4, &s.processGroups)
	stateSinkObject.Save(5, &s.sessionEntry)
}

func (s *Session) afterLoad() {}

// +checklocksignore
func (s *Session) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &s.SessionRefs)
	stateSourceObject.Load(1, &s.leader)
	stateSourceObject.Load(2, &s.id)
	stateSourceObject.Load(3, &s.foreground)
	stateSourceObject.Load(4, &s.processGroups)
	stateSourceObject.Load(5, &s.sessionEntry)
}

func (pg *ProcessGroup) StateTypeName() string {
	return "pkg/sentry/kernel.ProcessGroup"
}

func (pg *ProcessGroup) StateFields() []string {
	return []string{
		"refs",
		"originator",
		"id",
		"session",
		"ancestors",
		"processGroupEntry",
	}
}

func (pg *ProcessGroup) beforeSave() {}

// +checklocksignore
func (pg *ProcessGroup) StateSave(stateSinkObject state.Sink) {
	pg.beforeSave()
	stateSinkObject.Save(0, &pg.refs)
	stateSinkObject.Save(1, &pg.originator)
	stateSinkObject.Save(2, &pg.id)
	stateSinkObject.Save(3, &pg.session)
	stateSinkObject.Save(4, &pg.ancestors)
	stateSinkObject.Save(5, &pg.processGroupEntry)
}

func (pg *ProcessGroup) afterLoad() {}

// +checklocksignore
func (pg *ProcessGroup) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &pg.refs)
	stateSourceObject.Load(1, &pg.originator)
	stateSourceObject.Load(2, &pg.id)
	stateSourceObject.Load(3, &pg.session)
	stateSourceObject.Load(4, &pg.ancestors)
	stateSourceObject.Load(5, &pg.processGroupEntry)
}

func (sh *SignalHandlers) StateTypeName() string {
	return "pkg/sentry/kernel.SignalHandlers"
}

func (sh *SignalHandlers) StateFields() []string {
	return []string{
		"actions",
	}
}

func (sh *SignalHandlers) beforeSave() {}

// +checklocksignore
func (sh *SignalHandlers) StateSave(stateSinkObject state.Sink) {
	sh.beforeSave()
	stateSinkObject.Save(0, &sh.actions)
}

func (sh *SignalHandlers) afterLoad() {}

// +checklocksignore
func (sh *SignalHandlers) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &sh.actions)
}

func (s *syscallTableInfo) StateTypeName() string {
	return "pkg/sentry/kernel.syscallTableInfo"
}

func (s *syscallTableInfo) StateFields() []string {
	return []string{
		"OS",
		"Arch",
	}
}

func (s *syscallTableInfo) beforeSave() {}

// +checklocksignore
func (s *syscallTableInfo) StateSave(stateSinkObject state.Sink) {
	s.beforeSave()
	stateSinkObject.Save(0, &s.OS)
	stateSinkObject.Save(1, &s.Arch)
}

func (s *syscallTableInfo) afterLoad() {}

// +checklocksignore
func (s *syscallTableInfo) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &s.OS)
	stateSourceObject.Load(1, &s.Arch)
}

func (s *syslog) StateTypeName() string {
	return "pkg/sentry/kernel.syslog"
}

func (s *syslog) StateFields() []string {
	return []string{
		"msg",
	}
}

func (s *syslog) beforeSave() {}

// +checklocksignore
func (s *syslog) StateSave(stateSinkObject state.Sink) {
	s.beforeSave()
	stateSinkObject.Save(0, &s.msg)
}

func (s *syslog) afterLoad() {}

// +checklocksignore
func (s *syslog) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &s.msg)
}

func (t *Task) StateTypeName() string {
	return "pkg/sentry/kernel.Task"
}

func (t *Task) StateFields() []string {
	return []string{
		"taskNode",
		"runState",
		"taskWorkCount",
		"taskWork",
		"haveSyscallReturn",
		"gosched",
		"yieldCount",
		"pendingSignals",
		"signalMask",
		"realSignalMask",
		"haveSavedSignalMask",
		"savedSignalMask",
		"signalStack",
		"signalQueue",
		"groupStopPending",
		"groupStopAcknowledged",
		"trapStopPending",
		"trapNotifyPending",
		"stop",
		"exitStatus",
		"syscallRestartBlock",
		"k",
		"containerID",
		"image",
		"fsContext",
		"fdTable",
		"vforkParent",
		"exitState",
		"exitTracerNotified",
		"exitTracerAcked",
		"exitParentNotified",
		"exitParentAcked",
		"ptraceTracer",
		"ptraceTracees",
		"ptraceSeized",
		"ptraceOpts",
		"ptraceSyscallMode",
		"ptraceSinglestep",
		"ptraceCode",
		"ptraceSiginfo",
		"ptraceEventMsg",
		"ptraceYAMAExceptionAdded",
		"ioUsage",
		"creds",
		"utsns",
		"ipcns",
		"mountNamespace",
		"parentDeathSignal",
		"syscallFilters",
		"cleartid",
		"allowedCPUMask",
		"cpu",
		"niceness",
		"numaPolicy",
		"numaNodeMask",
		"netns",
		"rseqCPU",
		"oldRSeqCPUAddr",
		"rseqAddr",
		"rseqSignature",
		"robustList",
		"startTime",
		"kcov",
		"cgroups",
		"memCgID",
		"userCounters",
		"sessionKeyring",
	}
}

func (t *Task) beforeSave() {}

// +checklocksignore
func (t *Task) StateSave(stateSinkObject state.Sink) {
	t.beforeSave()
	var ptraceTracerValue *Task
	ptraceTracerValue = t.savePtraceTracer()
	stateSinkObject.SaveValue(32, ptraceTracerValue)
	var syscallFiltersValue []bpf.Program
	syscallFiltersValue = t.saveSyscallFilters()
	stateSinkObject.SaveValue(48, syscallFiltersValue)
	stateSinkObject.Save(0, &t.taskNode)
	stateSinkObject.Save(1, &t.runState)
	stateSinkObject.Save(2, &t.taskWorkCount)
	stateSinkObject.Save(3, &t.taskWork)
	stateSinkObject.Save(4, &t.haveSyscallReturn)
	stateSinkObject.Save(5, &t.gosched)
	stateSinkObject.Save(6, &t.yieldCount)
	stateSinkObject.Save(7, &t.pendingSignals)
	stateSinkObject.Save(8, &t.signalMask)
	stateSinkObject.Save(9, &t.realSignalMask)
	stateSinkObject.Save(10, &t.haveSavedSignalMask)
	stateSinkObject.Save(11, &t.savedSignalMask)
	stateSinkObject.Save(12, &t.signalStack)
	stateSinkObject.Save(13, &t.signalQueue)
	stateSinkObject.Save(14, &t.groupStopPending)
	stateSinkObject.Save(15, &t.groupStopAcknowledged)
	stateSinkObject.Save(16, &t.trapStopPending)
	stateSinkObject.Save(17, &t.trapNotifyPending)
	stateSinkObject.Save(18, &t.stop)
	stateSinkObject.Save(19, &t.exitStatus)
	stateSinkObject.Save(20, &t.syscallRestartBlock)
	stateSinkObject.Save(21, &t.k)
	stateSinkObject.Save(22, &t.containerID)
	stateSinkObject.Save(23, &t.image)
	stateSinkObject.Save(24, &t.fsContext)
	stateSinkObject.Save(25, &t.fdTable)
	stateSinkObject.Save(26, &t.vforkParent)
	stateSinkObject.Save(27, &t.exitState)
	stateSinkObject.Save(28, &t.exitTracerNotified)
	stateSinkObject.Save(29, &t.exitTracerAcked)
	stateSinkObject.Save(30, &t.exitParentNotified)
	stateSinkObject.Save(31, &t.exitParentAcked)
	stateSinkObject.Save(33, &t.ptraceTracees)
	stateSinkObject.Save(34, &t.ptraceSeized)
	stateSinkObject.Save(35, &t.ptraceOpts)
	stateSinkObject.Save(36, &t.ptraceSyscallMode)
	stateSinkObject.Save(37, &t.ptraceSinglestep)
	stateSinkObject.Save(38, &t.ptraceCode)
	stateSinkObject.Save(39, &t.ptraceSiginfo)
	stateSinkObject.Save(40, &t.ptraceEventMsg)
	stateSinkObject.Save(41, &t.ptraceYAMAExceptionAdded)
	stateSinkObject.Save(42, &t.ioUsage)
	stateSinkObject.Save(43, &t.creds)
	stateSinkObject.Save(44, &t.utsns)
	stateSinkObject.Save(45, &t.ipcns)
	stateSinkObject.Save(46, &t.mountNamespace)
	stateSinkObject.Save(47, &t.parentDeathSignal)
	stateSinkObject.Save(49, &t.cleartid)
	stateSinkObject.Save(50, &t.allowedCPUMask)
	stateSinkObject.Save(51, &t.cpu)
	stateSinkObject.Save(52, &t.niceness)
	stateSinkObject.Save(53, &t.numaPolicy)
	stateSinkObject.Save(54, &t.numaNodeMask)
	stateSinkObject.Save(55, &t.netns)
	stateSinkObject.Save(56, &t.rseqCPU)
	stateSinkObject.Save(57, &t.oldRSeqCPUAddr)
	stateSinkObject.Save(58, &t.rseqAddr)
	stateSinkObject.Save(59, &t.rseqSignature)
	stateSinkObject.Save(60, &t.robustList)
	stateSinkObject.Save(61, &t.startTime)
	stateSinkObject.Save(62, &t.kcov)
	stateSinkObject.Save(63, &t.cgroups)
	stateSinkObject.Save(64, &t.memCgID)
	stateSinkObject.Save(65, &t.userCounters)
	stateSinkObject.Save(66, &t.sessionKeyring)
}

// +checklocksignore
func (t *Task) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &t.taskNode)
	stateSourceObject.Load(1, &t.runState)
	stateSourceObject.Load(2, &t.taskWorkCount)
	stateSourceObject.Load(3, &t.taskWork)
	stateSourceObject.Load(4, &t.haveSyscallReturn)
	stateSourceObject.Load(5, &t.gosched)
	stateSourceObject.Load(6, &t.yieldCount)
	stateSourceObject.Load(7, &t.pendingSignals)
	stateSourceObject.Load(8, &t.signalMask)
	stateSourceObject.Load(9, &t.realSignalMask)
	stateSourceObject.Load(10, &t.haveSavedSignalMask)
	stateSourceObject.Load(11, &t.savedSignalMask)
	stateSourceObject.Load(12, &t.signalStack)
	stateSourceObject.Load(13, &t.signalQueue)
	stateSourceObject.Load(14, &t.groupStopPending)
	stateSourceObject.Load(15, &t.groupStopAcknowledged)
	stateSourceObject.Load(16, &t.trapStopPending)
	stateSourceObject.Load(17, &t.trapNotifyPending)
	stateSourceObject.Load(18, &t.stop)
	stateSourceObject.Load(19, &t.exitStatus)
	stateSourceObject.Load(20, &t.syscallRestartBlock)
	stateSourceObject.Load(21, &t.k)
	stateSourceObject.Load(22, &t.containerID)
	stateSourceObject.Load(23, &t.image)
	stateSourceObject.Load(24, &t.fsContext)
	stateSourceObject.Load(25, &t.fdTable)
	stateSourceObject.Load(26, &t.vforkParent)
	stateSourceObject.Load(27, &t.exitState)
	stateSourceObject.Load(28, &t.exitTracerNotified)
	stateSourceObject.Load(29, &t.exitTracerAcked)
	stateSourceObject.Load(30, &t.exitParentNotified)
	stateSourceObject.Load(31, &t.exitParentAcked)
	stateSourceObject.Load(33, &t.ptraceTracees)
	stateSourceObject.Load(34, &t.ptraceSeized)
	stateSourceObject.Load(35, &t.ptraceOpts)
	stateSourceObject.Load(36, &t.ptraceSyscallMode)
	stateSourceObject.Load(37, &t.ptraceSinglestep)
	stateSourceObject.Load(38, &t.ptraceCode)
	stateSourceObject.Load(39, &t.ptraceSiginfo)
	stateSourceObject.Load(40, &t.ptraceEventMsg)
	stateSourceObject.Load(41, &t.ptraceYAMAExceptionAdded)
	stateSourceObject.Load(42, &t.ioUsage)
	stateSourceObject.Load(43, &t.creds)
	stateSourceObject.Load(44, &t.utsns)
	stateSourceObject.Load(45, &t.ipcns)
	stateSourceObject.Load(46, &t.mountNamespace)
	stateSourceObject.Load(47, &t.parentDeathSignal)
	stateSourceObject.Load(49, &t.cleartid)
	stateSourceObject.Load(50, &t.allowedCPUMask)
	stateSourceObject.Load(51, &t.cpu)
	stateSourceObject.Load(52, &t.niceness)
	stateSourceObject.Load(53, &t.numaPolicy)
	stateSourceObject.Load(54, &t.numaNodeMask)
	stateSourceObject.Load(55, &t.netns)
	stateSourceObject.Load(56, &t.rseqCPU)
	stateSourceObject.Load(57, &t.oldRSeqCPUAddr)
	stateSourceObject.Load(58, &t.rseqAddr)
	stateSourceObject.Load(59, &t.rseqSignature)
	stateSourceObject.Load(60, &t.robustList)
	stateSourceObject.Load(61, &t.startTime)
	stateSourceObject.Load(62, &t.kcov)
	stateSourceObject.Load(63, &t.cgroups)
	stateSourceObject.Load(64, &t.memCgID)
	stateSourceObject.Load(65, &t.userCounters)
	stateSourceObject.Load(66, &t.sessionKeyring)
	stateSourceObject.LoadValue(32, new(*Task), func(y any) { t.loadPtraceTracer(y.(*Task)) })
	stateSourceObject.LoadValue(48, new([]bpf.Program), func(y any) { t.loadSyscallFilters(y.([]bpf.Program)) })
	stateSourceObject.AfterLoad(t.afterLoad)
}

func (r *runSyscallAfterPtraceEventClone) StateTypeName() string {
	return "pkg/sentry/kernel.runSyscallAfterPtraceEventClone"
}

func (r *runSyscallAfterPtraceEventClone) StateFields() []string {
	return []string{
		"vforkChild",
		"vforkChildTID",
	}
}

func (r *runSyscallAfterPtraceEventClone) beforeSave() {}

// +checklocksignore
func (r *runSyscallAfterPtraceEventClone) StateSave(stateSinkObject state.Sink) {
	r.beforeSave()
	stateSinkObject.Save(0, &r.vforkChild)
	stateSinkObject.Save(1, &r.vforkChildTID)
}

func (r *runSyscallAfterPtraceEventClone) afterLoad() {}

// +checklocksignore
func (r *runSyscallAfterPtraceEventClone) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &r.vforkChild)
	stateSourceObject.Load(1, &r.vforkChildTID)
}

func (r *runSyscallAfterVforkStop) StateTypeName() string {
	return "pkg/sentry/kernel.runSyscallAfterVforkStop"
}

func (r *runSyscallAfterVforkStop) StateFields() []string {
	return []string{
		"childTID",
	}
}

func (r *runSyscallAfterVforkStop) beforeSave() {}

// +checklocksignore
func (r *runSyscallAfterVforkStop) StateSave(stateSinkObject state.Sink) {
	r.beforeSave()
	stateSinkObject.Save(0, &r.childTID)
}

func (r *runSyscallAfterVforkStop) afterLoad() {}

// +checklocksignore
func (r *runSyscallAfterVforkStop) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &r.childTID)
}

func (v *vforkStop) StateTypeName() string {
	return "pkg/sentry/kernel.vforkStop"
}

func (v *vforkStop) StateFields() []string {
	return []string{}
}

func (v *vforkStop) beforeSave() {}

// +checklocksignore
func (v *vforkStop) StateSave(stateSinkObject state.Sink) {
	v.beforeSave()
}

func (v *vforkStop) afterLoad() {}

// +checklocksignore
func (v *vforkStop) StateLoad(stateSourceObject state.Source) {
}

func (e *execStop) StateTypeName() string {
	return "pkg/sentry/kernel.execStop"
}

func (e *execStop) StateFields() []string {
	return []string{}
}

func (e *execStop) beforeSave() {}

// +checklocksignore
func (e *execStop) StateSave(stateSinkObject state.Sink) {
	e.beforeSave()
}

func (e *execStop) afterLoad() {}

// +checklocksignore
func (e *execStop) StateLoad(stateSourceObject state.Source) {
}

func (r *runSyscallAfterExecStop) StateTypeName() string {
	return "pkg/sentry/kernel.runSyscallAfterExecStop"
}

func (r *runSyscallAfterExecStop) StateFields() []string {
	return []string{
		"image",
	}
}

func (r *runSyscallAfterExecStop) beforeSave() {}

// +checklocksignore
func (r *runSyscallAfterExecStop) StateSave(stateSinkObject state.Sink) {
	r.beforeSave()
	stateSinkObject.Save(0, &r.image)
}

func (r *runSyscallAfterExecStop) afterLoad() {}

// +checklocksignore
func (r *runSyscallAfterExecStop) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &r.image)
}

func (r *runExit) StateTypeName() string {
	return "pkg/sentry/kernel.runExit"
}

func (r *runExit) StateFields() []string {
	return []string{}
}

func (r *runExit) beforeSave() {}

// +checklocksignore
func (r *runExit) StateSave(stateSinkObject state.Sink) {
	r.beforeSave()
}

func (r *runExit) afterLoad() {}

// +checklocksignore
func (r *runExit) StateLoad(stateSourceObject state.Source) {
}

func (r *runExitMain) StateTypeName() string {
	return "pkg/sentry/kernel.runExitMain"
}

func (r *runExitMain) StateFields() []string {
	return []string{}
}

func (r *runExitMain) beforeSave() {}

// +checklocksignore
func (r *runExitMain) StateSave(stateSinkObject state.Sink) {
	r.beforeSave()
}

func (r *runExitMain) afterLoad() {}

// +checklocksignore
func (r *runExitMain) StateLoad(stateSourceObject state.Source) {
}

func (r *runExitNotify) StateTypeName() string {
	return "pkg/sentry/kernel.runExitNotify"
}

func (r *runExitNotify) StateFields() []string {
	return []string{}
}

func (r *runExitNotify) beforeSave() {}

// +checklocksignore
func (r *runExitNotify) StateSave(stateSinkObject state.Sink) {
	r.beforeSave()
}

func (r *runExitNotify) afterLoad() {}

// +checklocksignore
func (r *runExitNotify) StateLoad(stateSourceObject state.Source) {
}

func (image *TaskImage) StateTypeName() string {
	return "pkg/sentry/kernel.TaskImage"
}

func (image *TaskImage) StateFields() []string {
	return []string{
		"Name",
		"Arch",
		"MemoryManager",
		"fu",
		"st",
	}
}

func (image *TaskImage) beforeSave() {}

// +checklocksignore
func (image *TaskImage) StateSave(stateSinkObject state.Sink) {
	image.beforeSave()
	var stValue syscallTableInfo
	stValue = image.saveSt()
	stateSinkObject.SaveValue(4, stValue)
	stateSinkObject.Save(0, &image.Name)
	stateSinkObject.Save(1, &image.Arch)
	stateSinkObject.Save(2, &image.MemoryManager)
	stateSinkObject.Save(3, &image.fu)
}

func (image *TaskImage) afterLoad() {}

// +checklocksignore
func (image *TaskImage) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &image.Name)
	stateSourceObject.Load(1, &image.Arch)
	stateSourceObject.Load(2, &image.MemoryManager)
	stateSourceObject.Load(3, &image.fu)
	stateSourceObject.LoadValue(4, new(syscallTableInfo), func(y any) { image.loadSt(y.(syscallTableInfo)) })
}

func (l *taskList) StateTypeName() string {
	return "pkg/sentry/kernel.taskList"
}

func (l *taskList) StateFields() []string {
	return []string{
		"head",
		"tail",
	}
}

func (l *taskList) beforeSave() {}

// +checklocksignore
func (l *taskList) StateSave(stateSinkObject state.Sink) {
	l.beforeSave()
	stateSinkObject.Save(0, &l.head)
	stateSinkObject.Save(1, &l.tail)
}

func (l *taskList) afterLoad() {}

// +checklocksignore
func (l *taskList) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &l.head)
	stateSourceObject.Load(1, &l.tail)
}

func (e *taskEntry) StateTypeName() string {
	return "pkg/sentry/kernel.taskEntry"
}

func (e *taskEntry) StateFields() []string {
	return []string{
		"next",
		"prev",
	}
}

func (e *taskEntry) beforeSave() {}

// +checklocksignore
func (e *taskEntry) StateSave(stateSinkObject state.Sink) {
	e.beforeSave()
	stateSinkObject.Save(0, &e.next)
	stateSinkObject.Save(1, &e.prev)
}

func (e *taskEntry) afterLoad() {}

// +checklocksignore
func (e *taskEntry) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &e.next)
	stateSourceObject.Load(1, &e.prev)
}

func (app *runApp) StateTypeName() string {
	return "pkg/sentry/kernel.runApp"
}

func (app *runApp) StateFields() []string {
	return []string{}
}

func (app *runApp) beforeSave() {}

// +checklocksignore
func (app *runApp) StateSave(stateSinkObject state.Sink) {
	app.beforeSave()
}

func (app *runApp) afterLoad() {}

// +checklocksignore
func (app *runApp) StateLoad(stateSourceObject state.Source) {
}

func (ts *TaskGoroutineSchedInfo) StateTypeName() string {
	return "pkg/sentry/kernel.TaskGoroutineSchedInfo"
}

func (ts *TaskGoroutineSchedInfo) StateFields() []string {
	return []string{
		"Timestamp",
		"State",
		"UserTicks",
		"SysTicks",
	}
}

func (ts *TaskGoroutineSchedInfo) beforeSave() {}

// +checklocksignore
func (ts *TaskGoroutineSchedInfo) StateSave(stateSinkObject state.Sink) {
	ts.beforeSave()
	stateSinkObject.Save(0, &ts.Timestamp)
	stateSinkObject.Save(1, &ts.State)
	stateSinkObject.Save(2, &ts.UserTicks)
	stateSinkObject.Save(3, &ts.SysTicks)
}

func (ts *TaskGoroutineSchedInfo) afterLoad() {}

// +checklocksignore
func (ts *TaskGoroutineSchedInfo) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &ts.Timestamp)
	stateSourceObject.Load(1, &ts.State)
	stateSourceObject.Load(2, &ts.UserTicks)
	stateSourceObject.Load(3, &ts.SysTicks)
}

func (tc *taskClock) StateTypeName() string {
	return "pkg/sentry/kernel.taskClock"
}

func (tc *taskClock) StateFields() []string {
	return []string{
		"t",
		"includeSys",
	}
}

func (tc *taskClock) beforeSave() {}

// +checklocksignore
func (tc *taskClock) StateSave(stateSinkObject state.Sink) {
	tc.beforeSave()
	stateSinkObject.Save(0, &tc.t)
	stateSinkObject.Save(1, &tc.includeSys)
}

func (tc *taskClock) afterLoad() {}

// +checklocksignore
func (tc *taskClock) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &tc.t)
	stateSourceObject.Load(1, &tc.includeSys)
}

func (tgc *tgClock) StateTypeName() string {
	return "pkg/sentry/kernel.tgClock"
}

func (tgc *tgClock) StateFields() []string {
	return []string{
		"tg",
		"includeSys",
	}
}

func (tgc *tgClock) beforeSave() {}

// +checklocksignore
func (tgc *tgClock) StateSave(stateSinkObject state.Sink) {
	tgc.beforeSave()
	stateSinkObject.Save(0, &tgc.tg)
	stateSinkObject.Save(1, &tgc.includeSys)
}

func (tgc *tgClock) afterLoad() {}

// +checklocksignore
func (tgc *tgClock) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &tgc.tg)
	stateSourceObject.Load(1, &tgc.includeSys)
}

func (g *groupStop) StateTypeName() string {
	return "pkg/sentry/kernel.groupStop"
}

func (g *groupStop) StateFields() []string {
	return []string{}
}

func (g *groupStop) beforeSave() {}

// +checklocksignore
func (g *groupStop) StateSave(stateSinkObject state.Sink) {
	g.beforeSave()
}

func (g *groupStop) afterLoad() {}

// +checklocksignore
func (g *groupStop) StateLoad(stateSourceObject state.Source) {
}

func (r *runInterrupt) StateTypeName() string {
	return "pkg/sentry/kernel.runInterrupt"
}

func (r *runInterrupt) StateFields() []string {
	return []string{}
}

func (r *runInterrupt) beforeSave() {}

// +checklocksignore
func (r *runInterrupt) StateSave(stateSinkObject state.Sink) {
	r.beforeSave()
}

func (r *runInterrupt) afterLoad() {}

// +checklocksignore
func (r *runInterrupt) StateLoad(stateSourceObject state.Source) {
}

func (r *runInterruptAfterSignalDeliveryStop) StateTypeName() string {
	return "pkg/sentry/kernel.runInterruptAfterSignalDeliveryStop"
}

func (r *runInterruptAfterSignalDeliveryStop) StateFields() []string {
	return []string{}
}

func (r *runInterruptAfterSignalDeliveryStop) beforeSave() {}

// +checklocksignore
func (r *runInterruptAfterSignalDeliveryStop) StateSave(stateSinkObject state.Sink) {
	r.beforeSave()
}

func (r *runInterruptAfterSignalDeliveryStop) afterLoad() {}

// +checklocksignore
func (r *runInterruptAfterSignalDeliveryStop) StateLoad(stateSourceObject state.Source) {
}

func (r *runSyscallAfterSyscallEnterStop) StateTypeName() string {
	return "pkg/sentry/kernel.runSyscallAfterSyscallEnterStop"
}

func (r *runSyscallAfterSyscallEnterStop) StateFields() []string {
	return []string{}
}

func (r *runSyscallAfterSyscallEnterStop) beforeSave() {}

// +checklocksignore
func (r *runSyscallAfterSyscallEnterStop) StateSave(stateSinkObject state.Sink) {
	r.beforeSave()
}

func (r *runSyscallAfterSyscallEnterStop) afterLoad() {}

// +checklocksignore
func (r *runSyscallAfterSyscallEnterStop) StateLoad(stateSourceObject state.Source) {
}

func (r *runSyscallAfterSysemuStop) StateTypeName() string {
	return "pkg/sentry/kernel.runSyscallAfterSysemuStop"
}

func (r *runSyscallAfterSysemuStop) StateFields() []string {
	return []string{}
}

func (r *runSyscallAfterSysemuStop) beforeSave() {}

// +checklocksignore
func (r *runSyscallAfterSysemuStop) StateSave(stateSinkObject state.Sink) {
	r.beforeSave()
}

func (r *runSyscallAfterSysemuStop) afterLoad() {}

// +checklocksignore
func (r *runSyscallAfterSysemuStop) StateLoad(stateSourceObject state.Source) {
}

func (r *runSyscallReinvoke) StateTypeName() string {
	return "pkg/sentry/kernel.runSyscallReinvoke"
}

func (r *runSyscallReinvoke) StateFields() []string {
	return []string{}
}

func (r *runSyscallReinvoke) beforeSave() {}

// +checklocksignore
func (r *runSyscallReinvoke) StateSave(stateSinkObject state.Sink) {
	r.beforeSave()
}

func (r *runSyscallReinvoke) afterLoad() {}

// +checklocksignore
func (r *runSyscallReinvoke) StateLoad(stateSourceObject state.Source) {
}

func (r *runSyscallExit) StateTypeName() string {
	return "pkg/sentry/kernel.runSyscallExit"
}

func (r *runSyscallExit) StateFields() []string {
	return []string{}
}

func (r *runSyscallExit) beforeSave() {}

// +checklocksignore
func (r *runSyscallExit) StateSave(stateSinkObject state.Sink) {
	r.beforeSave()
}

func (r *runSyscallExit) afterLoad() {}

// +checklocksignore
func (r *runSyscallExit) StateLoad(stateSourceObject state.Source) {
}

func (tg *ThreadGroup) StateTypeName() string {
	return "pkg/sentry/kernel.ThreadGroup"
}

func (tg *ThreadGroup) StateFields() []string {
	return []string{
		"threadGroupNode",
		"signalHandlers",
		"pendingSignals",
		"groupStopDequeued",
		"groupStopSignal",
		"groupStopPendingCount",
		"groupStopComplete",
		"groupStopWaitable",
		"groupContNotify",
		"groupContInterrupted",
		"groupContWaitable",
		"exiting",
		"exitStatus",
		"terminationSignal",
		"itimerRealTimer",
		"itimerVirtSetting",
		"itimerProfSetting",
		"rlimitCPUSoftSetting",
		"cpuTimersEnabled",
		"timers",
		"nextTimerID",
		"exitedCPUStats",
		"childCPUStats",
		"ioUsage",
		"maxRSS",
		"childMaxRSS",
		"limits",
		"processGroup",
		"execed",
		"oldRSeqCritical",
		"tty",
		"oomScoreAdj",
		"isChildSubreaper",
		"hasChildSubreaper",
	}
}

func (tg *ThreadGroup) beforeSave() {}

// +checklocksignore
func (tg *ThreadGroup) StateSave(stateSinkObject state.Sink) {
	tg.beforeSave()
	var oldRSeqCriticalValue *OldRSeqCriticalRegion
	oldRSeqCriticalValue = tg.saveOldRSeqCritical()
	stateSinkObject.SaveValue(29, oldRSeqCriticalValue)
	stateSinkObject.Save(0, &tg.threadGroupNode)
	stateSinkObject.Save(1, &tg.signalHandlers)
	stateSinkObject.Save(2, &tg.pendingSignals)
	stateSinkObject.Save(3, &tg.groupStopDequeued)
	stateSinkObject.Save(4, &tg.groupStopSignal)
	stateSinkObject.Save(5, &tg.groupStopPendingCount)
	stateSinkObject.Save(6, &tg.groupStopComplete)
	stateSinkObject.Save(7, &tg.groupStopWaitable)
	stateSinkObject.Save(8, &tg.groupContNotify)
	stateSinkObject.Save(9, &tg.groupContInterrupted)
	stateSinkObject.Save(10, &tg.groupContWaitable)
	stateSinkObject.Save(11, &tg.exiting)
	stateSinkObject.Save(12, &tg.exitStatus)
	stateSinkObject.Save(13, &tg.terminationSignal)
	stateSinkObject.Save(14, &tg.itimerRealTimer)
	stateSinkObject.Save(15, &tg.itimerVirtSetting)
	stateSinkObject.Save(16, &tg.itimerProfSetting)
	stateSinkObject.Save(17, &tg.rlimitCPUSoftSetting)
	stateSinkObject.Save(18, &tg.cpuTimersEnabled)
	stateSinkObject.Save(19, &tg.timers)
	stateSinkObject.Save(20, &tg.nextTimerID)
	stateSinkObject.Save(21, &tg.exitedCPUStats)
	stateSinkObject.Save(22, &tg.childCPUStats)
	stateSinkObject.Save(23, &tg.ioUsage)
	stateSinkObject.Save(24, &tg.maxRSS)
	stateSinkObject.Save(25, &tg.childMaxRSS)
	stateSinkObject.Save(26, &tg.limits)
	stateSinkObject.Save(27, &tg.processGroup)
	stateSinkObject.Save(28, &tg.execed)
	stateSinkObject.Save(30, &tg.tty)
	stateSinkObject.Save(31, &tg.oomScoreAdj)
	stateSinkObject.Save(32, &tg.isChildSubreaper)
	stateSinkObject.Save(33, &tg.hasChildSubreaper)
}

func (tg *ThreadGroup) afterLoad() {}

// +checklocksignore
func (tg *ThreadGroup) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &tg.threadGroupNode)
	stateSourceObject.Load(1, &tg.signalHandlers)
	stateSourceObject.Load(2, &tg.pendingSignals)
	stateSourceObject.Load(3, &tg.groupStopDequeued)
	stateSourceObject.Load(4, &tg.groupStopSignal)
	stateSourceObject.Load(5, &tg.groupStopPendingCount)
	stateSourceObject.Load(6, &tg.groupStopComplete)
	stateSourceObject.Load(7, &tg.groupStopWaitable)
	stateSourceObject.Load(8, &tg.groupContNotify)
	stateSourceObject.Load(9, &tg.groupContInterrupted)
	stateSourceObject.Load(10, &tg.groupContWaitable)
	stateSourceObject.Load(11, &tg.exiting)
	stateSourceObject.Load(12, &tg.exitStatus)
	stateSourceObject.Load(13, &tg.terminationSignal)
	stateSourceObject.Load(14, &tg.itimerRealTimer)
	stateSourceObject.Load(15, &tg.itimerVirtSetting)
	stateSourceObject.Load(16, &tg.itimerProfSetting)
	stateSourceObject.Load(17, &tg.rlimitCPUSoftSetting)
	stateSourceObject.Load(18, &tg.cpuTimersEnabled)
	stateSourceObject.Load(19, &tg.timers)
	stateSourceObject.Load(20, &tg.nextTimerID)
	stateSourceObject.Load(21, &tg.exitedCPUStats)
	stateSourceObject.Load(22, &tg.childCPUStats)
	stateSourceObject.Load(23, &tg.ioUsage)
	stateSourceObject.Load(24, &tg.maxRSS)
	stateSourceObject.Load(25, &tg.childMaxRSS)
	stateSourceObject.Load(26, &tg.limits)
	stateSourceObject.Load(27, &tg.processGroup)
	stateSourceObject.Load(28, &tg.execed)
	stateSourceObject.Load(30, &tg.tty)
	stateSourceObject.Load(31, &tg.oomScoreAdj)
	stateSourceObject.Load(32, &tg.isChildSubreaper)
	stateSourceObject.Load(33, &tg.hasChildSubreaper)
	stateSourceObject.LoadValue(29, new(*OldRSeqCriticalRegion), func(y any) { tg.loadOldRSeqCritical(y.(*OldRSeqCriticalRegion)) })
}

func (l *itimerRealListener) StateTypeName() string {
	return "pkg/sentry/kernel.itimerRealListener"
}

func (l *itimerRealListener) StateFields() []string {
	return []string{
		"tg",
	}
}

func (l *itimerRealListener) beforeSave() {}

// +checklocksignore
func (l *itimerRealListener) StateSave(stateSinkObject state.Sink) {
	l.beforeSave()
	stateSinkObject.Save(0, &l.tg)
}

func (l *itimerRealListener) afterLoad() {}

// +checklocksignore
func (l *itimerRealListener) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &l.tg)
}

func (ts *TaskSet) StateTypeName() string {
	return "pkg/sentry/kernel.TaskSet"
}

func (ts *TaskSet) StateFields() []string {
	return []string{
		"Root",
		"sessions",
	}
}

func (ts *TaskSet) beforeSave() {}

// +checklocksignore
func (ts *TaskSet) StateSave(stateSinkObject state.Sink) {
	ts.beforeSave()
	stateSinkObject.Save(0, &ts.Root)
	stateSinkObject.Save(1, &ts.sessions)
}

func (ts *TaskSet) afterLoad() {}

// +checklocksignore
func (ts *TaskSet) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &ts.Root)
	stateSourceObject.Load(1, &ts.sessions)
}

func (ns *PIDNamespace) StateTypeName() string {
	return "pkg/sentry/kernel.PIDNamespace"
}

func (ns *PIDNamespace) StateFields() []string {
	return []string{
		"owner",
		"parent",
		"userns",
		"id",
		"last",
		"tasks",
		"tids",
		"tgids",
		"sessions",
		"sids",
		"processGroups",
		"pgids",
		"exiting",
		"extra",
	}
}

func (ns *PIDNamespace) beforeSave() {}

// +checklocksignore
func (ns *PIDNamespace) StateSave(stateSinkObject state.Sink) {
	ns.beforeSave()
	stateSinkObject.Save(0, &ns.owner)
	stateSinkObject.Save(1, &ns.parent)
	stateSinkObject.Save(2, &ns.userns)
	stateSinkObject.Save(3, &ns.id)
	stateSinkObject.Save(4, &ns.last)
	stateSinkObject.Save(5, &ns.tasks)
	stateSinkObject.Save(6, &ns.tids)
	stateSinkObject.Save(7, &ns.tgids)
	stateSinkObject.Save(8, &ns.sessions)
	stateSinkObject.Save(9, &ns.sids)
	stateSinkObject.Save(10, &ns.processGroups)
	stateSinkObject.Save(11, &ns.pgids)
	stateSinkObject.Save(12, &ns.exiting)
	stateSinkObject.Save(13, &ns.extra)
}

func (ns *PIDNamespace) afterLoad() {}

// +checklocksignore
func (ns *PIDNamespace) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &ns.owner)
	stateSourceObject.Load(1, &ns.parent)
	stateSourceObject.Load(2, &ns.userns)
	stateSourceObject.Load(3, &ns.id)
	stateSourceObject.Load(4, &ns.last)
	stateSourceObject.Load(5, &ns.tasks)
	stateSourceObject.Load(6, &ns.tids)
	stateSourceObject.Load(7, &ns.tgids)
	stateSourceObject.Load(8, &ns.sessions)
	stateSourceObject.Load(9, &ns.sids)
	stateSourceObject.Load(10, &ns.processGroups)
	stateSourceObject.Load(11, &ns.pgids)
	stateSourceObject.Load(12, &ns.exiting)
	stateSourceObject.Load(13, &ns.extra)
}

func (t *threadGroupNode) StateTypeName() string {
	return "pkg/sentry/kernel.threadGroupNode"
}

func (t *threadGroupNode) StateFields() []string {
	return []string{
		"pidns",
		"pidWithinNS",
		"eventQueue",
		"leader",
		"execing",
		"tasks",
		"tasksCount",
		"liveTasks",
		"activeTasks",
	}
}

func (t *threadGroupNode) beforeSave() {}

// +checklocksignore
func (t *threadGroupNode) StateSave(stateSinkObject state.Sink) {
	t.beforeSave()
	stateSinkObject.Save(0, &t.pidns)
	stateSinkObject.Save(1, &t.pidWithinNS)
	stateSinkObject.Save(2, &t.eventQueue)
	stateSinkObject.Save(3, &t.leader)
	stateSinkObject.Save(4, &t.execing)
	stateSinkObject.Save(5, &t.tasks)
	stateSinkObject.Save(6, &t.tasksCount)
	stateSinkObject.Save(7, &t.liveTasks)
	stateSinkObject.Save(8, &t.activeTasks)
}

func (t *threadGroupNode) afterLoad() {}

// +checklocksignore
func (t *threadGroupNode) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &t.pidns)
	stateSourceObject.Load(1, &t.pidWithinNS)
	stateSourceObject.Load(2, &t.eventQueue)
	stateSourceObject.Load(3, &t.leader)
	stateSourceObject.Load(4, &t.execing)
	stateSourceObject.Load(5, &t.tasks)
	stateSourceObject.Load(6, &t.tasksCount)
	stateSourceObject.Load(7, &t.liveTasks)
	stateSourceObject.Load(8, &t.activeTasks)
}

func (t *taskNode) StateTypeName() string {
	return "pkg/sentry/kernel.taskNode"
}

func (t *taskNode) StateFields() []string {
	return []string{
		"tg",
		"taskEntry",
		"parent",
		"children",
		"childPIDNamespace",
	}
}

func (t *taskNode) beforeSave() {}

// +checklocksignore
func (t *taskNode) StateSave(stateSinkObject state.Sink) {
	t.beforeSave()
	stateSinkObject.Save(0, &t.tg)
	stateSinkObject.Save(1, &t.taskEntry)
	stateSinkObject.Save(2, &t.parent)
	stateSinkObject.Save(3, &t.children)
	stateSinkObject.Save(4, &t.childPIDNamespace)
}

func (t *taskNode) afterLoad() {}

// +checklocksignore
func (t *taskNode) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.LoadWait(0, &t.tg)
	stateSourceObject.Load(1, &t.taskEntry)
	stateSourceObject.Load(2, &t.parent)
	stateSourceObject.Load(3, &t.children)
	stateSourceObject.Load(4, &t.childPIDNamespace)
}

func (t *Timekeeper) StateTypeName() string {
	return "pkg/sentry/kernel.Timekeeper"
}

func (t *Timekeeper) StateFields() []string {
	return []string{
		"realtimeClock",
		"monotonicClock",
		"bootTime",
		"saveMonotonic",
		"saveRealtime",
		"params",
	}
}

// +checklocksignore
func (t *Timekeeper) StateSave(stateSinkObject state.Sink) {
	t.beforeSave()
	stateSinkObject.Save(0, &t.realtimeClock)
	stateSinkObject.Save(1, &t.monotonicClock)
	stateSinkObject.Save(2, &t.bootTime)
	stateSinkObject.Save(3, &t.saveMonotonic)
	stateSinkObject.Save(4, &t.saveRealtime)
	stateSinkObject.Save(5, &t.params)
}

// +checklocksignore
func (t *Timekeeper) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &t.realtimeClock)
	stateSourceObject.Load(1, &t.monotonicClock)
	stateSourceObject.Load(2, &t.bootTime)
	stateSourceObject.Load(3, &t.saveMonotonic)
	stateSourceObject.Load(4, &t.saveRealtime)
	stateSourceObject.Load(5, &t.params)
	stateSourceObject.AfterLoad(t.afterLoad)
}

func (tc *timekeeperClock) StateTypeName() string {
	return "pkg/sentry/kernel.timekeeperClock"
}

func (tc *timekeeperClock) StateFields() []string {
	return []string{
		"tk",
		"c",
	}
}

func (tc *timekeeperClock) beforeSave() {}

// +checklocksignore
func (tc *timekeeperClock) StateSave(stateSinkObject state.Sink) {
	tc.beforeSave()
	stateSinkObject.Save(0, &tc.tk)
	stateSinkObject.Save(1, &tc.c)
}

func (tc *timekeeperClock) afterLoad() {}

// +checklocksignore
func (tc *timekeeperClock) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &tc.tk)
	stateSourceObject.Load(1, &tc.c)
}

func (tty *TTY) StateTypeName() string {
	return "pkg/sentry/kernel.TTY"
}

func (tty *TTY) StateFields() []string {
	return []string{
		"Index",
		"tg",
	}
}

func (tty *TTY) beforeSave() {}

// +checklocksignore
func (tty *TTY) StateSave(stateSinkObject state.Sink) {
	tty.beforeSave()
	stateSinkObject.Save(0, &tty.Index)
	stateSinkObject.Save(1, &tty.tg)
}

func (tty *TTY) afterLoad() {}

// +checklocksignore
func (tty *TTY) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &tty.Index)
	stateSourceObject.Load(1, &tty.tg)
}

func (u *UTSNamespace) StateTypeName() string {
	return "pkg/sentry/kernel.UTSNamespace"
}

func (u *UTSNamespace) StateFields() []string {
	return []string{
		"hostName",
		"domainName",
		"userns",
		"inode",
	}
}

func (u *UTSNamespace) beforeSave() {}

// +checklocksignore
func (u *UTSNamespace) StateSave(stateSinkObject state.Sink) {
	u.beforeSave()
	stateSinkObject.Save(0, &u.hostName)
	stateSinkObject.Save(1, &u.domainName)
	stateSinkObject.Save(2, &u.userns)
	stateSinkObject.Save(3, &u.inode)
}

func (u *UTSNamespace) afterLoad() {}

// +checklocksignore
func (u *UTSNamespace) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &u.hostName)
	stateSourceObject.Load(1, &u.domainName)
	stateSourceObject.Load(2, &u.userns)
	stateSourceObject.Load(3, &u.inode)
}

func (v *VDSOParamPage) StateTypeName() string {
	return "pkg/sentry/kernel.VDSOParamPage"
}

func (v *VDSOParamPage) StateFields() []string {
	return []string{
		"mfp",
		"fr",
		"seq",
		"copyScratchBuffer",
	}
}

func (v *VDSOParamPage) beforeSave() {}

// +checklocksignore
func (v *VDSOParamPage) StateSave(stateSinkObject state.Sink) {
	v.beforeSave()
	stateSinkObject.Save(0, &v.mfp)
	stateSinkObject.Save(1, &v.fr)
	stateSinkObject.Save(2, &v.seq)
	stateSinkObject.Save(3, &v.copyScratchBuffer)
}

func (v *VDSOParamPage) afterLoad() {}

// +checklocksignore
func (v *VDSOParamPage) StateLoad(stateSourceObject state.Source) {
	stateSourceObject.Load(0, &v.mfp)
	stateSourceObject.Load(1, &v.fr)
	stateSourceObject.Load(2, &v.seq)
	stateSourceObject.Load(3, &v.copyScratchBuffer)
}

func init() {
	state.Register((*Cgroup)(nil))
	state.Register((*hierarchy)(nil))
	state.Register((*CgroupRegistry)(nil))
	state.Register((*FDFlags)(nil))
	state.Register((*descriptor)(nil))
	state.Register((*FDTable)(nil))
	state.Register((*FDTableRefs)(nil))
	state.Register((*FSContext)(nil))
	state.Register((*FSContextRefs)(nil))
	state.Register((*IPCNamespace)(nil))
	state.Register((*userCounters)(nil))
	state.Register((*Kernel)(nil))
	state.Register((*SocketRecord)(nil))
	state.Register((*pendingSignals)(nil))
	state.Register((*pendingSignalQueue)(nil))
	state.Register((*pendingSignal)(nil))
	state.Register((*pendingSignalList)(nil))
	state.Register((*pendingSignalEntry)(nil))
	state.Register((*savedPendingSignal)(nil))
	state.Register((*IntervalTimer)(nil))
	state.Register((*processGroupList)(nil))
	state.Register((*processGroupEntry)(nil))
	state.Register((*ProcessGroupRefs)(nil))
	state.Register((*ptraceOptions)(nil))
	state.Register((*ptraceStop)(nil))
	state.Register((*OldRSeqCriticalRegion)(nil))
	state.Register((*sessionList)(nil))
	state.Register((*sessionEntry)(nil))
	state.Register((*SessionRefs)(nil))
	state.Register((*Session)(nil))
	state.Register((*ProcessGroup)(nil))
	state.Register((*SignalHandlers)(nil))
	state.Register((*syscallTableInfo)(nil))
	state.Register((*syslog)(nil))
	state.Register((*Task)(nil))
	state.Register((*runSyscallAfterPtraceEventClone)(nil))
	state.Register((*runSyscallAfterVforkStop)(nil))
	state.Register((*vforkStop)(nil))
	state.Register((*execStop)(nil))
	state.Register((*runSyscallAfterExecStop)(nil))
	state.Register((*runExit)(nil))
	state.Register((*runExitMain)(nil))
	state.Register((*runExitNotify)(nil))
	state.Register((*TaskImage)(nil))
	state.Register((*taskList)(nil))
	state.Register((*taskEntry)(nil))
	state.Register((*runApp)(nil))
	state.Register((*TaskGoroutineSchedInfo)(nil))
	state.Register((*taskClock)(nil))
	state.Register((*tgClock)(nil))
	state.Register((*groupStop)(nil))
	state.Register((*runInterrupt)(nil))
	state.Register((*runInterruptAfterSignalDeliveryStop)(nil))
	state.Register((*runSyscallAfterSyscallEnterStop)(nil))
	state.Register((*runSyscallAfterSysemuStop)(nil))
	state.Register((*runSyscallReinvoke)(nil))
	state.Register((*runSyscallExit)(nil))
	state.Register((*ThreadGroup)(nil))
	state.Register((*itimerRealListener)(nil))
	state.Register((*TaskSet)(nil))
	state.Register((*PIDNamespace)(nil))
	state.Register((*threadGroupNode)(nil))
	state.Register((*taskNode)(nil))
	state.Register((*Timekeeper)(nil))
	state.Register((*timekeeperClock)(nil))
	state.Register((*TTY)(nil))
	state.Register((*UTSNamespace)(nil))
	state.Register((*VDSOParamPage)(nil))
}
