/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.cell.client;

import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.cell.client.HasCell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.EventTarget;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CompositeCell<C>
extends AbstractCell<C> {
    private Set<String> consumedEvents;
    private boolean dependsOnSelection;
    private boolean handlesSelection;
    private final List<HasCell<C, ?>> hasCells;

    public CompositeCell(List<HasCell<C, ?>> hasCells) {
        super(new String[0]);
        this.hasCells = new ArrayList(hasCells);
        HashSet<String> theConsumedEvents = null;
        for (HasCell<C, ?> hasCell : hasCells) {
            Cell<?> cell = hasCell.getCell();
            Set<String> events = cell.getConsumedEvents();
            if (events != null) {
                if (theConsumedEvents == null) {
                    theConsumedEvents = new HashSet<String>();
                }
                theConsumedEvents.addAll(events);
            }
            if (cell.dependsOnSelection()) {
                this.dependsOnSelection = true;
            }
            if (!cell.handlesSelection()) continue;
            this.handlesSelection = true;
        }
        if (theConsumedEvents != null) {
            this.consumedEvents = Collections.unmodifiableSet(theConsumedEvents);
        }
    }

    @Override
    public boolean dependsOnSelection() {
        return this.dependsOnSelection;
    }

    @Override
    public Set<String> getConsumedEvents() {
        return this.consumedEvents;
    }

    @Override
    public boolean handlesSelection() {
        return this.handlesSelection;
    }

    @Override
    public boolean isEditing(Cell.Context context, Element parent, C value) {
        Element curChild = this.getContainerElement(parent).getFirstChildElement();
        for (HasCell<C, ?> hasCell : this.hasCells) {
            if (this.isEditingImpl(context, curChild, value, hasCell)) {
                return true;
            }
            curChild = curChild.getNextSiblingElement();
        }
        return false;
    }

    @Override
    public void onBrowserEvent(Cell.Context context, Element parent, C value, NativeEvent event, ValueUpdater<C> valueUpdater) {
        int index = 0;
        EventTarget eventTarget = event.getEventTarget();
        if (Element.is(eventTarget)) {
            Element target = (Element)eventTarget.cast();
            Element container = this.getContainerElement(parent);
            for (Element wrapper = container.getFirstChildElement(); wrapper != null; wrapper = wrapper.getNextSiblingElement()) {
                if (wrapper.isOrHasChild(target)) {
                    this.onBrowserEventImpl(context, wrapper, value, event, valueUpdater, this.hasCells.get(index));
                }
                ++index;
            }
        }
    }

    @Override
    public void render(Cell.Context context, C value, SafeHtmlBuilder sb) {
        for (HasCell<C, ?> hasCell : this.hasCells) {
            this.render(context, value, sb, hasCell);
        }
    }

    @Override
    public boolean resetFocus(Cell.Context context, Element parent, C value) {
        Element curChild = this.getContainerElement(parent).getFirstChildElement();
        for (HasCell<C, ?> hasCell : this.hasCells) {
            if (this.resetFocusImpl(context, curChild, value, hasCell)) {
                return true;
            }
            curChild = curChild.getNextSiblingElement();
        }
        return false;
    }

    @Override
    public void setValue(Cell.Context context, Element parent, C object) {
        Element curChild = this.getContainerElement(parent).getFirstChildElement();
        for (HasCell<C, ?> hasCell : this.hasCells) {
            this.setValueImpl(context, curChild, object, hasCell);
            curChild = curChild.getNextSiblingElement();
        }
    }

    protected Element getContainerElement(Element parent) {
        return parent;
    }

    protected <X> void render(Cell.Context context, C value, SafeHtmlBuilder sb, HasCell<C, X> hasCell) {
        Cell<X> cell = hasCell.getCell();
        sb.appendHtmlConstant("<span>");
        cell.render(context, hasCell.getValue(value), sb);
        sb.appendHtmlConstant("</span>");
    }

    private <X> boolean isEditingImpl(Cell.Context context, Element cellParent, C object, HasCell<C, X> hasCell) {
        return hasCell.getCell().isEditing(context, cellParent, hasCell.getValue(object));
    }

    private <X> void onBrowserEventImpl(final Cell.Context context, Element parent, final C object, NativeEvent event, final ValueUpdater<C> valueUpdater, HasCell<C, X> hasCell) {
        Cell<X> cell = hasCell.getCell();
        String eventType = event.getType();
        Set<String> cellConsumedEvents = cell.getConsumedEvents();
        if (cellConsumedEvents == null || !cellConsumedEvents.contains(eventType)) {
            return;
        }
        ValueUpdater tempUpdater = null;
        final FieldUpdater<C, X> fieldUpdater = hasCell.getFieldUpdater();
        if (fieldUpdater != null) {
            tempUpdater = new ValueUpdater<X>(){

                @Override
                public void update(X value) {
                    fieldUpdater.update(context.getIndex(), object, value);
                    if (valueUpdater != null) {
                        valueUpdater.update(object);
                    }
                }
            };
        }
        cell.onBrowserEvent(context, parent, hasCell.getValue(object), event, tempUpdater);
    }

    private <X> boolean resetFocusImpl(Cell.Context context, Element cellParent, C value, HasCell<C, X> hasCell) {
        X cellValue = hasCell.getValue(value);
        return hasCell.getCell().resetFocus(context, cellParent, cellValue);
    }

    private <X> void setValueImpl(Cell.Context context, Element cellParent, C object, HasCell<C, X> hasCell) {
        hasCell.getCell().setValue(context, cellParent, hasCell.getValue(object));
    }
}

