/*
 * Copyright 1998, Steven M. Robbins <steve@nyongwa.montreal.qc.ca>
 * $Id: ParameterEnumeration.java,v 1.2 1998/05/17 04:49:54 steve Exp $
 */

package smr.JavaDeps;


import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.io.StreamTokenizer;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.IOException;


/**
 * A list of input parameters, typically from either the command line, or a
 * file. 
 **/

public class ParameterEnumeration implements Enumeration
{
    // List of parameters given at construction time
    private String list[];
    private int index;

    // Get the tokens from the input
    private StreamTokenizer tokenizer;
    
    public ParameterEnumeration( String s[] )
    {
	list = s;
	index = 0;
    }

    public ParameterEnumeration( InputStream is )
    {
	list = null;
	tokenizer = new StreamTokenizer( new InputStreamReader( is ) );
	
	// Set up the tokenizer's tables: we care only about whitespace and non-whitespace
	tokenizer.resetSyntax();
	tokenizer.whitespaceChars(0, ' '); // ' ' = 32
	tokenizer.wordChars(' '+1, 127);
	tokenizer.whitespaceChars(128, 128+32);
        tokenizer.wordChars(128 + 33, 255);
    }
    
    public synchronized boolean hasMoreElements()
    {
	if ( list != null )
	    return index < list.length;

	try {
	    if ( tokenizer.nextToken() == StreamTokenizer.TT_EOF )
		return false;
	} catch ( IOException e ) {
	    return false;
	}
	
	tokenizer.pushBack();
	return true;
    }
    
    public synchronized Object nextElement()
    {
	if ( !hasMoreElements() )
	    throw new NoSuchElementException( "ParameterEnumeration" );

	if ( list != null )
	    return list[index++];

	try {
	    if ( tokenizer.nextToken() != StreamTokenizer.TT_WORD )
		throw new NoSuchElementException( "tokenization error" );
	} catch ( IOException e ) {
	    throw new NoSuchElementException( "tokenization error: " +
					      e.getMessage() );
	}

	return tokenizer.sval;
    }
}

