/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls.tower;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.CallInfo;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.CallKind;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.CandidateCollector;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.CandidateFactory;
import org.jetbrains.kotlin.fir.resolve.calls.tower.ProcessResult;
import org.jetbrains.kotlin.fir.resolve.calls.tower.ScopeTowerLevel;
import org.jetbrains.kotlin.fir.resolve.calls.tower.TowerGroup;
import org.jetbrains.kotlin.fir.resolve.calls.tower.TowerScopeLevel;
import org.jetbrains.kotlin.fir.resolve.calls.tower.TowerScopeLevelProcessor;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerLevelHandler;", "", "<init>", "()V", "processResult", "Lorg/jetbrains/kotlin/fir/resolve/calls/tower/ProcessResult;", "handleLevel", "collector", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CandidateCollector;", "candidateFactory", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CandidateFactory;", "info", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CallInfo;", "explicitReceiverKind", "Lorg/jetbrains/kotlin/resolve/calls/tasks/ExplicitReceiverKind;", "group", "Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerGroup;", "towerLevel", "Lorg/jetbrains/kotlin/fir/resolve/calls/tower/TowerScopeLevel;", "resolve"})
public final class TowerLevelHandler {
    @NotNull
    private ProcessResult processResult = ProcessResult.SCOPE_EMPTY;

    @NotNull
    public final ProcessResult handleLevel(@NotNull CandidateCollector collector2, @NotNull CandidateFactory candidateFactory, @NotNull CallInfo info, @NotNull ExplicitReceiverKind explicitReceiverKind, @NotNull TowerGroup group, @NotNull TowerScopeLevel towerLevel) {
        Intrinsics.checkNotNullParameter(collector2, "collector");
        Intrinsics.checkNotNullParameter(candidateFactory, "candidateFactory");
        Intrinsics.checkNotNullParameter(info, "info");
        Intrinsics.checkNotNullParameter((Object)explicitReceiverKind, "explicitReceiverKind");
        Intrinsics.checkNotNullParameter(group, "group");
        Intrinsics.checkNotNullParameter(towerLevel, "towerLevel");
        this.processResult = ProcessResult.SCOPE_EMPTY;
        TowerScopeLevelProcessor processor = new TowerScopeLevelProcessor(info, explicitReceiverKind, collector2, candidateFactory, group);
        CallKind callKind = info.getCallKind();
        if (Intrinsics.areEqual(callKind, CallKind.VariableAccess.INSTANCE)) {
            this.processResult = this.processResult.plus(towerLevel.processPropertiesByName(info, processor));
            if (!collector2.getShouldStopResolve() && towerLevel instanceof ScopeTowerLevel && !((ScopeTowerLevel)towerLevel).areThereExtensionReceiverOptions()) {
                this.processResult = this.processResult.plus(((ScopeTowerLevel)towerLevel).processObjectsByName(info, processor));
            }
        } else if (Intrinsics.areEqual(callKind, CallKind.Function.INSTANCE)) {
            this.processResult = this.processResult.plus(towerLevel.processFunctionsByName(info, processor));
        } else if (Intrinsics.areEqual(callKind, CallKind.CallableReference.INSTANCE)) {
            this.processResult = this.processResult.plus(towerLevel.processFunctionsByName(info, processor));
            this.processResult = this.processResult.plus(towerLevel.processPropertiesByName(info, processor));
        } else {
            throw new AssertionError((Object)("Unsupported call kind in tower resolver: " + info.getCallKind()));
        }
        return this.processResult;
    }
}

