/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.forwarding;

import com.sshtools.j2ssh.forwarding.ForwardingChannel;
import com.sshtools.j2ssh.forwarding.ForwardingConfigurationException;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ForwardingChannelImpl
implements ForwardingChannel {
    private static Log log = LogFactory.getLog(ForwardingChannelImpl.class);
    private String forwardType;
    private String originatingHost;
    private int originatingPort;
    private String hostToConnectOrBind;
    private int portToConnectOrBind;
    private String name;

    public ForwardingChannelImpl(String forwardType, String name, String hostToConnectOrBind, int portToConnectOrBind, String originatingHost, int originatingPort) throws ForwardingConfigurationException {
        if (!(forwardType.equals("direct-tcpip") || forwardType.equals("forwarded-tcpip") || forwardType.equals("x11"))) {
            throw new ForwardingConfigurationException("The forwarding type is invalid");
        }
        this.forwardType = forwardType;
        this.hostToConnectOrBind = hostToConnectOrBind;
        this.portToConnectOrBind = portToConnectOrBind;
        this.originatingHost = originatingHost;
        this.originatingPort = originatingPort;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getHostToConnectOrBind() {
        return this.hostToConnectOrBind;
    }

    public int getPortToConnectOrBind() {
        return this.portToConnectOrBind;
    }

    public byte[] getChannelOpenData() {
        try {
            ByteArrayWriter baw = new ByteArrayWriter();
            baw.writeString(this.hostToConnectOrBind);
            baw.writeInt(this.portToConnectOrBind);
            baw.writeString(this.originatingHost);
            baw.writeInt(this.originatingPort);
            return baw.toByteArray();
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public byte[] getChannelConfirmationData() {
        return null;
    }

    public String getChannelType() {
        return this.forwardType;
    }

    public String getOriginatingHost() {
        return this.originatingHost;
    }

    public int getOriginatingPort() {
        return this.originatingPort;
    }
}

