/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph;

import java.awt.Color;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.plugins.graph.ColumnInfoModel;
import net.sourceforge.squirrel_sql.plugins.graph.ColumnTextArea;
import net.sourceforge.squirrel_sql.plugins.graph.GraphPlugin;
import net.sourceforge.squirrel_sql.plugins.graph.IColumnTextArea;
import net.sourceforge.squirrel_sql.plugins.graph.Mode;
import net.sourceforge.squirrel_sql.plugins.graph.ModeManager;
import net.sourceforge.squirrel_sql.plugins.graph.QueryTextArea;
import net.sourceforge.squirrel_sql.plugins.graph.TableToolTipProvider;
import net.sourceforge.squirrel_sql.plugins.graph.ZoomableColumnTextArea;
import net.sourceforge.squirrel_sql.plugins.graph.nondbconst.DndCallback;

public class GraphTextAreaFactory {
    public static final Color TEXTAREA_BG = new Color(255, 255, 204);
    private ColumnTextArea _txtColumns;
    private ZoomableColumnTextArea _txtZoomColumns;
    private QueryTextArea _txtQueryTextArea;

    public GraphTextAreaFactory(String tableName, ISession session, GraphPlugin plugin, TableToolTipProvider toolTipProvider, ModeManager modeManager, DndCallback dndCallback) {
        this._txtColumns = new ColumnTextArea(toolTipProvider, dndCallback, session);
        this._txtColumns.setEditable(false);
        this._txtColumns.setBackground(TEXTAREA_BG);
        this._txtZoomColumns = new ZoomableColumnTextArea(toolTipProvider, modeManager.getZoomer(), dndCallback, session);
        this._txtZoomColumns.setBackground(TEXTAREA_BG);
        this._txtQueryTextArea = new QueryTextArea(tableName, plugin, dndCallback, session);
    }

    public int getColumnHeight() {
        JComponent bestReadyComponent = this.getBestReadyComponent();
        if (null == bestReadyComponent) {
            return 0;
        }
        return ((IColumnTextArea)((Object)bestReadyComponent)).getColumnHeight();
    }

    public JComponent getComponent(Mode mode) {
        if (Mode.ZOOM_PRINT == mode) {
            return this._txtZoomColumns;
        }
        if (Mode.DEFAULT == mode) {
            return this._txtColumns;
        }
        if (Mode.QUERY_BUILDER == mode) {
            return this._txtQueryTextArea;
        }
        throw new IllegalArgumentException("Unknown mode: " + (Object)((Object)mode));
    }

    public JComponent getBestReadyComponent() {
        if (this.getComponent(Mode.DEFAULT).isShowing() || this.getComponent(Mode.DEFAULT).isVisible() && null != this.getComponent(Mode.DEFAULT).getGraphics()) {
            return this.getComponent(Mode.DEFAULT);
        }
        if (this.getComponent(Mode.ZOOM_PRINT).isShowing() || this.getComponent(Mode.ZOOM_PRINT).isVisible() && null != this.getComponent(Mode.ZOOM_PRINT).getGraphics()) {
            return this.getComponent(Mode.ZOOM_PRINT);
        }
        if (this.getComponent(Mode.QUERY_BUILDER).isShowing() || this.getComponent(Mode.QUERY_BUILDER).isVisible() && null != this.getComponent(Mode.QUERY_BUILDER).getGraphics()) {
            return this.getComponent(Mode.QUERY_BUILDER);
        }
        return null;
    }

    public void setColumnInfoModel(ColumnInfoModel columnInfoModel) {
        this._txtColumns.setColumnInfoModel(columnInfoModel);
        this._txtZoomColumns.setColumnInfoModel(columnInfoModel);
        this._txtQueryTextArea.setColumnInfoModel(columnInfoModel);
    }

    public void addMouseListener(MouseListener ml) {
        this._txtColumns.addMouseListener(ml);
        this._txtZoomColumns.addMouseListener(ml);
        this._txtQueryTextArea.addQueryAreaMouseListener(ml);
    }

    public int getMaxWidht() {
        JComponent bestReadyComponent = this.getBestReadyComponent();
        if (null == bestReadyComponent) {
            return 0;
        }
        return ((IColumnTextArea)((Object)bestReadyComponent)).getMaxWidth();
    }
}

