/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.diff;

import java.util.List;
import org.jmeld.diff.JMChunk;
import org.jmeld.diff.JMDiff;
import org.jmeld.diff.JMRevision;
import org.jmeld.util.Ignore;
import org.jmeld.util.TokenizerFactory;
import org.jmeld.util.WordTokenizer;

public class JMDelta {
    private static boolean debug = false;
    private JMChunk original;
    private JMChunk revised;
    private Type type;
    private JMRevision revision;
    private JMRevision changeRevision;

    public JMDelta(JMChunk original, JMChunk revised) {
        this.original = original;
        this.revised = revised;
        this.initType();
    }

    void setRevision(JMRevision revision) {
        this.revision = revision;
    }

    public JMChunk getOriginal() {
        return this.original;
    }

    public JMChunk getRevised() {
        return this.revised;
    }

    public boolean isAdd() {
        return this.type == Type.ADD;
    }

    public boolean isDelete() {
        return this.type == Type.DELETE;
    }

    public boolean isChange() {
        return this.type == Type.CHANGE;
    }

    public void invalidateChangeRevision() {
        this.changeRevision = null;
    }

    public JMRevision getChangeRevision() {
        if (this.changeRevision == null) {
            this.changeRevision = this.createChangeRevision();
        }
        return this.changeRevision;
    }

    private JMRevision createChangeRevision() {
        int j;
        char[] original1 = this.revision.getOriginalString(this.original).toCharArray();
        Object[] original2 = new Character[original1.length];
        for (j = 0; j < original1.length; ++j) {
            original2[j] = new Character(original1[j]);
        }
        char[] revised1 = this.revision.getRevisedString(this.revised).toCharArray();
        Object[] revised2 = new Character[revised1.length];
        for (j = 0; j < revised1.length; ++j) {
            revised2[j] = new Character(revised1[j]);
        }
        try {
            int i;
            WordTokenizer wt = TokenizerFactory.getInnerDiffTokenizer();
            List<String> o2 = wt.getTokens(this.revision.getOriginalString(this.original));
            List<String> r2 = wt.getTokens(this.revision.getRevisedString(this.revised));
            JMRevision rev = new JMDiff().diff(o2, r2, Ignore.NULL_IGNORE);
            int[] oIndex = new int[o2.size()];
            for (i = 0; i < o2.size(); ++i) {
                oIndex[i] = o2.get(i).length();
                if (i > 0) {
                    int n = i;
                    oIndex[n] = oIndex[n] + oIndex[i - 1];
                }
                this.debug("oIndex[" + i + "] = " + oIndex[i] + " \"" + o2.get(i) + "\"");
            }
            int[] rIndex = new int[r2.size()];
            for (i = 0; i < r2.size(); ++i) {
                rIndex[i] = r2.get(i).length();
                if (i > 0) {
                    int n = i;
                    rIndex[n] = rIndex[n] + rIndex[i - 1];
                }
                this.debug("rIndex[" + i + "] = " + rIndex[i] + " \"" + r2.get(i) + "\"");
            }
            JMRevision rev2 = new JMRevision(original2, revised2);
            rev2.setIgnore(Ignore.NULL_IGNORE);
            for (JMDelta d : rev.getDeltas()) {
                JMChunk o = d.getOriginal();
                JMChunk r = d.getRevised();
                int anchor = o.getAnchor();
                int size = o.getSize();
                int oAnchor = anchor == 0 ? 0 : oIndex[anchor - 1];
                int oLength = size > 0 ? oIndex[anchor + size - 1] - oAnchor : 0;
                anchor = r.getAnchor();
                size = r.getSize();
                int rAnchor = anchor == 0 ? 0 : rIndex[anchor - 1];
                int rLength = size > 0 ? rIndex[anchor + size - 1] - rAnchor : 0;
                JMDelta d2 = new JMDelta(new JMChunk(oAnchor, oLength), new JMChunk(rAnchor, rLength));
                rev2.add(d2);
                this.debug("delta = " + d + " -> " + d2);
            }
            return rev2;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    void initType() {
        this.type = this.original.getSize() > 0 && this.revised.getSize() == 0 ? Type.DELETE : (this.original.getSize() == 0 && this.revised.getSize() > 0 ? Type.ADD : Type.CHANGE);
    }

    public boolean equals(Object o) {
        if (!(o instanceof JMDelta)) {
            return false;
        }
        JMDelta d = (JMDelta)o;
        if (this.revision != d.revision) {
            return false;
        }
        return this.original.equals(d.original) && this.revised.equals(d.revised);
    }

    private void debug(String s) {
        if (debug) {
            System.out.println(s);
        }
    }

    public String toString() {
        return (Object)((Object)this.type) + ": org[" + this.original + "] rev[" + this.revised + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Type {
        ADD,
        DELETE,
        CHANGE;

    }
}

