/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Highlighter;
import javax.swing.text.PlainDocument;
import org.jmeld.diff.JMChunk;
import org.jmeld.diff.JMDelta;
import org.jmeld.diff.JMRevision;
import org.jmeld.settings.JMeldSettings;
import org.jmeld.ui.BufferDiffPanel;
import org.jmeld.ui.FilePanelBar;
import org.jmeld.ui.search.SearchCommand;
import org.jmeld.ui.search.SearchHit;
import org.jmeld.ui.search.SearchHits;
import org.jmeld.ui.swing.DiffLabel;
import org.jmeld.ui.swing.JMHighlightPainter;
import org.jmeld.ui.swing.JMHighlighter;
import org.jmeld.ui.swing.LeftScrollPaneLayout;
import org.jmeld.ui.swing.LineNumberBorder;
import org.jmeld.ui.text.BufferDocumentChangeListenerIF;
import org.jmeld.ui.text.BufferDocumentIF;
import org.jmeld.ui.text.JMDocumentEvent;
import org.jmeld.ui.util.FontUtil;
import org.jmeld.ui.util.ImageUtil;
import org.jmeld.util.StringUtil;
import org.jmeld.util.conf.ConfigurationListenerIF;

public class FilePanel
implements BufferDocumentChangeListenerIF,
ConfigurationListenerIF {
    private static final int MAXSIZE_CHANGE_DIFF = 1000;
    private BufferDiffPanel diffPanel;
    private String name;
    private int position;
    private DiffLabel fileLabel;
    private JComboBox fileBox;
    private JScrollPane scrollPane;
    private JTextArea editor;
    private BufferDocumentIF bufferDocument;
    private JButton saveButton;
    private Timer timer;
    private SearchHits searchHits;
    private boolean selected;
    private FilePanelBar filePanelBar;

    FilePanel(BufferDiffPanel diffPanel, String name, int position) {
        this.diffPanel = diffPanel;
        this.name = name;
        this.position = position;
        this.init();
    }

    private void init() {
        this.editor = new JTextArea();
        this.editor.setDragEnabled(true);
        this.editor.setHighlighter(new JMHighlighter());
        this.editor.addFocusListener(this.getFocusListener());
        this.editor.addCaretListener(this.getCaretListener());
        this.scrollPane = new JScrollPane(this.editor);
        this.scrollPane.getViewport().setScrollMode(0);
        if ("Original".equals(this.name)) {
            LeftScrollPaneLayout layout = new LeftScrollPaneLayout();
            this.scrollPane.setLayout(layout);
            layout.syncWithScrollPane(this.scrollPane);
            this.scrollPane.getVerticalScrollBar().putClientProperty("JScrollBar.isFreeStanding", Boolean.TRUE);
        }
        this.fileBox = new JComboBox();
        this.fileBox.addActionListener(this.getFileBoxAction());
        this.fileLabel = new DiffLabel();
        this.saveButton = new JButton();
        this.saveButton.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.saveButton.setContentAreaFilled(false);
        ImageIcon icon = ImageUtil.getSmallImageIcon("stock_save");
        this.saveButton.setIcon(icon);
        this.saveButton.setDisabledIcon(ImageUtil.createTransparentIcon(icon));
        this.saveButton.addActionListener(this.getSaveButtonAction());
        this.timer = new Timer(100, this.refresh());
        this.timer.setRepeats(false);
        this.initConfiguration();
        this.getConfiguration().addConfigurationListener(this);
    }

    FilePanelBar getFilePanelBar() {
        if (this.filePanelBar == null) {
            this.filePanelBar = new FilePanelBar(this);
        }
        return this.filePanelBar;
    }

    JComboBox getFileBox() {
        return this.fileBox;
    }

    DiffLabel getFileLabel() {
        return this.fileLabel;
    }

    JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public JTextArea getEditor() {
        return this.editor;
    }

    public BufferDocumentIF getBufferDocument() {
        return this.bufferDocument;
    }

    JButton getSaveButton() {
        return this.saveButton;
    }

    public void setBufferDocument(BufferDocumentIF bd) {
        try {
            if (this.bufferDocument != null) {
                this.bufferDocument.removeChangeListener(this);
                PlainDocument previousDocument = this.bufferDocument.getDocument();
                if (previousDocument != null) {
                    previousDocument.removeUndoableEditListener(this.diffPanel.getUndoHandler());
                }
            }
            this.bufferDocument = bd;
            PlainDocument document = this.bufferDocument.getDocument();
            if (document != null) {
                this.editor.setDocument(document);
                this.editor.setTabSize(this.getConfiguration().getEditor().getTabSize());
                this.bufferDocument.addChangeListener(this);
                document.addUndoableEditListener(this.diffPanel.getUndoHandler());
            }
            String fileName = this.bufferDocument.getName();
            this.fileBox.addItem(fileName);
            this.fileBox.setSelectedItem(fileName);
            this.fileLabel.setText(fileName);
            this.checkActions();
            this.initConfiguration();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this.diffPanel, "Could not read file: " + this.bufferDocument.getName() + "\n" + ex.getMessage(), "Error opening file", 0);
            return;
        }
    }

    void updateFileLabel(String name1, String name2) {
        this.fileLabel.setText(name1, name2);
    }

    void doStopSearch() {
        this.searchHits = null;
        this.reDisplay();
    }

    private void checkSearch() {
        this.doSearch();
    }

    SearchHits doSearch() {
        SearchCommand searchCommand = this.diffPanel.getSearchCommand();
        if (searchCommand == null) {
            return null;
        }
        String searchText = searchCommand.getSearchText();
        boolean regularExpression = searchCommand.isRegularExpression();
        BufferDocumentIF doc = this.getBufferDocument();
        int numberOfLines = doc.getNumberOfLines();
        this.searchHits = new SearchHits();
        if (!StringUtil.isEmpty(searchText)) {
            for (int line = 0; line < numberOfLines; ++line) {
                int index;
                String text = doc.getLineText(line);
                if (regularExpression) continue;
                int fromIndex = 0;
                while ((index = text.indexOf(searchText, fromIndex)) != -1) {
                    int offset = this.bufferDocument.getOffsetForLine(line);
                    if (offset < 0) continue;
                    SearchHit searchHit = new SearchHit(line, offset + index, searchText.length());
                    this.searchHits.add(searchHit);
                    fromIndex = index + searchHit.getSize() + 1;
                }
            }
        }
        this.reDisplay();
        return this.getSearchHits();
    }

    void setShowLineNumbers(boolean showLineNumbers) {
        String propertyName = "JMeld.originalBorder";
        Border originalBorder = (Border)this.editor.getClientProperty(propertyName);
        if (showLineNumbers) {
            if (originalBorder == null) {
                originalBorder = this.editor.getBorder();
                this.editor.setBorder(new LineNumberBorder(this));
                this.editor.putClientProperty(propertyName, originalBorder);
            }
        } else if (originalBorder != null) {
            this.editor.setBorder(originalBorder);
            this.editor.putClientProperty(propertyName, null);
        }
    }

    SearchHits getSearchHits() {
        return this.searchHits;
    }

    public void reDisplay() {
        this.getHighlighter().setDoNotRepaint(true);
        this.removeHighlights();
        this.paintSearchHighlights();
        this.paintRevisionHighlights();
        this.getHighlighter().setDoNotRepaint(false);
        this.getHighlighter().repaint();
    }

    private void paintSearchHighlights() {
        if (this.searchHits != null) {
            for (SearchHit sh : this.searchHits.getSearchHits()) {
                this.setHighlight(JMHighlighter.LAYER2, sh.getFromOffset(), sh.getToOffset(), this.searchHits.isCurrent(sh) ? JMHighlightPainter.CURRENT_SEARCH : JMHighlightPainter.SEARCH);
            }
        }
    }

    private void paintRevisionHighlights() {
        if (this.bufferDocument == null) {
            return;
        }
        JMRevision revision = this.diffPanel.getCurrentRevision();
        if (revision == null) {
            return;
        }
        for (JMDelta delta : revision.getDeltas()) {
            int toOffset2;
            int fromOffset2;
            JMRevision changeRev;
            int toOffset;
            int fromOffset;
            JMChunk original = delta.getOriginal();
            JMChunk revised = delta.getRevised();
            if ("Original".equals(this.name)) {
                fromOffset = this.bufferDocument.getOffsetForLine(original.getAnchor());
                if (fromOffset < 0 || (toOffset = this.bufferDocument.getOffsetForLine(original.getAnchor() + original.getSize())) < 0) continue;
                if (delta.isAdd()) {
                    this.setHighlight(fromOffset, fromOffset + 1, JMHighlightPainter.ADDED_LINE);
                    continue;
                }
                if (delta.isDelete()) {
                    this.setHighlight(fromOffset, toOffset, JMHighlightPainter.DELETED);
                    continue;
                }
                if (!delta.isChange()) continue;
                if (original.getSize() < 1000 && revised.getSize() < 1000 && (changeRev = delta.getChangeRevision()) != null) {
                    for (JMDelta changeDelta : changeRev.getDeltas()) {
                        JMChunk changeOriginal = changeDelta.getOriginal();
                        if (changeOriginal.getSize() <= 0) continue;
                        fromOffset2 = fromOffset + changeOriginal.getAnchor();
                        toOffset2 = fromOffset2 + changeOriginal.getSize();
                        this.setHighlight(JMHighlighter.LAYER1, fromOffset2, toOffset2, JMHighlightPainter.CHANGED_LIGHTER);
                    }
                }
                this.setHighlight(fromOffset, toOffset, JMHighlightPainter.CHANGED);
                continue;
            }
            if (!"Revised".equals(this.name) || (fromOffset = this.bufferDocument.getOffsetForLine(revised.getAnchor())) < 0 || (toOffset = this.bufferDocument.getOffsetForLine(revised.getAnchor() + revised.getSize())) < 0) continue;
            if (delta.isAdd()) {
                this.setHighlight(fromOffset, toOffset, JMHighlightPainter.ADDED);
                continue;
            }
            if (delta.isDelete()) {
                this.setHighlight(fromOffset, fromOffset + 1, JMHighlightPainter.DELETED_LINE);
                continue;
            }
            if (!delta.isChange()) continue;
            if (original.getSize() < 1000 && revised.getSize() < 1000 && (changeRev = delta.getChangeRevision()) != null) {
                for (JMDelta changeDelta : changeRev.getDeltas()) {
                    JMChunk changeRevised = changeDelta.getRevised();
                    if (changeRevised.getSize() <= 0) continue;
                    fromOffset2 = fromOffset + changeRevised.getAnchor();
                    toOffset2 = fromOffset2 + changeRevised.getSize();
                    this.setHighlight(JMHighlighter.LAYER1, fromOffset2, toOffset2, JMHighlightPainter.CHANGED_LIGHTER);
                }
            }
            this.setHighlight(fromOffset, toOffset, JMHighlightPainter.CHANGED);
        }
    }

    private JMHighlighter getHighlighter() {
        return (JMHighlighter)this.editor.getHighlighter();
    }

    private void removeHighlights() {
        JMHighlighter jmhl = this.getHighlighter();
        jmhl.removeHighlights(JMHighlighter.LAYER0);
        jmhl.removeHighlights(JMHighlighter.LAYER1);
        jmhl.removeHighlights(JMHighlighter.LAYER2);
    }

    private void setHighlight(int offset, int size, Highlighter.HighlightPainter highlight) {
        this.setHighlight(JMHighlighter.LAYER0, offset, size, highlight);
    }

    private void setHighlight(Integer layer, int offset, int size, Highlighter.HighlightPainter highlight) {
        try {
            this.getHighlighter().addHighlight(layer, offset, size, highlight);
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
    }

    public ActionListener getSaveButtonAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    FilePanel.this.bufferDocument.write();
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(SwingUtilities.getRoot(FilePanel.this.editor), "Could not save file: " + FilePanel.this.bufferDocument.getName() + "\n" + ex.getMessage(), "Error saving file", 0);
                }
            }
        };
    }

    public ActionListener getFileBoxAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
            }
        };
    }

    public void documentChanged(JMDocumentEvent de) {
        if (de.getStartLine() == -1 && de.getDocumentEvent() == null) {
            this.timer.restart();
        } else if (!this.diffPanel.revisionChanged(de)) {
            this.timer.restart();
        }
        this.checkSearch();
        this.checkActions();
    }

    private void checkActions() {
        if (this.saveButton.isEnabled() != this.isDocumentChanged()) {
            this.saveButton.setEnabled(this.isDocumentChanged());
        }
        this.diffPanel.checkActions();
    }

    boolean isDocumentChanged() {
        return this.bufferDocument != null ? this.bufferDocument.isChanged() : false;
    }

    private ActionListener refresh() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                FilePanel.this.diffPanel.diff();
            }
        };
    }

    public FocusListener getFocusListener() {
        return new FocusAdapter(){

            public void focusGained(FocusEvent fe) {
                FilePanel.this.diffPanel.setSelectedPanel(FilePanel.this);
            }
        };
    }

    public CaretListener getCaretListener() {
        return new CaretListener(){

            public void caretUpdate(CaretEvent fe) {
                FilePanel.this.updateFilePanelBar();
            }
        };
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.updateFilePanelBar();
        this.checkSearch();
    }

    private void updateFilePanelBar() {
        if (this.filePanelBar != null) {
            this.filePanelBar.update();
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void configurationChanged() {
        this.initConfiguration();
    }

    private void initConfiguration() {
        JMeldSettings c = this.getConfiguration();
        this.setShowLineNumbers(c.getEditor().getShowLineNumbers());
        Font font = c.getEditor().isCustomFontEnabled() ? c.getEditor().getFont() : null;
        font = font != null ? font : FontUtil.defaultTextAreaFont;
        this.editor.setFont(font);
        FontMetrics fm = this.editor.getFontMetrics(font);
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement(fm.getHeight());
        this.getEditor().setTabSize(c.getEditor().getTabSize());
        boolean readonly = false;
        if (this.position == 0) {
            readonly = c.getEditor().getLeftsideReadonly();
        } else if (this.position == 2) {
            readonly = c.getEditor().getRightsideReadonly();
        }
        if (this.bufferDocument != null && this.bufferDocument.isReadonly()) {
            readonly = true;
        }
        this.editor.setEditable(!readonly);
    }

    private JMeldSettings getConfiguration() {
        return JMeldSettings.getInstance();
    }

    public String getSelectedText() {
        return this.editor.getSelectedText();
    }
}

