/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jmeld.ui.swing.MultiLineHeaderRenderer;

public class ColumnGroup {
    protected TableCellRenderer renderer;
    protected Vector v;
    protected String text;

    public ColumnGroup(String text) {
        this(null, text);
    }

    public ColumnGroup(TableCellRenderer renderer, String text) {
        if (renderer == null) {
            MultiLineHeaderRenderer multiHeaderRenderer = new MultiLineHeaderRenderer();
            this.renderer = multiHeaderRenderer;
        } else {
            this.renderer = renderer;
        }
        this.text = text;
        this.v = new Vector();
    }

    public void add(Object obj) {
        if (obj == null) {
            return;
        }
        this.v.addElement(obj);
    }

    public Vector getColumnGroups(TableColumn c, Vector g) {
        g.addElement(this);
        if (this.v.contains(c)) {
            return g;
        }
        Enumeration enumerate = this.v.elements();
        while (enumerate.hasMoreElements()) {
            Vector groups;
            Object obj = enumerate.nextElement();
            if (!(obj instanceof ColumnGroup) || (groups = ((ColumnGroup)obj).getColumnGroups(c, (Vector)g.clone())) == null) continue;
            return groups;
        }
        return null;
    }

    public TableCellRenderer getHeaderRenderer() {
        return this.renderer;
    }

    public void setHeaderRenderer(TableCellRenderer renderer) {
        if (renderer != null) {
            this.renderer = renderer;
        }
    }

    public Object getHeaderValue() {
        return this.text;
    }

    public Dimension getSize(JTable table) {
        Component comp = this.renderer.getTableCellRendererComponent(table, this.getHeaderValue(), false, false, -1, -1);
        int height = comp.getPreferredSize().height;
        int width = 0;
        Enumeration enumerate = this.v.elements();
        while (enumerate.hasMoreElements()) {
            Object obj = enumerate.nextElement();
            if (obj instanceof TableColumn) {
                TableColumn aColumn = (TableColumn)obj;
                width += aColumn.getWidth();
                continue;
            }
            width += ((ColumnGroup)obj).getSize((JTable)table).width;
        }
        return new Dimension(width, height);
    }

    public String toString() {
        return super.toString() + ":" + this.text;
    }
}

