/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.dom;

import com.jclark.xsl.dom.CommentNode;
import com.jclark.xsl.dom.ContainerNode;
import com.jclark.xsl.dom.ElementNode;
import com.jclark.xsl.dom.NodeBase;
import com.jclark.xsl.dom.ProcessingInstructionNode;
import com.jclark.xsl.dom.TextNode;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.SafeNodeIterator;

class SiblingNodeIterator
implements SafeNodeIterator {
    ContainerNode parent;
    int childIndex;
    NodeBase node;
    org.w3c.dom.Node domNode;
    int preserveSpace = -1;

    private static final boolean hasNonWhitespaceChar(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            switch (string.charAt(n2)) {
                default: {
                    return true;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
            }
            ++n2;
        }
        return false;
    }

    SiblingNodeIterator(ContainerNode containerNode, int n, org.w3c.dom.Node node) {
        this.parent = containerNode;
        this.childIndex = n;
        this.domNode = node;
    }

    final void advance() {
        while (true) {
            org.w3c.dom.Node node;
            if ((node = this.domNode.getNextSibling()) != null) {
                this.domNode = node;
                return;
            }
            node = this.domNode.getParentNode();
            if (node.equals(this.parent.domNode)) {
                this.domNode = null;
                return;
            }
            this.domNode = node;
        }
    }

    public Node next() {
        ++this.childIndex;
        block13: while (this.domNode != null) {
            switch (this.domNode.getNodeType()) {
                case 1: {
                    ElementNode elementNode = new ElementNode(this.domNode, this.parent, this.childIndex);
                    this.advance();
                    return elementNode;
                }
                case 8: {
                    if (this.parent.root.includeComments) {
                        CommentNode commentNode = new CommentNode(this.domNode, this.parent, this.childIndex);
                        this.advance();
                        return commentNode;
                    }
                    this.advance();
                    break;
                }
                case 7: {
                    if (this.parent.root.includeProcessingInstructions) {
                        ProcessingInstructionNode processingInstructionNode = new ProcessingInstructionNode(this.domNode, this.parent, this.childIndex);
                        this.advance();
                        return processingInstructionNode;
                    }
                    this.advance();
                    break;
                }
                case 3: 
                case 4: {
                    if (this.preserveSpace == -1) {
                        this.preserveSpace = this.parent.getPreserveSpace() ? 1 : 0;
                    }
                    boolean bl = this.preserveSpace == 1;
                    TextNode textNode = new TextNode(this.domNode, this.parent, this.childIndex);
                    if (!bl && SiblingNodeIterator.hasNonWhitespaceChar(this.domNode.getNodeValue())) {
                        bl = true;
                    }
                    this.advance();
                    block14: while (this.domNode != null) {
                        switch (this.domNode.getNodeType()) {
                            case 3: 
                            case 4: {
                                Object object = this.domNode.getNodeValue();
                                if (!bl && SiblingNodeIterator.hasNonWhitespaceChar((String)object)) {
                                    bl = true;
                                }
                                textNode.merge((String)object);
                                this.advance();
                                continue block14;
                            }
                            case 5: {
                                Object object = this.domNode.getFirstChild();
                                if (object == null) {
                                    this.advance();
                                    continue block14;
                                }
                                this.domNode = object;
                                continue block14;
                            }
                            case 7: {
                                if (this.parent.root.includeProcessingInstructions) break block14;
                                this.advance();
                                continue block14;
                            }
                            case 8: {
                                if (this.parent.root.includeComments) break block14;
                                this.advance();
                                continue block14;
                            }
                        }
                    }
                    if (!bl) continue block13;
                    return textNode;
                }
                case 5: {
                    org.w3c.dom.Node node = this.domNode.getFirstChild();
                    if (node == null) {
                        this.advance();
                        break;
                    }
                    this.domNode = node;
                    break;
                }
                default: {
                    this.advance();
                }
            }
        }
        return null;
    }

    static int computeChildIndex(ContainerNode containerNode, org.w3c.dom.Node node) {
        int n = -1;
        boolean bl = false;
        int n2 = 0;
        block7: while (true) {
            org.w3c.dom.Node node2;
            switch (node.getNodeType()) {
                case 1: {
                    ++n2;
                    bl = false;
                    break;
                }
                case 8: {
                    if (!containerNode.root.includeComments) break;
                    bl = false;
                    ++n2;
                    break;
                }
                case 7: {
                    if (!containerNode.root.includeProcessingInstructions) break;
                    bl = false;
                    ++n2;
                    break;
                }
                case 3: 
                case 4: {
                    if (bl) break;
                    if (n == -1) {
                        int n3 = n = containerNode.getPreserveSpace() ? 1 : 0;
                    }
                    if (n != 1 && !SiblingNodeIterator.hasNonWhitespaceChar(node.getNodeValue())) break;
                    bl = true;
                    ++n2;
                    break;
                }
                case 5: {
                    node2 = node.getLastChild();
                    if (node2 == null) break;
                    node = node2;
                    continue block7;
                }
                default: {
                    bl = false;
                }
            }
            do {
                if ((node2 = node.getPreviousSibling()) == null) continue;
                node = node2;
                continue block7;
            } while (!(node = node.getParentNode()).equals(containerNode.domNode));
            break;
        }
        return n2;
    }
}

